/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XBaseEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.chat.LINK_TYPE;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.data.middle.dataobjects.task.XTask;
import ca.infodata.ofys.data.middle.dataobjects.task.XTaskPriority;
import ca.infodata.ofys.data.middle.dataobjects.task.XTaskProgress;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.CSite;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.date.LocalDate;

public class CTask
extends CEditableDataObject {
    private static final long serialVersionUID = 1L;
    public String className = CTask.class.getSimpleName();
    public int uid;
    public String fromUserNEmp;
    public String fromUserNClin;
    public String fromUserNMd;
    public String toUserN;
    public String toGroupN;
    public String date;
    public String dueDT;
    public String compDT;
    public String remDTDone;
    public Integer id;
    public String note;
    public Integer fromUser;
    public Integer toUser;
    public Integer toGroup;
    public XTaskPriority priority;
    public XTaskProgress progress;
    public Long createDatetime;
    public Long dueDatetime;
    public Long completionDatetime;
    public String patientName;
    public Boolean autoSendReminder;
    public Long timeReminderDone;
    public LINK_TYPE linkType;
    public Integer idLink;
    public Integer idPatient;
    public CPatient patient;
    public String patientText;
    public Boolean isDeleted;
    public boolean isLate;

    public CTask(XTask task) {
        this.init(task);
    }

    public void init(XTask task) {
        XPersonGroup personGroup;
        XBaseEmployee emp;
        XBaseProfessionnal p;
        XBaseUser user;
        super.init((IEditableDataObject)task);
        this.id = task.getId();
        this.uid = Utils.getNewAtomicInteger();
        this.date = Utils.getDateTimeFromLong(task.getCreateDatetime());
        this.note = task.getNote();
        this.fromUser = task.getFromUser();
        this.toUser = task.getToUser();
        this.toGroup = task.getToGroup();
        this.priority = task.getPriority();
        this.progress = task.getProgress();
        this.createDatetime = task.getCreateDatetime();
        this.dueDatetime = task.getDueDatetime();
        this.dueDT = Utils.getDateTimeFromLong(this.dueDatetime);
        this.completionDatetime = task.getCompletionDatetime();
        this.compDT = Utils.getDateTimeFromLong(this.completionDatetime);
        this.patientName = task.getPatient() == null ? null : task.getPatient().getNameBirthdateSex();
        this.autoSendReminder = task.getAutoSendReminder();
        this.timeReminderDone = task.getTimeReminderDone();
        this.remDTDone = Utils.getDateTimeFromLong(this.timeReminderDone);
        this.linkType = task.getLinkType();
        this.idLink = task.getIdLink();
        this.version = task.getVersion();
        this.modificationStatus = task.getModificationStatus().toString();
        this.idPatient = task.getIdPatient();
        this.patient = task.getPatient() == null ? null : new CPatient(task.getPatient());
        this.patientText = task.getPatient() == null ? null : task.getPatient().getNameBirthdateSex();
        this.isDeleted = task.getIsDeleted();
        if (this.fromUser != null && (user = Application.get().getPersonPluginController().getUser(this.fromUser)) != null && user.getIdPerson() != null) {
            p = Application.get().getPersonPluginController().getBaseProfessionnalByIdPerson(user.getIdPerson(), false);
            if (p != null) {
                if (p.isProfTx()) {
                    this.fromUserNMd = p.getName();
                } else {
                    this.fromUserNClin = p.getName();
                }
            } else {
                emp = Application.get().getPersonPluginController().getBaseEmployeeByIdPerson(user.getIdPerson());
                this.fromUserNEmp = emp != null ? emp.getName() : user.str;
            }
        }
        if (this.toUser != null && (user = Application.get().getPersonPluginController().getUser(this.toUser)) != null && user.getIdPerson() != null) {
            p = Application.get().getPersonPluginController().getBaseProfessionnalByIdPerson(user.getIdPerson(), false);
            this.toUserN = p != null ? p.getName() : ((emp = Application.get().getPersonPluginController().getBaseEmployeeByIdPerson(user.getIdPerson())) != null ? emp.getName() : user.str);
        }
        if (this.toGroup != null && (personGroup = Application.get().getPersonPluginController().getPersonGroupById(this.toGroup, false)) != null) {
            this.toGroupN = personGroup.getName();
        }
        if (this.dueDatetime != null && this.dueDatetime.compareTo(LocalDate.today().toTimeInMillisUTC()) < 0) {
            this.isLate = this.completionDatetime == null;
        }
    }

    public XTask x() {
        XTask res = new XTask();
        super.x((EditableDataObject)res);
        res.setId(this.id);
        res.setNote(this.note);
        res.setFromUser(this.fromUser);
        res.setToUser(this.toUser);
        res.setToGroup(this.toGroup);
        res.setPriority(this.priority);
        res.setProgress(this.progress);
        res.setCreateDatetime(this.createDatetime);
        res.setDueDatetime(Utils.getDateTimeFromString(this.dueDT));
        res.setCompletionDatetime(this.completionDatetime);
        res.setAutoSendReminder(this.autoSendReminder);
        res.setTimeReminderDone(this.timeReminderDone);
        res.setLinkType(this.linkType);
        res.setIdLink(this.idLink);
        res.setIdPatient(this.idPatient);
        res.setIsDeleted(this.isDeleted);
        return res;
    }

    public static CSite c(XSite x) {
        return x == null ? null : new CSite(x);
    }

    public <T> CEditableDataObject convertc(T type) {
        XTask x = (XTask)XTask.class.cast(type);
        this.init(x);
        return this;
    }

    public XTask convertx() {
        return this.x();
    }
}

