/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPreferredTime;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPriority;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.dashboard.models.CLabelDef;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class CPatientRecall
extends CEditableDataObject {
    private static final long serialVersionUID = 1L;
    public String className = CPatientRecall.class.getSimpleName();
    public Long activityDate;
    public CPatient patient;
    public int uid;
    public Integer id;
    public String reason;
    public String dateRecall;
    public String dateCreated;
    public XPriority priority;
    public XPreferredTime preferredTime;
    public XStatus status;
    public Integer professionnal;
    public String profName;
    public Integer referringProfessionnal;
    public String refProfName;
    public boolean isLate;
    public List<CLabelDef> labels;
    public Boolean isShowPatient = Boolean.FALSE;

    public CPatientRecall(XPatientRecall recall) {
        this.init(recall);
    }

    public void init(XPatientRecall recall) {
        XBaseProfessionnal p;
        super.init((IEditableDataObject)recall);
        this.uid = Utils.getNewAtomicInteger();
        this.activityDate = null;
        this.patient = recall.getPatient() == null ? null : new CPatient((XPatient)recall.getPatient());
        this.id = recall.getId();
        this.reason = recall.getReason();
        this.dateRecall = null == recall.getDateRecall() ? null : recall.getDateRecall().formatHyphen();
        this.dateCreated = null == recall.getDateCreated() ? null : recall.getDateCreated().formatHyphen();
        this.priority = recall.getPriority();
        this.preferredTime = recall.getPreferredTime();
        this.status = recall.getStatus();
        this.professionnal = recall.getProfessionnal();
        if (this.professionnal != null && (p = Application.get().getPersonPluginController().getBaseProfessionnal(this.professionnal)) != null) {
            this.profName = p.getName();
        }
        this.referringProfessionnal = recall.getReferringProfessionnal();
        if (this.referringProfessionnal != null && (p = Application.get().getPersonPluginController().getBaseProfessionnal(this.referringProfessionnal)) != null) {
            this.refProfName = p.getName();
        }
        if (recall.getDateRecall() != null && recall.getDateRecall().before((IPartialDate)LocalDate.today())) {
            this.isLate = this.status == null || this.status.value == 1;
        }
        this.labels = recall.getLabels() == null ? null : CLabelDef.XLablelToCList(recall.getLabels());
    }

    public static CPatientRecall c(XPatientRecall x) {
        return x == null ? null : new CPatientRecall(x);
    }

    public static List<CPatientRecall> xToCList(List<XPatientRecall> lst) {
        ArrayList<CPatientRecall> res = new ArrayList<CPatientRecall>();
        if (lst != null) {
            for (int i = 0; i < lst.size(); ++i) {
                res.add(new CPatientRecall(lst.get(i)));
            }
        }
        return res;
    }

    public XPatientRecall x() {
        XPatientRecall res = new XPatientRecall();
        super.x((EditableDataObject)res);
        res.setPatient((IPatient)this.patient.convertx());
        res.setId(this.id);
        res.setReason(this.reason);
        res.setDateRecall(Utils.strToLocalDate(this.dateRecall));
        res.setDateCreated(Utils.strToLocalDate(this.dateCreated));
        res.setPriority(this.priority);
        res.setPreferredTime(this.preferredTime);
        res.setStatus(this.status);
        res.setProfessionnal(this.professionnal);
        res.setReferringProfessionnal(this.referringProfessionnal);
        res.setLabels(CLabelDef.CLablelToXList(this.labels));
        return res;
    }

    public <T> CEditableDataObject convertc(T type) {
        XPatientRecall x = (XPatientRecall)XPatientRecall.class.cast(type);
        this.init(x);
        return this;
    }

    public XPatientRecall convertx() {
        return this.x();
    }
}

