/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.accessor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.ISaveAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractDashboardAccessorClient {
    private static final Logger logger = Logger.getLogger(AbstractDashboardAccessorClient.class.getName());

    public ReturnObject save(IDataObject dataObject, boolean askQuestion, ISaveAccessor saveAccessor) {
        XSession session;
        ReturnObject returnObject;
        block12: {
            returnObject = null;
            session = Application.get().getGlobalInstances().getSession();
            if (session != null) {
                try {
                    if (dataObject instanceof IMinimalEditableDataObject) {
                        IStatus validStatus = ((IMinimalEditableDataObject)dataObject).valid();
                        IStatus validQuestionStatus = ((IMinimalEditableDataObject)dataObject).validQuestion();
                        if (!validStatus.isOK() || !validQuestionStatus.isOK()) {
                            returnObject = new ReturnObject();
                            returnObject.setObj((Object)dataObject);
                            if (!validStatus.isOK()) {
                                returnObject.getStatus().add(validStatus);
                            } else if (!validQuestionStatus.isOK()) {
                                returnObject.getStatus().add(validQuestionStatus);
                            }
                        } else {
                            returnObject = saveAccessor.save(dataObject, askQuestion);
                        }
                        break block12;
                    }
                    returnObject = saveAccessor.save(dataObject, askQuestion);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, String.format("Error in save call. {session=%s, dataObject=%s }", session, dataObject), e);
                    returnObject = new ReturnObject();
                    returnObject.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, (Throwable)e));
                }
            } else if (session == null) {
                returnObject = new ReturnObject();
                returnObject.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, "Aucune session active"));
            }
        }
        if (returnObject != null && returnObject.getStatus() != null && returnObject.getStatus().isOkToProceed() && returnObject.getObj() instanceof IDataObject) {
            Application.get().getGlobalInstances().getNotificationSystem().sendDataObjectUpdatedNotification((IDataObject)returnObject.getObj(), session);
        }
        return returnObject;
    }
}

