/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.template;

import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.TypeDeMesure;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DNum
extends DField {
    public Number max;
    public Integer digits;
    public TypeDeMesure typeDeMesure = TypeDeMesure.S_O;
    public static Pattern pattern = Pattern.compile("<num\\s*" + nameRegExp + "(min=(\\d+))?\\s*(max=(\\d+))?\\s*(digits=(\\d+))?\\s*(typeDeMesure=(\\d+))?\\s*(required)?\\s*/>");

    public DNum() {
    }

    public DNum(String name, Number max, Integer digits, TypeDeMesure typeDeMesure, boolean required) {
        this.name = name;
        this.max = max;
        this.digits = digits;
        this.required = required;
        this.typeDeMesure = typeDeMesure == null ? TypeDeMesure.S_O : typeDeMesure;
    }

    @Override
    public String format() {
        String s = "<num name=\"" + this.name + "\" ";
        if (this.max != null) {
            s = s + "max=" + this.max + " ";
        }
        if (this.digits != null) {
            s = s + "digits=" + this.digits + " ";
        }
        if (this.typeDeMesure != null) {
            s = s + "typeDeMesure=" + this.typeDeMesure.getValue() + " ";
        }
        if (this.required) {
            s = s + "required";
        }
        s = s + "/>";
        return s;
    }

    @Override
    public String formatMedo() {
        String s = "${" + this.name + ";";
        int n = 0;
        if (this.max != null) {
            n = Math.max(n, this.max.toString().length());
        }
        if (n != 0) {
            s = s + StringUtils.toLength((char)'9', (int)n);
        }
        if (this.digits != null) {
            s = s + "." + StringUtils.toLength((char)'9', (int)this.digits);
        }
        s = s + "}";
        return s;
    }

    public static List<DField> parse(String text) {
        ArrayList<DField> list = new ArrayList<DField>();
        Matcher matcher = pattern.matcher(text);
        int start = 0;
        while (matcher.find(start)) {
            DNum d = new DNum();
            d.start = matcher.start();
            d.end = matcher.end();
            d.name = matcher.group(2);
            d.max = matcher.group(6) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(6)));
            d.digits = matcher.group(8) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(8)));
            d.typeDeMesure = matcher.group(10) == null ? TypeDeMesure.S_O : TypeDeMesure.from(Integer.parseInt(matcher.group(10)));
            d.required = StringUtils.isNotBlank((String)matcher.group(11));
            list.add(d);
            start = matcher.end();
        }
        return list;
    }
}

