/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.encounter.pdf;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.encounter.pdf.IPdfExceptionFieldMapping;
import ca.infodata.ofys.client.modules.encounter.pdf.PdfExceptionFields;
import ca.infodata.ofys.client.modules.encounter.pdf.PrescriptionLinkUrlPdf;
import ca.infodata.ofys.client.util.DownloadSupplierWithRetry;
import ca.infodata.ofys.client.util.Util;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.dashboard.models.PrescriptionPdfLinkInput;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class PrescriptionPdfLinkController {
    private static final Logger logger = Logger.getLogger(PrescriptionPdfLinkInput.class.getName());
    private final PrescriptionLinkUrlPdf input;
    private final String url;

    public PrescriptionPdfLinkController(String url, PrescriptionLinkUrlPdf input) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new NullPointerException("url");
        }
        if (input == null) {
            throw new NullPointerException("input");
        }
        this.url = url;
        this.input = input;
    }

    public byte[] fillAcroFields() {
        try {
            String ss = this.url;
            int idxNom = StringUtils.lastIndexOf((CharSequence)ss, (CharSequence)"/") + 1;
            String fileName = ss.substring(idxNom);
            String docNumber = fileName.substring(0, fileName.indexOf(46));
            String resourceName = fileName;
            byte[] sourcePdf = Application.get().getResourceDelegate().get(resourceName, () -> new DownloadSupplierWithRetry(this.url).get());
            PdfExceptionFields fields = new PdfExceptionFields();
            IPdfExceptionFieldMapping mapping = fields.mapPdfs.containsKey(docNumber) ? fields.mapPdfs.get(docNumber) : fields.mapPdfs.get("0000");
            if (mapping != null) {
                byte[] filledPdf = this.fillAcroFields(sourcePdf, mapping, fields.mapPdfs.get("0000"));
                return filledPdf;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to fill pdf:" + this.url, e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fillAcroFields(byte[] sourcePdf, IPdfExceptionFieldMapping fm, IPdfExceptionFieldMapping fm0000) throws Exception {
        OutputStream outputStream;
        PdfReader reader;
        block52: {
            reader = null;
            outputStream = null;
            PdfStamper stamper = null;
            try {
                String rxTeneur;
                String rxFormat;
                reader = new PdfReader(sourcePdf);
                try {
                    Field f = reader.getClass().getDeclaredField("encrypted");
                    f.setAccessible(true);
                    f.set(reader, false);
                }
                catch (Exception f) {
                    // empty catch block
                }
                outputStream = new ByteArrayOutputStream(sourcePdf.length);
                stamper = new PdfStamper(reader, outputStream);
                XPrescription rx = this.input.rx;
                XPatient pt = this.input.pt;
                XBaseProfessionnal prof = this.input.prof;
                XSite site = this.input.site;
                String keyRxFormat = "(forme).*(pharma).*";
                String keyRxTeneur = "(teneur)";
                String keyRxName = "(nom).*((m\u00e9dicament)|(medicament))";
                String string = rx == null ? "" : (rxFormat = rx.getFormat() == null ? "" : rx.getFormat().description());
                String string2 = rx == null ? "" : (rxTeneur = rx.getStrength() == null ? "" : rx.getStrength().getStrength());
                String rxName = rx == null || rx.getStrength() == null ? "" : (StringUtils.isBlank((CharSequence)rx.getStrength().getName()) ? rx.getStrength().getBaseName() : rx.getStrength().getName().replace(rxTeneur, ""));
                String ptName = pt.getName();
                String ptDDN = LocalDateFormat.nullSafeFormat((LocalDate)pt.getBirthDate(), (String)"yyyyMMdd");
                String ptNAM = pt.getHealthInsuranceNumber() == null ? "" : pt.getHealthInsuranceNumber();
                String ptAdresse = pt.getStreet() == null ? "" : pt.getStreet();
                String ptVille = pt.getCity() == null ? "" : pt.getCity().getName();
                String ptCP = pt.getPostalCode() == null ? "" : pt.getPostalCode();
                String ptTel = pt.getFirstContactInformationContact() == null ? "" : pt.getFirstContactInformationContact();
                String mdName = prof.getName() == null ? "" : prof.getName();
                String noProf = prof.getCode() == null ? "" : prof.getCode();
                String mdAdresse = site.getStreet() == null ? "" : site.getStreet();
                String mdVille = (String)StringUtils.defaultIfEmpty((CharSequence)(site.getCity() == null ? "" : site.getCity().getName()), (CharSequence)"");
                String mdCP = site.getPostalCode() == null ? "" : site.getPostalCode();
                String mdIndTel = (String)StringUtils.defaultIfEmpty((CharSequence)(site.getPhonenumber1() == null || site.getPhonenumber1().length() != 10 ? "" : site.getPhonenumber1().substring(0, 3)), (CharSequence)"");
                String mdTel = (String)StringUtils.defaultIfEmpty((CharSequence)(site.getPhonenumber1() == null || site.getPhonenumber1().length() != 10 ? site.getPhonenumber1() : site.getPhonenumber1().substring(3)), (CharSequence)"");
                String mdIndFax = (String)StringUtils.defaultIfEmpty((CharSequence)(site.getPhonenumber2() == null || site.getPhonenumber2().length() != 10 ? "" : site.getPhonenumber2().substring(0, 3)), (CharSequence)"");
                String mdFax = (String)StringUtils.defaultIfEmpty((CharSequence)(site.getPhonenumber2() == null || site.getPhonenumber2().length() != 10 ? "" : site.getPhonenumber2().substring(3)), (CharSequence)"");
                String dateSignature = LocalDateFormat.format((LocalDate)LocalDate.today(), (String)"yyyyMMdd");
                String ptIndTel = null;
                if (fm.getPtIndTel() != null) {
                    ptTel = ptTel.substring(3);
                    ptIndTel = ptTel.substring(0, 3);
                }
                ptTel = (String)StringUtils.defaultIfEmpty((CharSequence)ptTel, (CharSequence)"");
                ptIndTel = (String)StringUtils.defaultIfEmpty(ptIndTel, (CharSequence)"");
                AcroFields acroFields = stamper.getAcroFields();
                HashMap fields = acroFields.getFields();
                Set entrySet = fields.entrySet();
                for (Map.Entry entry : entrySet) {
                    String key = (String)entry.getKey();
                    if ("3996".equals(fm.getCode()) || "3633".equals(fm.getCode())) {
                        if (key.matches(keyRxName)) {
                            acroFields.setField(key, rxName);
                        } else if (key.matches(keyRxFormat)) {
                            acroFields.setField(key, rxFormat);
                        } else if (key.matches(keyRxTeneur)) {
                            acroFields.setField(key, rxTeneur);
                        }
                    }
                    if (fm.isRegExp()) {
                        if (fm.matchPtName(key)) {
                            acroFields.setField(key, ptName);
                            continue;
                        }
                        if (fm.matchPtNAM(key)) {
                            acroFields.setField(key, ptNAM);
                            continue;
                        }
                        if (fm.matchPtDDN(key)) {
                            acroFields.setField(key, ptDDN);
                            continue;
                        }
                        if (fm.matchPtAdresse(key)) {
                            acroFields.setField(key, ptAdresse);
                            continue;
                        }
                        if (fm.matchPtCP(key)) {
                            acroFields.setField(key, ptCP);
                            continue;
                        }
                        if (fm.matchPtVille(key)) {
                            acroFields.setField(key, ptVille);
                            continue;
                        }
                        if (fm.matchPtIndTel(key)) {
                            acroFields.setField(key, ptIndTel);
                            continue;
                        }
                        if (fm.matchPtTel(key)) {
                            acroFields.setField(key, ptTel);
                            continue;
                        }
                        if (fm.matchMdName(key)) {
                            acroFields.setField(key, mdName);
                            continue;
                        }
                        if (fm.matchNoProf(key)) {
                            acroFields.setField(key, noProf);
                            continue;
                        }
                        if (fm.matchMdAdresse(key)) {
                            acroFields.setField(key, mdAdresse);
                            continue;
                        }
                        if (fm.matchMdCP(key)) {
                            acroFields.setField(key, mdCP);
                            continue;
                        }
                        if (fm.matchMdIndTel(key)) {
                            acroFields.setField(key, mdIndTel);
                            continue;
                        }
                        if (fm.matchMdTel(key)) {
                            acroFields.setField(key, mdTel);
                            continue;
                        }
                        if (fm.matchMdIndFax(key)) {
                            acroFields.setField(key, mdIndFax);
                            continue;
                        }
                        if (fm.matchMdFax(key)) {
                            acroFields.setField(key, mdFax);
                            continue;
                        }
                        if (fm.matchMdVille(key)) {
                            acroFields.setField(key, mdVille);
                            continue;
                        }
                        if (!fm.matchDateSignature(key)) continue;
                        acroFields.setField(key, dateSignature);
                        continue;
                    }
                    if (key.equals(fm.getPtName())) {
                        acroFields.setField(key, ptName);
                        continue;
                    }
                    if (key.equals(fm.getPtNAM())) {
                        acroFields.setField(key, ptNAM);
                        continue;
                    }
                    if (key.equals(fm.getPtDDN())) {
                        acroFields.setField(key, ptDDN);
                        continue;
                    }
                    if (key.equals(fm.getPtAdresse())) {
                        acroFields.setField(key, ptAdresse);
                        continue;
                    }
                    if (key.equals(fm.getPtCP())) {
                        acroFields.setField(key, ptCP);
                        continue;
                    }
                    if (key.equals(fm.getPtVille())) {
                        acroFields.setField(key, ptVille);
                        continue;
                    }
                    if (key.equals(fm.getPtIndTel())) {
                        acroFields.setField(key, ptIndTel);
                        continue;
                    }
                    if (key.equals(fm.getPtTel())) {
                        acroFields.setField(key, ptTel);
                        continue;
                    }
                    if (key.equals(fm.getMdName())) {
                        acroFields.setField(key, mdName);
                        continue;
                    }
                    if (key.equals(fm.getNoProf())) {
                        acroFields.setField(key, noProf);
                        continue;
                    }
                    if (key.equals(fm.getMdAdresse())) {
                        acroFields.setField(key, mdAdresse);
                        continue;
                    }
                    if (key.equals(fm.getMdCP())) {
                        acroFields.setField(key, mdCP);
                        continue;
                    }
                    if (key.equals(fm.getMdIndTel()) || fm.getMdIndTel() == null && fm0000.matchMdIndTel(key)) {
                        acroFields.setField(key, mdIndTel);
                        continue;
                    }
                    if (key.equals(fm.getMdTel())) {
                        acroFields.setField(key, mdTel);
                        continue;
                    }
                    if (key.equals(fm.getMdIndFax()) || fm.getMdIndFax() == null && fm0000.matchMdIndFax(key)) {
                        acroFields.setField(key, mdIndFax);
                        continue;
                    }
                    if (key.equals(fm.getMdFax())) {
                        acroFields.setField(key, mdFax);
                        continue;
                    }
                    if (key.equals(fm.getMdVille())) {
                        acroFields.setField(key, mdVille);
                        continue;
                    }
                    if (!key.equals(fm.getDateSignature())) continue;
                    acroFields.setField(key, dateSignature);
                }
                if (stamper == null) break block52;
            }
            catch (Throwable throwable) {
                if (stamper != null) {
                    Util.executeAndIgnore(() -> stamper.close());
                }
                if (reader != null) {
                    Util.executeAndIgnore(() -> ((PdfReader)reader).close());
                }
                if (outputStream != null) {
                    outputStream.flush();
                    ((ByteArrayOutputStream)outputStream).close();
                }
                throw throwable;
            }
            Util.executeAndIgnore(() -> ((PdfStamper)stamper).close());
        }
        if (reader != null) {
            Util.executeAndIgnore(() -> ((PdfReader)reader).close());
        }
        if (outputStream != null) {
            outputStream.flush();
            ((ByteArrayOutputStream)outputStream).close();
        }
        return ((ByteArrayOutputStream)outputStream).toByteArray();
    }
}

