/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.DispenseDetails;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION_DM;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.ofys.client.modules.dsq.DSQcallType;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.SqimHtmlFormatter;
import ca.infodata.ofys.client.modules.dsq.internal.CallBackResume;
import ca.infodata.ofys.client.modules.dsq.internal.CallBackSimpleResume;
import ca.infodata.ofys.client.modules.dsq.internal.DispenseController;
import ca.infodata.ofys.client.modules.dsq.internal.DispenseControllerCallback;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.LegacyDsqControllerWeb;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.util1.IPair;
import ca.infodata.util1.date.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DispenseControllerWeb
extends LegacyDsqControllerWeb {
    private static final Logger logger = Logger.getLogger(DispenseControllerWeb.class.getName());
    private DispenseController controller;

    public DispenseControllerWeb(Integer idPatient, IWebSocketChannel channel, GetCandidateController findCandidateController) {
        super(idPatient, channel);
        this.controller = new DispenseController(idPatient, new DispenseControllerCallback(){

            @Override
            public String listSummary(DsqCallback<QueryContinuationResult> callback) {
                return DispenseControllerWeb.this.browserCallback("listDispenses", new CallBackResume(callback, DSQcallType.Dispensed), SqimHtmlFormatter.getDispenseSummary((QueryContinuationResult)callback.result), null);
            }

            @Override
            public String getDetail(String id, DsqCallback<DispenseDetails> callback) {
                return DispenseControllerWeb.this.browserCallback("getDispenseDetail", new CallBackSimpleResume(callback), SqimHtmlFormatter.formatGetPrescriptionsDispensedDetails((DispenseDetails)callback.result));
            }

            @Override
            public String convertDetail(String id, DsqCallback<IPair<DispenseDetails, XPrescription>> callback) {
                String html = callback.result != null ? SqimHtmlFormatter.formatGetPrescriptionsDispensedDetails((DispenseDetails)((IPair)callback.result).getFirst(), (XPrescription)((IPair)callback.result).getSecond()) : "";
                return DispenseControllerWeb.this.browserCallback("importDispenseDetail", new CallBackSimpleResume(callback), html);
            }

            @Override
            public String getDetailForImport(String id, String dId, String idRx, DsqCallback<DispenseDetails> callback) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String listSummaryForPrescription(NIU_PRESCRIPTION_DM id, String context, DsqCallback<QueryContinuationResult> callback) {
                return DispenseControllerWeb.this.browserCallback("listSummaryForPrescriptionDM", new CallBackResume(callback, DSQcallType.DMPrescription), SqimHtmlFormatter.getDispenseSummary((QueryContinuationResult)callback.result), context);
            }
        }, findCandidateController);
    }

    public void listSummaryCallback(QueryContinuationResult result) {
        this.controller.getCallback().listSummary(new DsqCallback<QueryContinuationResult>(result));
    }

    public void listSummary() {
        try {
            this.controller.listSummary();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            DsqCallback<Object> callback = new DsqCallback<Object>(null, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]), e);
            this.controller.getCallback().listSummary(callback);
        }
    }

    public void getDetail(String dispenseId) {
        try {
            this.controller.getDetail(dispenseId);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            DsqCallback<Object> callback = new DsqCallback<Object>(null, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]), e);
            this.controller.getCallback().listSummary(callback);
        }
    }

    public void listSummaryForPrescription(NIU_PRESCRIPTION_DM niu_PRESCRIPTION_DM, String context) {
        try {
            this.controller.listSummaryForPrescription(niu_PRESCRIPTION_DM, context);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            DsqCallback<Object> callback = new DsqCallback<Object>(null, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]), e);
            this.controller.getCallback().listSummary(callback);
        }
    }

    public void setStart(LocalDate start) {
        this.controller.setStart(start);
    }

    public void setEnd(LocalDate end) {
        this.controller.setEnd(end);
    }

    public void setActiveProfile(Boolean actif) {
        this.controller.setActiveProfile(Boolean.TRUE.equals(actif));
    }

    public void setMostRecent(Boolean actif) {
        this.controller.setMostRecent(Boolean.TRUE.equals(actif));
    }

    public LocalDate getStart() {
        return this.controller.getStart();
    }

    public LocalDate getEnd() {
        return this.controller.getEnd();
    }

    public boolean getActiveProfile() {
        return this.controller.getActiveProfile();
    }

    public boolean isMostRecent() {
        return this.controller.isMostRecent();
    }
}

