/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.appointment;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.appointment.IAppointmentPluginController;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XConsultationReason;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XClientPreferences;
import ca.infodata.util1.date.IPartialDate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class AbstractAppointmentPluginController
implements IAppointmentPluginController {
    private static final int[] white = new int[]{255, 255, 255};

    @Override
    public abstract XAppointmentPeriodType getPeriodType(Integer var1);

    @Override
    public abstract List<XAppointmentPeriodType> getPeriodTypes();

    @Override
    public abstract XAppointmentType getAppointmentType(Integer var1);

    @Override
    public abstract List<XAppointmentType> getAppointmentTypes();

    @Override
    public abstract List<XBaseProfessionnal> findNonDeletedProfessionnalsThatUseAppointments();

    @Override
    public abstract int getDefaultTemplateStartHour();

    @Override
    public abstract int getDefaultTemplateEndHour();

    @Override
    public abstract int getDefaultTemplateScale();

    @Override
    public abstract XAppointmentType getDefaultAppointmentType();

    @Override
    public abstract XAppointmentPeriodType getDefaultAppointmentPeriodType();

    public abstract Map<String, XConsultationReason> getMapConsultationReasons();

    @Override
    public abstract XConsultationReason getConsultationReason(String var1);

    @Override
    public boolean canSeeAndModifyAppointment(IAppointment appointment) {
        if (appointment == null) {
            return true;
        }
        if (!Boolean.TRUE.equals(appointment.getIsConfidential())) {
            return true;
        }
        XBaseProfessionnal sessionProfessionnal = Application.get().getPersonPluginController().getSessionProfessionnal();
        if (sessionProfessionnal == null) {
            return false;
        }
        return appointment.getIdProfessionals().contains(sessionProfessionnal.getId());
    }

    @Override
    public Comparator<IAppointment> getXAppointmentComparator(final boolean ASC) {
        return new Comparator<IAppointment>(){

            @Override
            public int compare(IAppointment a1, IAppointment a2) {
                int val = 0;
                val = a1 == null && a2 == null ? 0 : (a1 == null ? -1 : (a2 == null ? 1 : (a1.getDate() == null && a2.getDate() == null ? 0 : (a1.getDate() == null ? -1 : (a2.getDate() == null ? 1 : (a1.getDate().before((IPartialDate)a2.getDate()) ? 1 : (a1.getDate().after((IPartialDate)a2.getDate()) ? -1 : (a1.getStartTime() == null && a2.getStartTime() == null ? 0 : (a1.getStartTime() == null ? -1 : (a2.getStartTime() == null ? 1 : a1.getStartTime().compareTo(a2.getStartTime())))))))))));
                return val * (ASC ? -1 : 1);
            }
        };
    }

    @Override
    public Comparator<XPatientRecall> getXRecallComparator(final boolean ASC) {
        return new Comparator<XPatientRecall>(){

            @Override
            public int compare(XPatientRecall a1, XPatientRecall a2) {
                int val = 0;
                val = a1 == null && a2 == null ? 0 : (a1 == null ? -1 : (a2 == null ? 1 : (a1.getDateCreated() == null && a2.getDateCreated() == null ? 0 : (a1.getDateCreated() == null ? -1 : (a2.getDateCreated() == null ? 1 : a1.getDateCreated().compareTo((IPartialDate)a2.getDateCreated()))))));
                return val * (ASC ? -1 : 1);
            }
        };
    }

    protected abstract XClientPreferences getContextClientPreferences();

    @Override
    public int[] getColorByStatus(XAppointmentStatus appointmentStatus) {
        int[] color = null;
        XClientPreferences preferences = this.getContextClientPreferences();
        color = preferences != null ? (appointmentStatus == XAppointmentStatus.NORMAL ? preferences.getColorAppointmentStateNormal() : (appointmentStatus == XAppointmentStatus.MESSAGE_LEAVED ? preferences.getColorAppointmentStateMessage() : (appointmentStatus == XAppointmentStatus.CONFIRMED ? preferences.getColorAppointmentStateConfirmed() : (appointmentStatus == XAppointmentStatus.CONFIRMATION_MAIL_ENVOI ? preferences.getColorAppointmentStateConfirmEnvoi() : (appointmentStatus == XAppointmentStatus.CONFIRMATION_TEXTO_ENVOI ? preferences.getColorAppointmentStateConfirmEnvoi() : (appointmentStatus == XAppointmentStatus.CONFIRMATION_TELVOCAL_ENVOI ? preferences.getColorAppointmentStateConfirmEnvoi() : (appointmentStatus == XAppointmentStatus.CONFIRMATION_MAIL_RECUE ? preferences.getColorAppointmentStateConfirmRecue() : (appointmentStatus == XAppointmentStatus.CONFIRMATION_TEXTO_RECUE ? preferences.getColorAppointmentStateConfirmRecue() : (appointmentStatus == XAppointmentStatus.CONFIRMATION_TELVOCAL_RECUE ? preferences.getColorAppointmentStateConfirmRecue() : (appointmentStatus == XAppointmentStatus.TO_MOVE ? preferences.getColorAppointmentStateMoved() : (appointmentStatus == XAppointmentStatus.NO_ANSWER ? preferences.getColorAppointmentStateNoAnswer() : (appointmentStatus == XAppointmentStatus.WANT_TO_MOVE_AHEAD ? preferences.getColorAppointmentStateWantAppointmentAhead() : (appointmentStatus == XAppointmentStatus.BOITE_VOCALE ? preferences.getColorAppointmentStateVoicemail() : (appointmentStatus == XAppointmentStatus.LIGNE_OCCUPEE ? preferences.getColorAppointmentStateLineBusy() : (appointmentStatus == XAppointmentStatus.PAS_DE_SERVICE ? preferences.getColorAppointmentStateNoService() : preferences.getColorAppointmentStateNormal()))))))))))))))) : new int[]{196, 218, 255};
        return color == null ? white : color;
    }

    @Override
    public int[] getColorByPatientStatus(XPatientStatus patientStatus) {
        int[] color = null;
        XClientPreferences preferences = this.getContextClientPreferences();
        color = preferences != null ? (XPatientStatus.NONE.equals((Object)patientStatus) ? preferences.getColorPatientStateNone() : (XPatientStatus.CANCEL.equals((Object)patientStatus) || XPatientStatus.CANCEL_LESS_24H.equals((Object)patientStatus) ? preferences.getColorPatientStateCancelled() : (XPatientStatus.SEEN.equals((Object)patientStatus) ? preferences.getColorPatientStateSeen() : (XPatientStatus.NOT_CAME.equals((Object)patientStatus) || XPatientStatus.LEFT_WITHOUT_BEING_SEEN.equals((Object)patientStatus) ? preferences.getColorPatientStateNotCame() : (XPatientStatus.ARRIVED.equals((Object)patientStatus) || XPatientStatus.ARRIVED_LATE.equals((Object)patientStatus) ? preferences.getColorPatientStateArrived() : (XPatientStatus.PLACED.equals((Object)patientStatus) ? preferences.getColorPatientStatePlaced() : (XPatientStatus.SEEN_INF.equals((Object)patientStatus) ? preferences.getColorPatientStateArrived() : (XPatientStatus.SEEN_RES.equals((Object)patientStatus) ? preferences.getColorPatientStateArrived() : (XPatientStatus.TRIE.equals((Object)patientStatus) ? preferences.getColorPatientStateArrived() : (XPatientStatus.ATTENTE_REV.equals((Object)patientStatus) ? preferences.getColorPatientStateArrived() : preferences.getColorPatientStateNone())))))))))) : new int[]{254, 252, 222};
        return color == null ? white : color;
    }

    @Override
    public int[] getColorByAppointmentType(XAppointmentType type) {
        int[] color = null;
        if (type != null) {
            color = type.getColor();
        }
        return color == null ? white : color;
    }

    @Override
    public int[] getColorByAppointmentPeriodType(XAppointmentPeriodType type) {
        int[] color = null;
        if (type != null) {
            color = type.getColor();
        }
        return color == null ? white : color;
    }
}

