/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.gson.impl;

import ca.infodata.ofys.client.web.core.JsonAsMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;

public class JsonAsMapTypeAdapter
implements JsonDeserializer<JsonAsMap> {
    public JsonAsMap deserialize(JsonElement json, Type typeOft, JsonDeserializationContext context) throws JsonParseException {
        Map map = (Map)context.deserialize(json, Map.class);
        JsonAsMap body = new JsonAsMap();
        for (Map.Entry e : map.entrySet()) {
            String key = String.valueOf(e.getKey());
            Object value = e.getValue();
            Object fixed = this.fix(value);
            body.put(key, fixed);
        }
        return body;
    }

    private Object fix(Object value) {
        Double d;
        if (value == null) {
            return null;
        }
        if (value instanceof Double && !(d = (Double)value).isNaN() && !d.isInfinite()) {
            long longValue = d.longValue();
            if (Math.round(d) == longValue) {
                if (longValue <= Integer.MAX_VALUE) {
                    return (int)longValue;
                }
                return longValue;
            }
        }
        return value;
    }
}

