/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.gson.impl;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;

public class EditableDataObjectDeserializer
implements JsonDeserializer<EditableDataObject> {
    public EditableDataObject deserialize(JsonElement e, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (e.isJsonNull()) {
            return null;
        }
        try {
            JsonObject jsonObject = e.getAsJsonObject();
            EditableDataObject editableDataObject = this.newInstance(type);
            Class<?> c = editableDataObject.getClass();
            for (Map.Entry jsonField : jsonObject.entrySet()) {
                String name = (String)jsonField.getKey();
                JsonElement value = (JsonElement)jsonField.getValue();
                Field field = this.getField((Class)type, name);
                if (field == null) {
                    throw new Exception("no field with name " + name + " found for class " + c.getName());
                }
                Class<?> fieldType = field.getType();
                if (fieldType.equals(EditableDataObject.Property.class)) {
                    EditableDataObject.Property propertyInstance = (EditableDataObject.Property)field.get(editableDataObject);
                    Object propertyValue = null;
                    if (value.isJsonPrimitive()) {
                        JsonPrimitive jp = (JsonPrimitive)value;
                        if (jp.isNumber()) {
                            propertyValue = value.getAsNumber().intValue();
                        } else if (jp.isString() && "modificationStatus".equals(propertyInstance.name())) {
                            propertyValue = ModificationStatus.from((String)value.getAsString());
                        }
                    } else {
                        propertyValue = context.deserialize(value, field.getGenericType());
                    }
                    propertyInstance.plain_set2(propertyValue);
                    continue;
                }
                field.set(editableDataObject, context.deserialize(value, field.getType()));
            }
            return editableDataObject;
        }
        catch (Exception e1) {
            throw new JsonParseException((Throwable)e1);
        }
    }

    private EditableDataObject newInstance(Type type) throws InstantiationException, IllegalAccessException {
        Class c = (Class)type;
        return (EditableDataObject)c.newInstance();
    }

    private Field getField(Class<?> c, String name) {
        for (Field field : c.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        Class<?> superClass = c.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return this.getField(superClass, name);
    }
}

