/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.gson.impl;

import ca.infodata.ofys.data.middle.dataobjects.patient.Age;
import ca.infodata.util1.date.LocalDate;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class AgeTypeAdapter
extends TypeAdapter<Age> {
    public void write(JsonWriter jsonWriter, Age a) throws IOException {
        if (a == null || a.birthDay == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.beginObject();
        jsonWriter.name("totalDays").value((long)a.totalDays);
        jsonWriter.name("birthDay");
        this.writeBirthday(jsonWriter, a.birthDay);
        jsonWriter.endObject();
    }

    public void writeBirthday(JsonWriter writer, LocalDate ld) throws IOException {
        writer.beginObject();
        writer.name("dayFrom1970").value((long)ld.dayFrom1970);
        writer.endObject();
    }

    public Age read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            LocalDate birthDay = null;
            Integer totalDays = null;
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if ("totalDays".equals(name)) {
                    totalDays = in.nextInt();
                    continue;
                }
                if (!"birthDay".equals(name)) continue;
                birthDay = this.readBirthDay(in);
            }
            in.endObject();
            Age age = new Age(birthDay, birthDay.plusDay(totalDays.intValue()));
            return age;
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    private LocalDate readBirthDay(JsonReader in) throws IOException {
        Integer dayFrom1970 = null;
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (!"dayFrom1970".equals(name)) continue;
            dayFrom1970 = in.nextInt();
        }
        in.endObject();
        return LocalDate.fromDayFrom1970((int)dayFrom1970);
    }
}

