/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.cache.impl;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.cache.IPatientCache;
import ca.infodata.ofys.data.dataaccess.IPatientAccessor;
import ca.infodata.ofys.data.dataaccess.util.notification.DataObjectNotificationHandler;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.util1.StringUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatientCache
implements IPatientCache {
    private static final Logger logger = Logger.getLogger(PatientCache.class.getName());
    private final Cache<Integer, XPatient> cache;
    private final IPatientAccessor patientAccessor = Application.get().getDataAccessors().getPatientAccessor();
    private final DataObjectNotificationHandler dataObjectNotificationHandler;

    public PatientCache(int maximumSize) {
        this.cache = Caffeine.newBuilder().maximumSize((long)maximumSize).initialCapacity(maximumSize / 2).softValues().build();
        this.dataObjectNotificationHandler = new DataObjectNotificationHandler(){

            @Override
            public void handle(DataObjectUpdatedNotification notification) {
                try {
                    if (notification != null && notification.getObject() instanceof XPatient) {
                        PatientCache.this.refresh((XPatient)notification.getObject());
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error refreshing patient cache from notification. " + StringUtils.safeToString((Logger)logger, (Object)notification), e);
                }
            }
        };
        Application.get().getGlobalInstances().getNotificationSystem().addDataObjectNotificationHandler(this.dataObjectNotificationHandler);
    }

    protected void refresh(XPatient patient) {
        XPatient cached = (XPatient)this.cache.getIfPresent((Object)patient.getId());
        if (cached != null) {
            logger.info("Refreshing cached patient " + cached.getId() + " version " + cached.getVersion() + " with version " + patient.getVersion());
            this.cache.put((Object)patient.getId(), (Object)patient);
        }
    }

    protected XPatient load(Integer id) throws Exception {
        if (id == null) {
            throw new NullPointerException("id cant be null");
        }
        logger.log(Level.INFO, "Loading patient " + id + " from server");
        ReturnObject response = this.patientAccessor.getPatient(id);
        Object obj = response.getObj();
        XPatient patient = (XPatient)obj;
        return patient;
    }

    @Override
    public XPatient get(Integer id) {
        if (this.cache.getIfPresent((Object)id) != null) {
            logger.log(Level.INFO, "Getting patient " + id + " from cache");
        }
        return (XPatient)this.cache.get((Object)id, k -> {
            try {
                logger.log(Level.INFO, "Trying to get patient from load with id " + id);
                return this.load(id);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "failed to get patient from load with id " + id, e);
                return null;
            }
        });
    }

    @Override
    public void put(Integer key, XPatient value) {
        if (key != null && value != null) {
            if (!key.equals(value.getId())) {
                throw new IllegalArgumentException("key should be patient.id");
            }
            this.cache.put((Object)key, (Object)value);
        }
    }

    @Override
    public void remove(Integer key) {
        logger.log(Level.INFO, "Removing patient " + key + " from cache");
        this.cache.invalidate((Object)key);
    }

    public void clear() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    @Override
    public void dispose() {
        Application.get().getGlobalInstances().getNotificationSystem().removeDataObjectNotificationHandler(this.dataObjectNotificationHandler);
    }
}

