/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5MessageWithUserPropertiesEncoder;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttStatefulUnsubscribe;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.internal.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.client.internal.shaded.javax.inject.Inject;
import com.hivemq.client.internal.shaded.javax.inject.Singleton;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5MessageType;
import java.util.List;

@Singleton
public class Mqtt5UnsubscribeEncoder
extends Mqtt5MessageWithUserPropertiesEncoder<MqttStatefulUnsubscribe> {
    private static final int FIXED_HEADER = Mqtt5MessageType.UNSUBSCRIBE.getCode() << 4 | 2;
    private static final int VARIABLE_HEADER_FIXED_LENGTH = 2;

    @Inject
    Mqtt5UnsubscribeEncoder() {
    }

    @Override
    int remainingLengthWithoutProperties(@NotNull MqttStatefulUnsubscribe message) {
        int remainingLength = 2;
        List topicFilters = ((MqttUnsubscribe)message.stateless()).getTopicFilters();
        for (int i = 0; i < topicFilters.size(); ++i) {
            remainingLength += ((MqttTopicFilterImpl)topicFilters.get(i)).encodedLength();
        }
        return remainingLength;
    }

    @Override
    int propertyLength(@NotNull MqttStatefulUnsubscribe message) {
        return this.omissiblePropertyLength(message);
    }

    @Override
    void encode(@NotNull MqttStatefulUnsubscribe message, @NotNull ByteBuf out, int remainingLength, int propertyLength, int omittedProperties) {
        this.encodeFixedHeader(out, remainingLength);
        this.encodeVariableHeader(message, out, propertyLength, omittedProperties);
        this.encodePayload(message, out);
    }

    private void encodeFixedHeader(@NotNull ByteBuf out, int remainingLength) {
        out.writeByte(FIXED_HEADER);
        MqttVariableByteInteger.encode(remainingLength, out);
    }

    private void encodeVariableHeader(@NotNull MqttStatefulUnsubscribe message, @NotNull ByteBuf out, int propertyLength, int omittedProperties) {
        out.writeShort(message.getPacketIdentifier());
        this.encodeProperties(message, out, propertyLength, omittedProperties);
    }

    private void encodeProperties(@NotNull MqttStatefulUnsubscribe message, @NotNull ByteBuf out, int propertyLength, int omittedProperties) {
        MqttVariableByteInteger.encode(propertyLength, out);
        this.encodeOmissibleProperties(message, out, omittedProperties);
    }

    private void encodePayload(@NotNull MqttStatefulUnsubscribe message, @NotNull ByteBuf out) {
        List topicFilters = ((MqttUnsubscribe)message.stateless()).getTopicFilters();
        for (int i = 0; i < topicFilters.size(); ++i) {
            ((MqttTopicFilterImpl)topicFilters.get(i)).encode(out);
        }
    }
}

