/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import ca.infodata.util1.IPair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Pair<A, B>
implements Serializable,
IPair<A, B> {
    private static final long serialVersionUID = 1L;
    public final A first;
    public final B second;

    public static <A, B> Pair<A, B> newPair(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    public static <A, B> List<Pair<A, B>> generateList(Collection<A> firsts, Collection<B> seconds) {
        ArrayList<Pair<A, B>> result = new ArrayList<Pair<A, B>>(firsts.size() * seconds.size());
        for (B second : seconds) {
            for (A first : firsts) {
                result.add(Pair.newPair(first, second));
            }
        }
        return result;
    }

    public static <A, B> Collection<A> getFirsts(Collection<Pair<A, B>> col) {
        ArrayList<A> firsts = new ArrayList<A>(col.size());
        for (Pair<A, B> pair : col) {
            firsts.add(pair.first);
        }
        return firsts;
    }

    public static <A, B> Collection<B> getSeconds(Collection<Pair<A, B>> col) {
        ArrayList<B> seconds = new ArrayList<B>(col.size());
        for (Pair<A, B> pair : col) {
            seconds.add(pair.second);
        }
        return seconds;
    }

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPair)) {
            return false;
        }
        IPair other = (IPair)obj;
        if (this.first == null ? other.getFirst() != null : !this.first.equals(other.getFirst())) {
            return false;
        }
        return !(this.second == null ? other.getSecond() != null : !this.second.equals(other.getSecond()));
    }

    public String toString() {
        return "(" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ")";
    }

    @Override
    public A getFirst() {
        return this.first;
    }

    @Override
    public B getSecond() {
        return this.second;
    }
}

