/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.site;

import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.property.IPropertyListener;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.site.SiteCombo;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.ofys.ui.site.WorkSiteCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class ContextSiteContributionItem
extends WorkbenchWindowControlContribution
implements IPropertyListener,
IRefreshFont {
    private SiteCombo combo;
    private Canvas cvsColor;
    private FontAwareComposite composite;

    public ContextSiteContributionItem() {
        this(ContextSiteContributionItem.class.getName());
    }

    public ContextSiteContributionItem(String id) {
        super(id);
        PropertyListenerManager.addListener((Object)SitePlugin.getDefault(), (IPropertyListener)this);
    }

    private void refreshSelection() {
        block6: {
            if (this.combo == null || this.combo.getControl().isDisposed()) {
                return;
            }
            try {
                XSite contextSite = SitePlugin.getDefault().getContextSite();
                if (contextSite != null) {
                    this.combo.selectNoNotify(contextSite);
                }
                if (contextSite == null) {
                    this.cvsColor.setBackground(this.cvsColor.getParent().getBackground());
                } else {
                    this.cvsColor.setBackground(ResourceGetter.getColor((int[])contextSite.getColor()));
                }
            }
            catch (SWTException exception) {
                if (SWT.getPlatform().equals("gtk")) break block6;
                throw exception;
            }
        }
    }

    protected Control createControl(Composite parent) {
        parent.getParent().setRedraw(true);
        this.composite = new FontAwareComposite(parent, 0);
        this.cvsColor = new Canvas((Composite)this.composite, 0);
        this.combo = new WorkSiteCombo((Composite)this.composite, 8, null);
        this.combo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ContextSiteContributionItem.this.handleWidgetSelected(e);
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.spacing = 0;
        layout.marginHeight = 0;
        this.composite.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 4);
        data.right = new FormAttachment(100);
        data.height = 24;
        this.combo.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.combo.getControl(), 0, 128);
        data.right = new FormAttachment((Control)this.combo.getControl(), -1);
        data.bottom = new FormAttachment((Control)this.combo.getControl(), 0, 1024);
        data.width = 10;
        this.cvsColor.setLayoutData((Object)data);
        parent.layout(true);
        this.refreshSelection();
        ResourceGetter.addListener((IRefreshFont)this);
        return this.composite;
    }

    private void handleWidgetSelected(Event event) {
        XSite selection = this.combo.getSelection();
        if (selection != null && selection.getId() != null && selection.getId() == -1) {
            selection = null;
        }
        SitePlugin.getDefault().setContextSite(selection);
    }

    public void dispose() {
        PropertyListenerManager.remove((Object)((Object)this));
        ResourceGetter.removeListener((IRefreshFont)this);
        this.combo = null;
    }

    public void propertyChanged(int propertyId) {
        if (propertyId == 1) {
            this.refreshSelection();
        }
    }

    public void refreshFont() {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.refreshFont();
            this.composite.getParent().layout(true, true);
        }
    }

    public boolean isDynamic() {
        return true;
    }
}

