/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.scan;

import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.controls.CancelException;
import ca.infodata.ofys.ui.controls.FontAwareButton;
import ca.infodata.ofys.ui.controls.FontAwareLabel;
import ca.infodata.ofys.ui.controls.FontAwareText;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.BusinessException;
import ca.infodata.util1.IntegerRange;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.StringUtils;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SplitPdfDialog {
    private static final String FORMAT_ERROR = Messages.getString((String)"BaseScanEditor.splitPdfDialog.formatError", (String[])new String[0]);
    private static final String CONFLICT_DETECTED = Messages.getString((String)"BaseScanEditor.splitPdfDialog.conflictDetected", (String[])new String[0]);
    private static final String CLEANING_FILES = Messages.getString((String)"BaseScanEditor.splitPdfDialog.cleaningFiles", (String[])new String[0]);
    private static final String ERROR = Messages.getString((String)"BaseScanEditor.splitPdfDialog.error", (String[])new String[0]);
    private static final String ERROR_READING_DOCUMENT_PAGE_COUNT = Messages.getString((String)"BaseScanEditor.splitPdfDialog.errorReadingDocumentPageCount", (String[])new String[0]);
    private static final String SPLIT = Messages.getString((String)"BaseScanEditor.splitPdfDialog.split", (String[])new String[0]);
    private static final String HELP = Messages.getString((String)"BaseScanEditor.splitPdfDialog.help", (String[])new String[0]);
    private static final String PAGE = Messages.getString((String)"BaseScanEditor.splitPdfDialog.page", (String[])new String[0]);
    private static final String PAGES = Messages.getString((String)"BaseScanEditor.splitPdfDialog.pages", (String[])new String[0]);
    private File file;
    private Shell dialog;
    private FontAwareText txtPages;
    private String txtPagesText;
    private PdfReader reader;
    private List<SubPdfDefinition> subPdfsDefinitions;
    private List<File> newFiles;
    private FontAwareButton btnDoit;
    private FontAwareLabel labelPreview;
    private int filePagesCount;

    public SplitPdfDialog(Shell parent, File file) throws Exception {
        this.file = file;
        this.filePagesCount = this.computeFilePagesCount();
        this.dialog = new Shell(parent, 2160);
        this.dialog.setText(file.getName());
        FormToolkit toolKit = UI.createToolKit((Widget)this.dialog);
        toolKit.adapt((Composite)this.dialog);
        FontAwareLabel labelHelp = new FontAwareLabel((Composite)this.dialog, 16384, HELP, toolKit);
        labelHelp.setFont(2, 0);
        FontAwareLabel separator = new FontAwareLabel((Composite)this.dialog, 258, "", toolKit);
        separator.setFont(2, 0);
        FontAwareLabel labelPageCount = new FontAwareLabel((Composite)this.dialog, 16384, Messages.getString((String)"BaseScanEditor.splitPdfDialog.pageCount", (String[])new String[]{String.valueOf(this.filePagesCount)}), toolKit);
        labelPageCount.setFont(2, 2);
        this.txtPages = new FontAwareText((Composite)this.dialog, 2052);
        this.txtPages.setFont(6, 1);
        this.txtPages.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SplitPdfDialog.this.txtPagesText = SplitPdfDialog.this.txtPages.getText();
                SplitPdfDialog.this.previewSplit();
            }
        });
        this.labelPreview = new FontAwareLabel((Composite)this.dialog, 16384, "", toolKit);
        this.labelPreview.setFont(2, 0);
        this.btnDoit = new FontAwareButton((Composite)this.dialog, 8);
        this.btnDoit.setFont(4, 0);
        this.btnDoit.setText(SPLIT);
        this.btnDoit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SplitPdfDialog.this.split();
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 8;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        this.dialog.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        labelHelp.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)labelHelp);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        separator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)separator);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        labelPageCount.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)labelPageCount);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtPages.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtPages);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.btnDoit.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnDoit);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.labelPreview.setLayoutData((Object)data);
        this.dialog.pack();
        UI.centerComposite((Composite)this.dialog, (Composite)this.dialog.getParent());
        this.checkExistingFiles();
    }

    private int computeFilePagesCount() throws Exception {
        PdfReader reader = null;
        FileInputStream fis = null;
        int pageCount = -1;
        try {
            try {
                fis = new FileInputStream(this.file);
                reader = new PdfReader((InputStream)fis);
                pageCount = reader.getNumberOfPages();
            }
            catch (Exception exception) {
                throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, ERROR_READING_DOCUMENT_PAGE_COUNT));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return pageCount;
    }

    protected void previewSplit() {
        try {
            List<SubPdfDefinition> definitions = this.parseSubPdfDefinitions();
            JoinList join = new JoinList("\n");
            int i = 0;
            while (i < definitions.size()) {
                SubPdfDefinition d = definitions.get(i);
                int max = 42;
                String fileName = this.file.getName().substring(0, this.file.getName().length() - ".pdf".length());
                if (fileName.length() > max) {
                    fileName = String.valueOf(StringUtils.truncate((String)fileName, (int)(max - 3))) + "...";
                }
                String subFileName = String.valueOf(fileName) + "_" + (i + 1) + ".pdf";
                String prettyString = String.valueOf(subFileName) + ",  " + d.prettyString();
                join.add((CharSequence)prettyString);
                ++i;
            }
            this.labelPreview.setForeground(ResourceGetter.getColor((int)0, (int)0, (int)0));
            this.labelPreview.setText(join.toString());
            this.labelPreview.getParent().requestLayout();
            this.dialog.pack();
        }
        catch (Exception e) {
            this.labelPreview.setForeground(ResourceGetter.getRedWarningColor());
            if (StringUtils.isBlank((CharSequence)e.getMessage())) {
                this.labelPreview.setText(ERROR);
            } else {
                this.labelPreview.setText(e.getMessage());
            }
            this.labelPreview.getParent().requestLayout();
            this.dialog.pack();
        }
    }

    public void open() {
        this.dialog.open();
    }

    protected void close() {
        this.dialog.close();
    }

    protected void split() {
        ProgressMonitorDialog progress = new ProgressMonitorDialog(this.dialog);
        final Exception[] exception = new Exception[1];
        final boolean[] doneWithSuccess = new boolean[1];
        try {
            progress.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        doneWithSuccess[0] = SplitPdfDialog.this.split(monitor);
                    }
                    catch (Exception e) {
                        doneWithSuccess[0] = false;
                        exception[0] = e;
                        SplitPdfDialog.this.cleanNewFiles();
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            doneWithSuccess[0] = false;
            exception[0] = e;
        }
        if (doneWithSuccess[0]) {
            MessageUtil.infoMsg((Shell)this.dialog, (String)(String.valueOf(Messages.getString((String)"BaseScanEditor.splitPdfDialog.doneWithSuccess", (String[])new String[0])) + this.file.getName()));
        } else if (exception[0] instanceof BusinessException) {
            MessageUtil.errorMsg((Shell)this.dialog, (String)exception[0].getMessage());
        } else if (!(exception[0] instanceof CancelException)) {
            if (exception[0] != null) {
                MessageUtil.show((Shell)this.dialog, (Exception)exception[0]);
            } else {
                MessageUtil.errorMsg((Shell)this.dialog, (String)MessageUtil.UNEXPECTED_ERROR_MESSAGE);
            }
        }
    }

    protected boolean split(IProgressMonitor monitor) throws BusinessException, CancelException, FileNotFoundException, IOException, DocumentException, InterruptedException {
        boolean success;
        this.reader = null;
        try {
            this.subPdfsDefinitions = this.parseSubPdfDefinitions();
            monitor.beginTask(SPLIT, this.subPdfsDefinitions.size());
            if (monitor.isCanceled()) {
                throw new CancelException();
            }
            monitor.subTask(CLEANING_FILES);
            this.cleanExistingFiles();
            this.reader = new PdfReader((InputStream)new FileInputStream(this.file));
            this.newFiles = new ArrayList<File>();
            int i = 1;
            for (SubPdfDefinition definition : this.subPdfsDefinitions) {
                if (monitor.isCanceled()) {
                    throw new CancelException();
                }
                TimeUnit.MILLISECONDS.sleep(100L);
                monitor.subTask(this.computeFileName(definition, i));
                this.newFiles.add(this.exportSubPdf(definition, i));
                monitor.worked(1);
                ++i;
            }
            success = true;
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        return success;
    }

    private void checkExistingFiles() {
        boolean conflict = false;
        int i = 0;
        while (i < 100) {
            File subfile = this.computeSubFile(i + 1);
            if (subfile.exists()) {
                conflict = true;
                break;
            }
            ++i;
        }
        if (conflict) {
            this.labelPreview.setForeground(ResourceGetter.getRedWarningColor());
            this.labelPreview.setText(CONFLICT_DETECTED);
            this.txtPages.setEnabled(false);
            this.btnDoit.setEnabled(false);
        }
    }

    private void cleanExistingFiles() {
        int i = 0;
        while (i < 100) {
            File subfile = this.computeSubFile(i + 1);
            if (subfile.exists()) {
                FileUtils.deleteQuietly((File)subfile);
            }
            ++i;
        }
    }

    private void cleanNewFiles() {
        if (this.newFiles != null) {
            for (File file : this.newFiles) {
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    private String computeFileName(SubPdfDefinition definition, int subPdfCount) {
        String suffix = "_" + subPdfCount + ".pdf";
        File subfile = new File(this.file.getParentFile(), String.valueOf(this.file.getName().substring(0, this.file.getName().length() - ".pdf".length())) + suffix);
        return subfile.getName();
    }

    private File computeSubFile(int subPdfCount) {
        String suffix = "_" + subPdfCount + ".pdf";
        File subfile = new File(this.file.getParentFile(), String.valueOf(this.file.getName().substring(0, this.file.getName().length() - ".pdf".length())) + suffix);
        return subfile;
    }

    private File exportSubPdf(SubPdfDefinition definition, int subPdfCount) throws DocumentException, IOException {
        OutputStream subFileOutputStream = null;
        File subfile = null;
        try {
            String suffix = "_" + subPdfCount + ".pdf";
            subfile = new File(this.file.getParentFile(), String.valueOf(this.file.getName().substring(0, this.file.getName().length() - ".pdf".length())) + suffix);
            subFileOutputStream = new FileOutputStream(subfile);
            this.exportSubPdfTo(definition, (FileOutputStream)subFileOutputStream);
        }
        finally {
            if (subFileOutputStream != null) {
                subFileOutputStream.flush();
                ((FileOutputStream)subFileOutputStream).close();
            }
        }
        return subfile;
    }

    private void exportSubPdfTo(SubPdfDefinition definition, FileOutputStream subFileOutputStream) throws DocumentException {
        Document document = new Document();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)subFileOutputStream);
        document.open();
        writer.open();
        PdfContentByte directContent = writer.getDirectContent();
        for (IntegerRange range : definition.pages) {
            int i = (Integer)range.start;
            while (i <= (Integer)range.end) {
                document.setPageSize(this.reader.getPageSizeWithRotation(i));
                document.newPage();
                PdfImportedPage page = writer.getImportedPage(this.reader, i);
                int rotation = this.reader.getPageRotation(i);
                if (rotation == 90 || rotation == 270) {
                    directContent.addTemplate((PdfTemplate)page, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.reader.getPageSizeWithRotation(i).getHeight());
                } else {
                    directContent.addTemplate((PdfTemplate)page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                }
                ++i;
            }
        }
        writer.flush();
        document.close();
    }

    private List<SubPdfDefinition> parseSubPdfDefinitions() throws BusinessException {
        ArrayList<SubPdfDefinition> list = new ArrayList<SubPdfDefinition>();
        String text = StringUtils.trim((String)this.txtPagesText);
        if (StringUtils.isNotBlank((String)text)) {
            String[] parts;
            String[] stringArray = parts = text.split(";");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (StringUtils.isNotBlank((String)(part = StringUtils.trim((String)part)))) {
                    String[] subparts;
                    SubPdfDefinition pages = new SubPdfDefinition();
                    pages.input = part;
                    String[] stringArray2 = subparts = part.split(",");
                    int n3 = subparts.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String subpart = stringArray2[n4];
                        if (StringUtils.isNotBlank((String)subpart)) {
                            if (subpart.contains("-")) {
                                String[] intervalParts = subpart.split("-");
                                if (intervalParts.length == 2) {
                                    int end;
                                    int start = this.parsePageNumber(intervalParts[0]);
                                    if (start > (end = this.parsePageNumber(intervalParts[1]))) {
                                        this.raiseFormatException();
                                    } else {
                                        pages.pages.add(new IntegerRange(Integer.valueOf(start), Integer.valueOf(end), RangeNotation.CLOSED));
                                    }
                                } else {
                                    this.raiseFormatException();
                                }
                            } else {
                                int page = this.parsePageNumber(StringUtils.trim((String)subpart));
                                pages.pages.add(new IntegerRange(Integer.valueOf(page), Integer.valueOf(page), RangeNotation.CLOSED));
                            }
                        } else {
                            this.raiseFormatException();
                        }
                        ++n4;
                    }
                    list.add(pages);
                } else {
                    this.raiseFormatException();
                }
                ++n2;
            }
        }
        if (list.isEmpty()) {
            this.raiseFormatException();
        }
        return list;
    }

    private void raiseFormatException() throws BusinessException {
        throw new BusinessException(FORMAT_ERROR);
    }

    private int parsePageNumber(String s) throws BusinessException {
        try {
            int pageNumber = Integer.parseInt(s);
            if (pageNumber <= 0) {
                this.raiseFormatException();
            } else if (pageNumber > this.filePagesCount) {
                this.raiseFormatException();
            }
            return pageNumber;
        }
        catch (Exception exception) {
            this.raiseFormatException();
            return 0;
        }
    }

    static class SubPdfDefinition {
        String input;
        List<IntegerRange> pages = new ArrayList<IntegerRange>();

        SubPdfDefinition() {
        }

        String prettyString() {
            int count = 0;
            for (IntegerRange range : this.pages) {
                count += (Integer)range.end - (Integer)range.start + 1;
            }
            JoinList join = new JoinList("");
            if (count == 1) {
                join.add(count);
                join.add((CharSequence)(" " + PAGE));
            } else {
                join.add(count);
                join.add((CharSequence)(" " + PAGES));
            }
            String pageCount = join.toString();
            join = new JoinList(" ");
            join.add((CharSequence)pageCount);
            join.add((CharSequence)("(" + this.input + ")"));
            return join.toString();
        }
    }
}

