/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource.cellediting;

import ca.infodata.ofys.ui.controls.FontAwareShell;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.ressource.cellediting.AbstractPopupWindow;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ListBasedPopupWindow<E>
extends AbstractPopupWindow {
    protected E result = null;
    private int buttonStyle;
    private static final int NB_CRIT_PER_COL = 14;

    public ListBasedPopupWindow(Composite parent, int style, Button b, FormToolkit toolkit, int buttonStyle) {
        super(parent, style, b, toolkit);
        this.buttonStyle = buttonStyle;
    }

    @Override
    protected Shell createPopupControlOverride(Shell parent, FormToolkit toolkit) {
        FontAwareShell shell = new FontAwareShell(this.getShell(), 67680);
        shell.setText("");
        int nbC = this.columnCount(this.getList().size());
        GridLayout layout = new GridLayout(nbC, true);
        layout.makeColumnsEqualWidth = true;
        shell.setLayout((Layout)layout);
        toolkit.adapt((Composite)shell);
        for (E e : this.getList()) {
            MyButton btn = new MyButton((Composite)shell, this.getTextForItem(e), this.buttonStyle, toolkit);
            GridData gd = new GridData(768);
            btn.setLayoutData((Object)gd);
            btn.setData(e);
            this.setSelection((Button)btn, e);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button widget = (Button)e.widget;
                    ListBasedPopupWindow.this.dataSelectedInControl(widget.getData(), widget.getSelection());
                }
            });
        }
        shell.pack();
        return shell;
    }

    private int columnCount(int listSize) {
        int nbc = listSize / 14;
        if (listSize % 14 > 0) {
            ++nbc;
        }
        return nbc;
    }

    @Override
    protected void refreshPopup() {
        if (this.getPopup() != null && !this.getPopup().isDisposed()) {
            Control[] children;
            Control[] controlArray = children = this.getPopup().getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c instanceof Button) {
                    ((Button)c).setSelection(this.isDataSelectedInController(c.getData()));
                }
                ++n2;
            }
        }
    }

    @Override
    protected String computeLabel() {
        return null;
    }

    public E getResult() {
        return this.result;
    }

    public abstract void setSelection(Button var1, E var2);

    protected abstract String getTextForItem(E var1);

    protected abstract List<E> getList();

    protected abstract void dataSelectedInControl(E var1, boolean var2);

    protected abstract boolean isDataSelectedInController(E var1);
}

