/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.service.XSecteur;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.ressource.BaseViewerComposite;
import ca.infodata.ofys.ui.ressource.MyViewerComparator;
import ca.infodata.ofys.ui.ressource.SecteurEditor;
import ca.infodata.ofys.ui.ressource.cellediting.StringEditingSupport;
import ca.infodata.ofys.ui.ressource.cellediting.TaskEditingSupport;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class BaseSecteurControl
extends BaseViewerComposite {
    private static final String STATUS = Messages.getString((String)"STATUS", (String[])new String[0]);
    public IEditableDataObjectList<XSecteur> lstSecteurs;
    protected Button btnAddItem;
    protected Button btnFilter;
    protected String szErrors;
    private SecteurEditor parentEditor;

    public BaseSecteurControl(Composite parent, SecteurEditor parentEditor, FormToolkit toolkit) {
        super(parent, 0);
        this.parentEditor = parentEditor;
        this.createMyControl(this, toolkit);
        this.comparator = new MyViewerComparator(){

            @Override
            public int compare(Viewer viewer, Object p1, Object p2) {
                XSecteur x1 = (XSecteur)p1;
                XSecteur x2 = (XSecteur)p2;
                int rc = 0;
                switch (this.propertyIndex) {
                    case 0: {
                        rc = 0;
                        break;
                    }
                    case 1: {
                        rc = x1.getNameFr().compareTo(x2.getNameFr());
                        break;
                    }
                    case 2: {
                        rc = x1.getNameEn().compareTo(x2.getNameEn());
                        break;
                    }
                    default: {
                        rc = 0;
                    }
                }
                if (this.direction == 1) {
                    rc = -rc;
                }
                return rc;
            }
        };
        this.viewer.setComparator((ViewerComparator)this.comparator);
    }

    public void createMyControl(Composite parent, FormToolkit toolkit) {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        parent.setLayout((Layout)layout);
        this.btnAddItem = new Button(parent, 0x1000008);
        int btnW = 45;
        if (UI.OS_WINDOWS) {
            btnW = 35;
            this.btnAddItem.setText("+");
        } else {
            this.btnAddItem.setText("\u2795");
        }
        this.btnFilter = new Button(parent, 2);
        this.btnFilter.setText("F");
        this.btnFilter.setSelection(true);
        this.btnFilter.setToolTipText(Messages.getString((String)"FILTER_TTT", (String[])new String[0]));
        this.viewer = new TableViewer(parent, 68354){

            public void add(Object element) {
                XSecteur xd = (XSecteur)element;
                this.add(new Object[]{xd});
                BaseSecteurControl.this.lstSecteurs.add((IMinimalEditableDataObject)xd);
                BaseSecteurControl.this.getParentEditor().getSecteurs().add((IMinimalEditableDataObject)xd);
                BaseSecteurControl.this.getParentEditor().checkDirty();
                BaseSecteurControl.this.viewer.getTable().setFocus();
                BaseSecteurControl.this.viewer.setSelection((ISelection)new StructuredSelection((Object)xd));
                BaseSecteurControl.this.viewer.editElement((Object)xd, 1);
            }
        };
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.addFilter((ViewerFilter)this.getParentEditor().getHideDeletedItems());
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn tcB = new TableViewerColumn(this.viewer, 0);
        tcB.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tcB.getColumn(), 0));
        tcB.getColumn().setWidth(50);
        tcB.getColumn().setText(STATUS);
        tcB.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                XSecteur p = (XSecteur)element;
                if (p.getModificationStatus() == null) {
                    return null;
                }
                if (Boolean.TRUE.equals(p.getIsDeleted())) {
                    return ResourceGetter.getImage((String)"images/inactive.png");
                }
                return ResourceGetter.getImage((String)"images/icon-active.gif");
            }
        });
        tcB.setEditingSupport((EditingSupport)new TaskEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), toolkit, 0));
        TableViewerColumn tc0 = new TableViewerColumn(this.viewer, 0);
        tc0.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tc0.getColumn(), 1));
        tc0.getColumn().setWidth(140);
        tc0.getColumn().setText(String.valueOf(Messages.getString((String)"NOM", (String[])new String[0])) + " " + Messages.getString((String)"FRANCAIS", (String[])new String[0]).toLowerCase());
        tc0.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XSecteur p = (XSecteur)element;
                return p.getNameFr();
            }
        });
        tc0.setEditingSupport((EditingSupport)new StringEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getNameFr", "setNameFr", 0));
        TableViewerColumn tc1 = new TableViewerColumn(this.viewer, 0);
        tc1.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tc1.getColumn(), 2));
        tc1.getColumn().setWidth(140);
        tc1.getColumn().setText(String.valueOf(Messages.getString((String)"NOM", (String[])new String[0])) + " " + Messages.getString((String)"ANGLAIS", (String[])new String[0]).toLowerCase());
        tc1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XSecteur p = (XSecteur)element;
                return p.getNameEn();
            }
        });
        tc1.setEditingSupport((EditingSupport)new StringEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getNameEn", "setNameEn", 0));
        TableViewerColumn tc2 = new TableViewerColumn(this.viewer, 0);
        tc2.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tc2.getColumn(), 3));
        tc2.getColumn().setWidth(200);
        tc2.getColumn().setText("NOTE");
        tc2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XSecteur q = (XSecteur)element;
                return q.getNote();
            }
        });
        tc2.setEditingSupport((EditingSupport)new StringEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getNote", "setNote", 0));
        parent.setFocus();
        TableViewerEditor.create((TableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer), (int)30);
        this.btnAddItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XSecteur newDef = new XSecteur();
                newDef.initialize();
                BaseSecteurControl.this.viewer.add((Object)newDef);
            }
        });
        this.btnFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    BaseSecteurControl.this.viewer.addFilter((ViewerFilter)BaseSecteurControl.this.getParentEditor().getHideDeletedItems());
                } else {
                    BaseSecteurControl.this.viewer.removeFilter((ViewerFilter)BaseSecteurControl.this.getParentEditor().getHideDeletedItems());
                }
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = btnW;
        this.btnAddItem.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAddItem);
        data.left = new FormAttachment(0);
        data.width = btnW;
        this.btnFilter.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.btnAddItem);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.viewer.getTable().setLayoutData((Object)data);
        toolkit.adapt((Composite)this);
    }

    public void updateViewerInput(IEditableDataObjectList<IMinimalEditableDataObject> def) {
        System.out.println("updateViewerInput 1");
        Object[] aa = def == null ? null : def.toArray();
        this.viewer.setInput((Object)aa);
        if (this.lstSecteurs == null) {
            this.viewer.getTable().pack();
        }
        this.setLstSecteurs(def);
        if (def != null && def.size() > 0) {
            Timer t = new Timer();
            TimerTask tt = new TimerTask(){

                @Override
                public void run() {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Object elementAt = (this).BaseSecteurControl.this.viewer.getElementAt(0);
                            if (elementAt != null) {
                                (this).BaseSecteurControl.this.viewer.setSelection((ISelection)new StructuredSelection(elementAt), true);
                            }
                        }
                    });
                }
            };
            t.schedule(tt, 100L);
        }
    }

    public SecteurEditor getParentEditor() {
        return this.parentEditor;
    }

    public final IEditableDataObjectList<XSecteur> getLstSecteurs() {
        return this.lstSecteurs;
    }

    public final void setLstSecteurs(IEditableDataObjectList<IMinimalEditableDataObject> lstRess) {
        this.lstSecteurs = new EditableDataObjectList(lstRess.size());
        for (IMinimalEditableDataObject i : lstRess) {
            this.lstSecteurs.add((IMinimalEditableDataObject)((XSecteur)i));
        }
    }
}

