/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.preferences;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.preferences.IPreferencesPluginController;
import ca.infodata.ofys.data.dataaccess.CommonAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.dataaccess.util.notification.DataObjectNotificationHandler;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelResType;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.ofys.ui.dashboard.models.MVProps;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.IPair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;

public class PreferencesPluginController
implements IPreferencesPluginController {
    private static final Logger logger = Logger.getLogger(PreferencesPluginController.class.getName());
    private boolean isLoadingLabels = false;
    private final ArrayList<XLabelDef> labels = new ArrayList();
    private final HashMap<Integer, XLabelDef> idMapLabel = new HashMap();
    private final HashMap<XLabelResType, List<XLabelDef>> typeMapLabels = new HashMap();
    private GlobalInstancesAdapter globalInstancesListener;
    private NotificationHandlerImplementation notificationHandlerImplementation = new NotificationHandlerImplementation();
    private MVProps mvProps;

    public PreferencesPluginController(BundleContext context) {
        this.globalInstancesListener = new GlobalInstancesAdapter(){

            public void sessionChanged() {
                PreferencesPluginController.this.loadLabels();
            }
        };
        Application.get().getGlobalInstances().addGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
        Application.get().getGlobalInstances().getNotificationSystem().addDataObjectNotificationHandler((DataObjectNotificationHandler)this.notificationHandlerImplementation);
        this.mvProps = new MVProps();
    }

    private void updateLabelDef(XLabelDef def) {
        this.labels.remove(def);
        this.labels.add(def);
        this.idMapLabel.put(def.getId(), def);
        for (Map.Entry<XLabelResType, List<XLabelDef>> e : this.typeMapLabels.entrySet()) {
            e.getValue().remove(def);
        }
        List<XLabelDef> list = this.typeMapLabels.get(def.getType());
        if (list == null) {
            list = new ArrayList<XLabelDef>();
            this.typeMapLabels.put(def.getType(), list);
        }
        list.add(def);
    }

    private void loadLabels() {
        if (this.isLoadingLabels) {
            return;
        }
        this.isLoadingLabels = true;
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session == null) {
            this.loadLabels(null);
        } else {
            Callback callback = new Callback((IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    try {
                        List list = (List)response.getObj();
                        PreferencesPluginController.this.loadLabels(list);
                    }
                    catch (Exception e) {
                        this.exception(e);
                    }
                }

                public void exception(Exception e) {
                    logger.log(Level.WARNING, "Failed to load users list", e);
                    PreferencesPluginController.this.loadLabels(null);
                }
            };
            try {
                CommonAccessorClient.getInstance().findLabelDef(null, (ICallback)callback, session);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to load users list", e);
                callback.kill();
            }
        }
    }

    private void loadLabels(List<XLabelDef> list) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("loading labels list");
        }
        this.labels.clear();
        this.idMapLabel.clear();
        this.typeMapLabels.clear();
        if (list != null) {
            this.labels.addAll(list);
            for (XLabelDef e : list) {
                this.idMapLabel.put(e.getId(), e);
                List<XLabelDef> list2 = this.typeMapLabels.get(e.getType());
                if (list2 == null) {
                    list2 = new ArrayList<XLabelDef>();
                    this.typeMapLabels.put(e.getType(), list2);
                }
                list2.add(e);
            }
        }
        this.isLoadingLabels = false;
    }

    public List<XLabelDef> findLabel(XLabelResType type) {
        List<XLabelDef> list = this.typeMapLabels.get(type);
        if (list == null) {
            return null;
        }
        return new ArrayList<XLabelDef>(list);
    }

    public XLabelDef getLabel(Integer id) {
        if (id == null) {
            return null;
        }
        XLabelDef e = this.idMapLabel.get(id);
        if (id != null && e == null) {
            logger.log(Level.SEVERE, "Failed to get XLabelDef for id " + id + ". \n" + Log.getPrintedStackTrace());
        }
        return e;
    }

    public XLabelDef getLabelOrItsReplacement(Integer id) {
        XLabelDef label = this.getLabel(id);
        if (label == null) {
            return null;
        }
        XLabelDef r = this.getLabelReplacement(label);
        if (r == null) {
            return label;
        }
        return r;
    }

    public XLabelDef getLabelReplacement(XLabelDef def) {
        if (def == null) {
            return null;
        }
        for (XLabelDef e : this.labels) {
            if (!e.getFusions().contains(def.getId())) continue;
            return e;
        }
        return null;
    }

    public void dispose() {
        Application.get().getGlobalInstances().removeGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
        Application.get().getGlobalInstances().getNotificationSystem().removeDataObjectNotificationHandler((DataObjectNotificationHandler)this.notificationHandlerImplementation);
        this.mvProps.dispose();
    }

    public Object get(String key) {
        return PreferencesSettings.getInstance().get(key);
    }

    public void put(String key, String value) {
        PreferencesSettings.getInstance().put(key, value);
    }

    public void put(String key, Integer value) {
        PreferencesSettings.getInstance().put(key, (Serializable)value);
    }

    public int getNB_RESULT_BY_PAGE() {
        return 25;
    }

    public Object getUserProp(String key) {
        return this.mvProps.getObjectFromMap(MVProps.MAPS.USER.name(), key);
    }

    public void removeUserProp(String key) {
        this.mvProps.removeObjectFromMap(MVProps.MAPS.USER.name(), key);
    }

    public void addUserProp(String key, Object value) {
        this.mvProps.addObjectToMap(MVProps.MAPS.USER.name(), key, value);
    }

    public Object getGlobalProp(String key) {
        return this.mvProps.getObjectFromMap(MVProps.MAPS.GLOBAL.name(), key);
    }

    public void removeGlobalProp(String key) {
        this.mvProps.removeObjectFromMap(MVProps.MAPS.GLOBAL.name(), key);
    }

    public void addGlobalProp(String key, Object value) {
        System.out.println("addGlobalProp");
        this.mvProps.addObjectToMap(MVProps.MAPS.GLOBAL.name(), key, value);
    }

    public Map<String, Object> getUser(String[] keys) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            res.put(s, this.getUserProp(s));
            ++n2;
        }
        return res;
    }

    public Map<String, Object> getGlobal(String[] keys) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            res.put(s, this.getGlobalProp(s));
            ++n2;
        }
        return res;
    }

    public void put(Iterator<IPair<String, String>> iterator) {
        while (iterator.hasNext()) {
            IPair<String, String> e = iterator.next();
            this.put((String)e.getFirst(), (String)e.getSecond());
        }
    }

    private final class NotificationHandlerImplementation
    implements DataObjectNotificationHandler {
        private NotificationHandlerImplementation() {
        }

        public void handle(DataObjectUpdatedNotification notification) {
            final IDataObject object = notification.getObject();
            if (object instanceof XLabelDef) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PreferencesPluginController.this.updateLabelDef((XLabelDef)object);
                    }
                });
            }
        }
    }
}

