/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.preferences;

import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.file.FileUtil;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.swt.program.Program;

public class ExportPatientCallback
extends JobCallback {
    private static final Logger logger = Logger.getLogger(ExportPatientCallback.class.getName());
    private static final String EXPORT_CLIENTS = Messages.getString((String)"EXPORT_CLIENTS", (String[])new String[0]);
    public static final String DEFAULT_PATH = String.valueOf(FileUtil.TEMP_FOLDER) + "/export/";
    private boolean openGeneratedFile;
    private String filePath;

    public ExportPatientCallback() {
        super(EXPORT_CLIENTS, (IStatusHandler)DefaultStatusHandler.getInstance());
    }

    public void responseReceived(ReturnObject response) {
        if (response == null || response.getObj() == null) {
            return;
        }
        try {
            IStatus status = (IStatus)response.getObj();
            if (status.isOkToProceed()) {
                File file = this.writeOnDisk((String)((Object)status.getData()));
                if (this.openGeneratedFile) {
                    Program.launch((String)file.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in ExportPatientCallback response. " + this.toString(), e);
        }
    }

    private File writeOnDisk(String data) {
        File file;
        block12: {
            String path = StringUtils.isBlank((CharSequence)this.filePath) ? DEFAULT_PATH : this.filePath;
            File folder = new File(path);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            String fileName = "clients_" + ExportPatientCallback.getFormattedDateTimeForFileName() + ".csv";
            file = new File(path, fileName);
            logger.info("Writing data to file " + file.getAbsolutePath());
            OutputStream outputStream = null;
            try {
                try {
                    outputStream = new FileOutputStream(file);
                    outputStream.write(data.getBytes());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error writing data to file " + file.getAbsolutePath(), e);
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        return file;
    }

    public static String getFormattedDateTimeForFileName() {
        FastDateFormat format = FastDateFormat.getInstance((String)"yyyy--MM--dd--HH--mm--ss", (Locale)Locale.getDefault());
        return format.format(new Date(DateUtil.newCalendar().getTimeInMillis()));
    }

    public boolean getOpenGeneratedFile() {
        return this.openGeneratedFile;
    }

    public void setOpenGeneratedFile(boolean openGeneratedFile) {
        this.openGeneratedFile = openGeneratedFile;
    }

    public void setFilePath(String path) {
        this.filePath = path;
    }
}

