/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.user;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.UserAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.signatures.XUserSignature;
import ca.infodata.ofys.data.middle.dataobjects.signatures.XUserSignatures;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.controls.CallbackComposite;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareLabel;
import ca.infodata.ofys.ui.controls.FontAwareShell;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialog;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class UserSignaturesDialog {
    private static final Logger logger = Logger.getLogger(UserSignatureControl.class.getName());
    private static final String SAUVEGARDE_EN_COURS = Messages.getString((String)"B2B.DIALOG.SAUVEGARDE_EN_COURS", (String[])new String[0]);
    private FontAwareShell dialog;
    private FormToolkit toolkit;
    private XUserSignatures signatures;
    private CallbackComposite callbackComposite;
    private FullSignatureControl fullControl;
    private InitialSignatureControl initialControl;

    public UserSignaturesDialog(Shell parent, XUser user) {
        this.createDialog(parent);
        try {
            UserAccessorClient.getInstance().getUserSignatures((ICallback)this.callbackComposite.getCallback(), Application.get().getGlobalInstances().getSession(), user.getId());
        }
        catch (Exception e) {
            this.callbackComposite.showErrorComposite(null, (Throwable)e);
        }
    }

    private void createDialog(Shell parent) {
        this.dialog = new FontAwareShell(parent, 67696);
        this.dialog.setText("Gestion des signatures");
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        ResourceGetter.linkResourceWithWidgetLife((Object)white, (Widget)this.dialog);
        this.dialog.setBackground(white);
        this.dialog.setLayout((Layout)new FillLayout());
        this.toolkit = UI.createToolKit((Widget)this.dialog);
        this.dialog.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = UserSignaturesDialog.this.canClose();
            }
        });
        this.callbackComposite = new CallbackComposite((Composite)this.dialog, 0, this.toolkit){

            protected FontAwareComposite createLoadedComposite(Composite parent, FormToolkit toolkit, ReturnObject response) {
                return UserSignaturesDialog.this.createBody(parent, response);
            }

            protected void updateLoadedComposite(ReturnObject response) {
                UserSignaturesDialog.this.updateBody(response);
            }
        };
    }

    protected void updateBody(ReturnObject response) {
        this.signatures = (XUserSignatures)response.getObj();
        if (this.signatures.full == null) {
            this.signatures.full = new XUserSignature();
            this.signatures.full.setIdUser(Integer.valueOf(this.signatures.idUser));
        }
        if (this.signatures.initial == null) {
            this.signatures.initial = new XUserSignature();
            this.signatures.initial.setIdUser(Integer.valueOf(this.signatures.idUser));
        }
        this.fullControl.refresh();
        this.initialControl.refresh();
    }

    public void open() {
        this.dialog.pack();
        this.dialog.setSize(800, 400);
        UI.centerComposite((Composite)this.dialog, (Composite)this.dialog.getParent());
        this.dialog.open();
    }

    private FontAwareComposite createBody(Composite parent, ReturnObject response) {
        this.signatures = (XUserSignatures)response.getObj();
        if (this.signatures.full == null) {
            this.signatures.full = new XUserSignature();
            this.signatures.full.setIdUser(Integer.valueOf(this.signatures.idUser));
        }
        if (this.signatures.initial == null) {
            this.signatures.initial = new XUserSignature();
            this.signatures.initial.setIdUser(Integer.valueOf(this.signatures.idUser));
        }
        FontAwareComposite c = new FontAwareComposite(parent, 0);
        this.fullControl = new FullSignatureControl((Shell)this.dialog, (Composite)c, 2048, this.toolkit){

            @Override
            protected XUserSignature getSignature() {
                return ((UserSignaturesDialog)UserSignaturesDialog.this).signatures.full;
            }
        };
        this.initialControl = new InitialSignatureControl((Shell)this.dialog, (Composite)c, 2048, this.toolkit){

            @Override
            protected XUserSignature getSignature() {
                return ((UserSignaturesDialog)UserSignaturesDialog.this).signatures.initial;
            }
        };
        MyButton btnSave = new MyButton((Composite)c, "Sauvegarder", 8, this.toolkit);
        btnSave.setFont(2, 1);
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                UserSignaturesDialog.this.save();
            }
        });
        MyButton btnCancel = new MyButton((Composite)c, "Annuler", 8, this.toolkit);
        btnCancel.setFont(2, 0);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                UserSignaturesDialog.this.close();
            }
        });
        Label separator = this.toolkit.createSeparator(parent, 256);
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        c.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        this.fullControl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(50);
        data.right = new FormAttachment(100);
        this.initialControl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.initialControl);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        separator.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment(100);
        btnCancel.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment((Control)btnCancel);
        btnSave.setLayoutData((Object)data);
        return c;
    }

    protected void close() {
        this.dialog.close();
    }

    protected void save() {
        final int uniqueKey = this.hashCode();
        final XSession session = Application.get().getGlobalInstances().getSession();
        final XUserSignatures signatures2 = this.signatures;
        final MyProgressMonitorDialog progressMonitorDialog = new MyProgressMonitorDialog((Shell)this.dialog);
        try {
            progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(SAUVEGARDE_EN_COURS, -1);
                    try {
                        ReturnObject response = UserAccessorClient.getInstance().saveSync(uniqueKey, session, (Serializable)signatures2, false);
                        if (response == null) {
                            logger.severe("response is null");
                            MessageUtil.unexpectedExceptionMsg((Shell)progressMonitorDialog.getShell());
                        } else if (response.getObj() == null) {
                            logger.severe("response.obj is null");
                            MessageUtil.unexpectedExceptionMsg((Shell)progressMonitorDialog.getShell());
                        } else if (!(response.getObj() instanceof XUserSignatures)) {
                            logger.severe("response.obj not instance XUserSignatures ");
                            MessageUtil.unexpectedExceptionMsg((Shell)progressMonitorDialog.getShell());
                        } else if (response.getStatus() == null) {
                            logger.severe("response.status is null");
                            MessageUtil.unexpectedExceptionMsg((Shell)progressMonitorDialog.getShell());
                        } else if (!response.getStatus().isOkToProceed()) {
                            MessageUtil.show((Shell)progressMonitorDialog.getShell(), (IStatus)response.getStatus());
                        } else {
                            UserSignaturesDialog.this.update(response);
                        }
                    }
                    catch (Exception e) {
                        MessageUtil.show((Shell)progressMonitorDialog.getShell(), (Exception)e);
                        logger.log(Level.SEVERE, "Error", e);
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "Error with trying to send b2bModif to server", e);
            MessageUtil.unexpectedExceptionMsg((Shell)this.dialog, (Exception)e);
        }
    }

    protected void update(ReturnObject response) {
        if (this.callbackComposite != null && !this.callbackComposite.isDisposed()) {
            this.callbackComposite.showLoadedCompositeInSwtThread(response);
        }
    }

    protected boolean canClose() {
        return true;
    }

    private static abstract class FullSignatureControl
    extends UserSignatureControl {
        public FullSignatureControl(Shell dialog, Composite parent, int style, FormToolkit toolkit) {
            super(dialog, parent, style, toolkit);
        }

        @Override
        protected String getSignatureTitle() {
            return "Compl\u00e8te";
        }
    }

    private static abstract class InitialSignatureControl
    extends UserSignatureControl {
        public InitialSignatureControl(Shell dialog, Composite parent, int style, FormToolkit toolkit) {
            super(dialog, parent, style, toolkit);
        }

        @Override
        protected String getSignatureTitle() {
            return "Initiales";
        }
    }

    private static abstract class UserSignatureControl
    extends FontAwareComposite {
        private MyLabel labelSignature;
        private Label imageCanvas;
        private MyButton btnRemove;
        private MyButton btnSearch;
        private FontAwareLabel imageLabel = new FontAwareLabel((Composite)this, 16384);

        public UserSignatureControl(final Shell dialog, Composite parent, int style, FormToolkit toolkit) {
            super(parent, style);
            this.imageLabel.setText(this.getSignatureTitle());
            this.imageLabel.setFont(4, 1);
            this.btnSearch = new MyButton((Composite)this, "", 8, toolkit);
            Image search = ResourceGetter.getImage((String)"images/rechercher.gif");
            ResourceGetter.linkResourceWithWidgetLife((Object)search, (Widget)this);
            this.btnSearch.setImage(search);
            this.btnRemove = new MyButton((Composite)this, "", 8, toolkit);
            Image delete = ResourceGetter.getImage((String)"images/delete_edit.gif");
            ResourceGetter.linkResourceWithWidgetLife((Object)delete, (Widget)this);
            this.btnRemove.setImage(delete);
            this.imageCanvas = new Label((Composite)this, 2048);
            this.imageCanvas.setBackground(toolkit.getColors().getBackground());
            this.labelSignature = new MyLabel((Composite)this, "", 16384);
            FormLayout layout = new FormLayout();
            layout.spacing = 5;
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            this.setLayout((Layout)layout);
            FormData data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            this.imageLabel.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.right = new FormAttachment((Control)this.btnRemove, 0, 16384);
            this.btnSearch.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.right = new FormAttachment(100);
            this.btnRemove.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.btnSearch);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            data.width = 400;
            data.height = 200;
            this.imageCanvas.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.imageCanvas);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            this.labelSignature.setLayoutData((Object)data);
            this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.deleteSignatureImage();
                    this.refresh();
                }
            });
            this.btnSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog fileDialog = new FileDialog(dialog, 4096);
                    fileDialog.setFilterExtensions(new String[]{"*.png;*.PNG"});
                    String selected = fileDialog.open();
                    if (StringUtils.isNotBlank((String)selected)) {
                        try {
                            this.setSignatureImage(this.loadImage(selected));
                            this.refresh();
                        }
                        catch (Exception e2) {
                            MessageUtil.show((Shell)dialog, (Exception)e2);
                        }
                    }
                }
            });
            this.refresh();
        }

        protected byte[] loadImage(String selected) throws FileNotFoundException, IOException {
            File file = new File(selected);
            byte[] image = IOUtils.toByteArray((InputStream)new FileInputStream(file));
            return image;
        }

        protected void refresh() {
            byte[] simage = this.getSignatureImage();
            if (simage == null) {
                this.imageCanvas.setImage(null);
                this.labelSignature.setText("");
            } else {
                Image image = new Image((Device)this.imageCanvas.getDisplay(), new ImageData((InputStream)new ByteArrayInputStream(simage)));
                this.imageCanvas.setImage(image);
                this.labelSignature.setText(this.getSignatureLabel());
            }
        }

        protected String getSignatureLabel() {
            String type;
            XUserSignature signature = this.getSignature();
            if (signature.getImage() == null) {
                return "";
            }
            XBaseUser user = PersonUiPlugin.getDefault().getUser(signature.getIdUser());
            XBaseProfessionnal prof = (XBaseProfessionnal)PersonUiPlugin.getDefault().getBasePersonByIdPerson(user.getIdPerson());
            String name = new JoinList(", ", new Object[]{prof.getFirstName(), prof.getLastName()}).toString();
            if (prof.getProfessionalType() != null) {
                switch (prof.getProfessionalType()) {
                    case INFIRMIERE: 
                    case INFIRMIERE_PRATICIENNE: {
                        type = "Inf.";
                        break;
                    }
                    case RESIDENT: 
                    case STAGIAIRE_CMQ: {
                        type = "Res.";
                        break;
                    }
                    case EXTERNE: {
                        type = "Ext.";
                        break;
                    }
                    default: {
                        if (prof.isStagiaire()) {
                            type = "Res.";
                            break;
                        }
                        type = "Md.";
                        break;
                    }
                }
            } else {
                type = prof.isStagiaire() ? "Res." : "Md.";
            }
            String code = StringUtils.isNotBlank((String)prof.getCode()) && !prof.getCode().equals("9999999") ? prof.getCode5chiffres() : null;
            String label = code != null ? String.format("%s %s (%s)", name, type, code) : String.format("%s %s", name, type);
            return label;
        }

        protected byte[] getSignatureImage() {
            return this.getSignature().getImage();
        }

        protected void setSignatureImage(byte[] image) {
            XUserSignature signature = this.getSignature();
            signature.setImage(image);
            this.refresh();
        }

        protected void deleteSignatureImage() {
            XUserSignature signature = this.getSignature();
            signature.setImage(null);
            this.refresh();
        }

        protected abstract XUserSignature getSignature();

        protected abstract String getSignatureTitle();
    }
}

