/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CommonAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.search.XSearchResult;
import ca.infodata.ofys.ui.controls.AbstractTreeElement;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import ca.infodata.ofys.ui.person.patient.search.menu.SearchResultElement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;

public class SearchResultRootElement
extends AbstractTreeElement {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.person.patient.search.menu.SearchResultRootElement");
    private ITreeElements[] children;

    public SearchResultRootElement(ITreeElements parent) {
        super(parent);
    }

    public String getText() {
        return Messages.getString((String)"LISTE_DES_RESULTATS", (String[])new String[0]);
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/search-icon16.png");
    }

    public Object[] getChildren() {
        if (this.children == null) {
            this.find();
            return new ITreeElements[]{new LoadingElement((ITreeElements)this)};
        }
        return this.children;
    }

    private void find() {
        JobCallback callback = new JobCallback(){

            public void responseReceived(ReturnObject response) {
                SearchResultRootElement.this.fillChildren((List)response.getObj());
            }
        };
        try {
            CommonAccessorClient.getInstance().findSearchResult(Application.get().getGlobalInstances().getSession(), (ICallback)callback);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            this.fillChildren(null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            callback.kill();
            this.fillChildren(null);
        }
    }

    private void fillChildren(List<XSearchResult> list) {
        if (list == null) {
            this.children = new ITreeElements[0];
        } else {
            ArrayList<SearchResultElement> listChild = new ArrayList<SearchResultElement>(list.size());
            for (XSearchResult e : list) {
                listChild.add(new SearchResultElement((ITreeElements)this, e));
            }
            this.children = listChild.toArray(new ITreeElements[listChild.size()]);
        }
        IntroPlugin.getDefault().refreshViews((Object)this);
    }

    public boolean hasChildren() {
        return true;
    }
}

