/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CommonAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.search.XSearchOrder;
import ca.infodata.ofys.ui.controls.AbstractTreeElement;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import ca.infodata.ofys.ui.person.patient.search.menu.NewSearchOrderElement;
import ca.infodata.ofys.ui.person.patient.search.menu.SearchOrderElement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;

public class SearchOrderRootElement
extends AbstractTreeElement {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.person.patient.search.menu.SearchOrderRootElement");
    private ITreeElements[] children;

    public SearchOrderRootElement(ITreeElements parent) {
        super(parent);
    }

    public String getText() {
        return Messages.getString((String)"LISTE_DES_DEMANDES", (String[])new String[0]);
    }

    public Object[] getChildren() {
        if (this.children == null) {
            this.find();
            return new ITreeElements[]{new NewSearchOrderElement((ITreeElements)this), new LoadingElement((ITreeElements)this)};
        }
        return this.children;
    }

    private void find() {
        JobCallback callback = new JobCallback(){

            public void responseReceived(ReturnObject response) {
                SearchOrderRootElement.this.fillChildren((List)response.getObj());
            }
        };
        try {
            CommonAccessorClient.getInstance().findSearchOrder(Application.get().getGlobalInstances().getSession(), (ICallback)callback);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            this.fillChildren(null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            callback.kill();
            this.fillChildren(null);
        }
    }

    private void fillChildren(List<XSearchOrder> list) {
        if (list == null) {
            this.children = new ITreeElements[0];
        } else {
            ArrayList<AbstractTreeElement> listChild = new ArrayList<AbstractTreeElement>(list.size());
            listChild.add(new NewSearchOrderElement((ITreeElements)this));
            ArrayList<SearchOrderElement> listDone = new ArrayList<SearchOrderElement>();
            ArrayList<SearchOrderElement> listNotDone = new ArrayList<SearchOrderElement>();
            ArrayList<SearchOrderElement> listAll = new ArrayList<SearchOrderElement>();
            for (XSearchOrder e : list) {
                if (Boolean.TRUE.equals(e.getIsDone())) {
                    listDone.add(new SearchOrderElement((ITreeElements)this, e));
                } else {
                    listNotDone.add(new SearchOrderElement((ITreeElements)this, e));
                }
                listAll.add(new SearchOrderElement((ITreeElements)this, e));
            }
            listChild.add(new AbstractTreeElement((ITreeElements)this, "Ex\u00e9cut\u00e9s", "images/search-icon16.png", listDone));
            listChild.add(new AbstractTreeElement((ITreeElements)this, "Non Ex\u00e9cut\u00e9s", "images/search-icon16.png", listNotDone));
            listChild.add(new AbstractTreeElement((ITreeElements)this, "Tous", "images/search-icon16.png", listAll));
            this.children = listChild.toArray(new ITreeElements[listChild.size()]);
        }
        IntroPlugin.getDefault().refreshViews((Object)this);
    }

    public boolean hasChildren() {
        return true;
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/search-icon16.png");
    }
}

