/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search;

import apple.finder.search.ui.ICriteriaField;
import apple.finder.search.ui.ICriteriaOperator;
import apple.finder.search.ui.ISetFactory;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import ca.infodata.ofys.ui.person.patient.search.IAppleFinderGridFactory2;
import ca.infodata.util1.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSetFactory
implements ISetFactory {
    private IAppleFinderGridFactory2 factory;
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;
    private Document doc;
    private Node first;

    public XmlSetFactory(IAppleFinderGridFactory2 factory, String xml) throws Exception {
        this.factory = factory;
        if (StringUtils.isNotBlank((String)xml)) {
            this.docFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = this.docFactory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("utf-8"));
            this.doc = this.docBuilder.parse(is);
            Node firstChild = this.doc.getFirstChild();
            this.first = firstChild != null && "root".equals(firstChild.getNodeName()) ? firstChild : this.doc;
        }
    }

    public boolean isAndGroup(Object group) {
        Node node = (Node)group;
        return group != null && "AndGroup".equals(node.getNodeName());
    }

    public boolean isOrGroup(Object group) {
        Node node = (Node)group;
        return group != null && "OrGroup".equals(node.getNodeName());
    }

    public boolean isNotGroup(Object group) {
        Node node = (Node)group;
        return group != null && "NotGroup".equals(node.getNodeName());
    }

    public boolean isCriteria(Object group) {
        Node node = (Node)group;
        return group != null && "Criteria".equals(node.getNodeName());
    }

    public boolean isEmpty(Object group) {
        Node node = (Node)group;
        return group != null || node.getChildNodes().getLength() == 0;
    }

    public Iterator<Object> items(Object group) {
        Node node = (Node)group;
        if (group == null) {
            return Collections.emptyList().iterator();
        }
        return new NodeIterator(node.getChildNodes());
    }

    public Object first() {
        return this.first;
    }

    public ICriteriaField getField(Object group) {
        Node node = (Node)group;
        NamedNodeMap attributes = node.getAttributes();
        Node idNode = attributes.getNamedItem("id");
        String id = idNode.getNodeValue();
        for (ICriteriaField f : this.factory.getFields()) {
            if (!f.getId().equals(id)) continue;
            return f;
        }
        throw new RuntimeException("Invalid field id " + id);
    }

    public ICriteriaOperator getOperator(Object group) {
        Node node = (Node)group;
        ICriteriaField field = this.getField(group);
        NamedNodeMap attributes = node.getAttributes();
        Node operatorNode = attributes.getNamedItem("operator");
        String id = operatorNode.getNodeValue();
        for (ICriteriaOperator operator : this.factory.getCriteria(field).getOperators()) {
            if (!operator.getId().equals(id)) continue;
            return operator;
        }
        throw new RuntimeException("Invalid operator id " + id);
    }

    public Object getValueReference(Object group) {
        Node node = (Node)group;
        ICriteriaField field = this.getField(group);
        AbstractCriteria criteria = this.factory.getCriteria(field);
        HashMap<String, String> map = new HashMap<String, String>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node e = childNodes.item(i);
            map.put(e.getNodeName(), e.getTextContent());
            ++i;
        }
        return criteria.xmlToValue(map);
    }

    private static class NodeIterator
    implements Iterator<Object> {
        private NodeList nodeList;
        private int length;
        private int i;

        public NodeIterator(NodeList nodeList) {
            this.nodeList = nodeList;
            this.length = nodeList.getLength();
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.length;
        }

        @Override
        public Object next() {
            Node item = this.nodeList.item(this.i);
            ++this.i;
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

