/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.menu.element;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.controls.AbstractTreeElement;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElements2;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.person.PersonMultiEditorFactory;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.FusionPatientEditor;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.person.patient.XPatientFormatter;
import ca.infodata.ofys.ui.person.print.PatientPrintDialog;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;

public class PatientElements
extends AbstractTreeElement
implements ITreeElements2 {
    private XPatient patient;
    private ITreeElements[] children;

    public PatientElements(ITreeElements parent, XPatient patient) {
        super(parent);
        this.patient = patient;
    }

    public Object[] getChildren() {
        System.out.println("PatientElements.getChildren()");
        if (this.children == null) {
            ArrayList listChild = new ArrayList(2);
            listChild.addAll(this.getChildrenByExtension());
            this.children = listChild.toArray(new ITreeElements[0]);
        }
        return this.children;
    }

    public boolean hasChildren() {
        return this.patient != null && this.patient.getId() != null;
    }

    public String getText() {
        String dossier;
        if (this.patient == null || this.patient.getId() == null) {
            return "...";
        }
        XPatient xpt = null;
        if (this.patient instanceof XPatient) {
            xpt = this.patient;
        } else {
            xpt = PatientUtil.getSimplePatient(this.patient);
            if (xpt != null) {
                this.patient = xpt;
            }
        }
        if (xpt == null) {
            if (Application.get().getGlobalInstances().inDebugMode()) {
                return this.patient.getId() + ", " + this.patient.getNameBirthdateSex();
            }
            return this.patient.getNameBirthdateSex();
        }
        String string = dossier = StringUtils.isEmpty((String)this.patient.getPatientRecordNumber()) ? "" : " " + this.patient.getPatientRecordNumber();
        if (Application.get().getGlobalInstances().inDebugMode()) {
            return this.patient.getId() + ", " + this.patient.getNameBirthdateSex() + dossier;
        }
        return String.valueOf(this.patient.getNameBirthdateSex()) + dossier;
    }

    public String getTooltipText() {
        if (this.patient == null || this.patient.getId() == null) {
            return "...";
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getText()).append("\n");
        XPatient xpt = null;
        if (this.patient instanceof XPatient) {
            xpt = this.patient;
        } else {
            xpt = PatientUtil.getSimplePatient(this.patient);
            if (xpt != null) {
                this.patient = xpt;
            }
        }
        if (xpt == null) {
            sb.append(this.patient.getHealthInsuranceNumber()).append(" (").append(this.patient.getExpirationCAM()).append(")");
        } else {
            sb.append(XPatientFormatter.formatComplete((IPatient)xpt));
        }
        return sb.toString();
    }

    public Image getImage() {
        if (this.patient != null) {
            if ("F".equalsIgnoreCase(this.patient.getGender())) {
                return ResourceGetter.getImage((String)"images/person-female-icon16.png");
            }
            if ("M".equalsIgnoreCase(this.patient.getGender())) {
                return ResourceGetter.getImage((String)"images/person-male-icon16.png");
            }
        }
        return ResourceGetter.getImage((String)"images/persons-icon16.png");
    }

    public String getEditorClass() {
        if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().getSession().getClientPreferences() != null && Application.get().getGlobalInstances().getSession().getClientPreferences().isMultiplePatientWindows()) {
            return null;
        }
        return PatientMultiEditor.class.getName();
    }

    public IEditorInput getEditorInput() {
        if (this.patient == null || this.patient.getId() == null) {
            return null;
        }
        return new EditorInput((IDataObject)this.patient);
    }

    public XImageDecorator getDecorators() {
        if (this.patient == null || this.patient.getId() == null) {
            return null;
        }
        return this.patient.getDecorators();
    }

    public XPatient getPatient() {
        return this.patient;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public void showContextMenu(final Control control) {
        if (this.patient != null && this.patient.getId() != null && Application.get().getGlobalInstances().getSession() != null) {
            MenuItem item;
            Menu menu = control.getMenu();
            if (menu == null || menu.isDisposed()) {
                menu = new Menu(control);
                menu.setVisible(true);
            }
            if (Application.get().getGlobalInstances().hasRight(XRight.PATIENT)) {
                item = new MenuItem(menu, 8);
                item.setText(Messages.getString((String)"OUVRIR_FICHE_PATIENT", (String[])new String[0]));
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PatientElements.this.doDoubleClick();
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText(Messages.getString((String)"IMPRIMER", (String[])new String[0]));
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        new PatientPrintDialog(control.getShell(), PatientElements.this.patient).open();
                    }
                });
            }
            if (Application.get().getGlobalInstances().hasRight(XRight.FUSION_PATIENT)) {
                item = new MenuItem(menu, 8);
                item.setText(Messages.getString((String)"FUSION/DEFUSION_DE_CLIENT", (String[])new String[0]));
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EditorInput input = new EditorInput((IDataObject)PatientElements.this.patient.clone());
                        String name = FusionPatientEditor.class.getName();
                        BaseEditor.openEditorSafe((IEditorInput)input, (String)name);
                    }
                });
            }
        }
    }

    public int showForPerspective() {
        return 1;
    }

    public int hashCode() {
        return new String(String.valueOf(this.getParent().hashCode()) + " " + (this.patient == null ? 0 : this.patient.hashCode()) + " " + ((Object)((Object)this)).getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof PatientElements && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    protected void setPatient(XPatient patient) {
        if (!MiscUtil.areObjectsEquals((Object)this.patient, (Object)patient)) {
            this.patient = patient;
            this.children = null;
            DossierPlugin.getDefault().refreshTree((ITreeElements)this);
        }
    }

    public void doDoubleClick() {
        if (this.patient != null) {
            PersonMultiEditorFactory.openPatient((IPatient)this.patient);
        }
    }

    public void doSelect() {
        PersonUiPlugin.getDefault().setCurrentPatient((IPatient)this.getPatient());
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }
}

