/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.contact;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformationOrigin;
import ca.infodata.ofys.ui.controls.BaseSectionSwitchTable;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.IProposalListener;
import ca.infodata.ofys.ui.controls.ListTable;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMasks;
import ca.infodata.ofys.ui.controls.QuickProposalEdition;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.template.completion.TemplateAssistText;
import ca.infodata.ofys.ui.person.PersonMultiEditor;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.ProviderAR;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class BaseContactInformationControl
extends BaseSectionSwitchTable<XContactInformation> {
    protected IProposalListener proposalListener;
    protected MyLabel lblTypeContact;
    protected MyCombo<Integer> cmbTypeContact;
    protected MyLabel lblContact;
    protected MyMaskedText txtContact;
    protected MyLabel lblNote;
    protected TemplateAssistText txtNote;
    private MyButton cmdEditCompletionProposal;
    private XContactInformation currentContact;
    protected boolean showValidationStatus;
    protected MyButton btnValidate;

    public BaseContactInformationControl(Composite parent, PersonMultiEditor parentEditor, FormToolkit toolkit, boolean showValidationStatus) {
        super(parent, (IBaseEditor2)parentEditor, ListTable.TOP, toolkit, true);
        this.showValidationStatus = showValidationStatus;
        this.init();
    }

    protected XContactInformation getCurrentContact() {
        return this.currentContact;
    }

    protected void setCurrentContact(XContactInformation contact) {
        this.currentContact = contact;
    }

    protected void createEditionControl(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginHeight = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        this.lblTypeContact = new MyLabel(parent, Messages.getString((String)"CONTACT", (String[])new String[0]), 0, this.toolkit);
        ProviderAR<Integer, String> contactTypeLabelProvider = new ProviderAR<Integer, String>(){

            public String get(Integer type) {
                return (String)XContactInformation.TYPES_FORMAT.get(type);
            }
        };
        this.cmbTypeContact = new MyCombo(parent, 8, this.toolkit);
        this.cmbTypeContact.setLabelProvider((ProviderAR)contactTypeLabelProvider);
        this.cmbTypeContact.setItems(XContactInformation.TYPES_FORMAT.keySet());
        this.lblContact = new MyLabel(parent, Messages.getString((String)"VALEUR", (String[])new String[0]), 0, this.toolkit);
        this.txtContact = new MyMaskedText(parent, 4, this.toolkit);
        this.txtContact.setMask(MyMasks.standardTextLower);
        this.lblNote = new MyLabel(parent, Messages.getString((String)"NOTE", (String[])new String[0]), 0, this.toolkit);
        this.txtNote = new TemplateAssistText(parent, 64, this.toolkit);
        this.txtNote.setType(XCompletionProposalType.CONTACT_INFORMATION_NOTE);
        this.cmdEditCompletionProposal = new MyButton(parent, Messages.getString((String)"EDITION", (String[])new String[0]), 8, this.toolkit);
        if (this.showValidationStatus) {
            this.btnValidate = new MyButton(parent, "Confirm\u00e9 ?", 32, this.toolkit);
        }
        if (this.showValidationStatus) {
            this.addColumn(100);
            this.addColumn(200);
            this.addColumn(300);
            this.addColumn(100);
            this.setLabelProvider((ProviderAR)new ProviderAR<XContactInformation, String[]>(){

                public String[] get(XContactInformation a) {
                    if (a == null) {
                        return new String[]{"null"};
                    }
                    String contact = a.getFormatedTelephone();
                    if (contact.length() == 0) {
                        contact = a.getContact();
                    }
                    String validationStatus = a.getOrigin() == null ? "" : (a.getOrigin() == XContactInformationOrigin.OFYS ? "" : "Non-confirm\u00e9");
                    return new String[]{XContactInformation.CONTACT_TYPE_TEXT[a.getTypeContact()], contact, a.getNote(), validationStatus};
                }
            });
        } else {
            this.addColumn(100);
            this.addColumn(200);
            this.addColumn(300);
            this.setLabelProvider((ProviderAR)new ProviderAR<XContactInformation, String[]>(){

                public String[] get(XContactInformation a) {
                    if (a == null) {
                        return new String[]{"null"};
                    }
                    String contact = a.getFormatedTelephone();
                    if (contact.length() == 0) {
                        contact = a.getContact();
                    }
                    return new String[]{XContactInformation.CONTACT_TYPE_TEXT[a.getTypeContact()], contact, a.getNote()};
                }
            });
        }
        this.cmbTypeContact.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BaseContactInformationControl.this.setMaskType();
            }
        });
        this.cmbTypeContact.addListener(13, (Listener)new BaseSectionSwitchTable.SwitchTableModifyListener(this){

            public void sectionEdited(Event e) {
                BaseContactInformationControl.this.currentContact.setTypeContact((Integer)BaseContactInformationControl.this.cmbTypeContact.getSelection());
            }
        });
        this.txtContact.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!(MiscUtil.areObjectsEquals((Object)BaseContactInformationControl.this.cmbTypeContact.getSelection(), (Object)XContactInformation.CONTACT_TYPE_EMAIL) || MiscUtil.areObjectsEquals((Object)BaseContactInformationControl.this.cmbTypeContact.getSelection(), (Object)XContactInformation.CONTACT_TYPE_EMAILS_AUTRES) || MiscUtil.areObjectsEquals((Object)BaseContactInformationControl.this.cmbTypeContact.getSelection(), (Object)XContactInformation.CONTACT_TYPE_IPHONE) || BaseContactInformationControl.this.txtContact.getText().length() != 7)) {
                    BaseContactInformationControl.this.txtContact.setText(String.valueOf(Application.get().getGlobalInstances().getSession().getClientPreferences().getDefaultRegionalCode()) + BaseContactInformationControl.this.txtContact.getText());
                }
            }
        });
        this.cmdEditCompletionProposal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                QuickProposalEdition.editProposal((TemplateAssistText)BaseContactInformationControl.this.txtNote);
            }
        });
        this.txtNote.getStyledText().addModifyListener((ModifyListener)new BaseSectionSwitchTable.SwitchTableModifyListener(this){

            public void sectionEdited(Event e) {
                BaseContactInformationControl.this.currentContact.setNote(BaseContactInformationControl.this.txtNote.getText());
            }
        });
        this.txtContact.addModifyListener((ModifyListener)new BaseSectionSwitchTable.SwitchTableModifyListener(this){

            public void sectionEdited(Event e) {
                BaseContactInformationControl.this.currentContact.setContact(BaseContactInformationControl.this.txtContact.getText());
            }
        });
        if (this.btnValidate != null) {
            this.btnValidate.addSelectionListener((SelectionListener)new BaseSectionSwitchTable.SwitchTableModifyListener(this){

                public void sectionEdited(Event e) {
                    BaseContactInformationControl.this.currentContact.setOrigin(XContactInformationOrigin.OFYS);
                }
            });
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblTypeContact.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblTypeContact.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(22);
        this.cmbTypeContact.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.cmbTypeContact.getControl());
        this.lblContact.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblContact.getControl());
        data.left = new FormAttachment((Control)this.cmbTypeContact.getControl());
        data.right = new FormAttachment(48);
        this.txtContact.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.txtContact.getControl());
        this.lblNote.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblNote.getControl());
        data.left = new FormAttachment(this.txtContact.getControl());
        data.bottom = new FormAttachment(this.txtContact.getControl(), 0, 1024);
        data.right = new FormAttachment(90);
        this.txtNote.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblNote.getControl());
        data.left = new FormAttachment(this.txtNote.getControl());
        data.width = 70;
        this.cmdEditCompletionProposal.setLayoutData((Object)data);
    }

    protected void setMaskType() {
        this.setMaskType((Integer)this.cmbTypeContact.getSelection());
    }

    protected void setMaskType(Integer typeContact) {
        if (MiscUtil.areObjectsEquals((Object)this.cmbTypeContact.getSelection(), (Object)XContactInformation.CONTACT_TYPE_EMAIL) || MiscUtil.areObjectsEquals((Object)this.cmbTypeContact.getSelection(), (Object)XContactInformation.CONTACT_TYPE_EMAILS_AUTRES) || MiscUtil.areObjectsEquals((Object)this.cmbTypeContact.getSelection(), (Object)XContactInformation.CONTACT_TYPE_IPHONE)) {
            this.txtContact.setValidStyle(0);
            this.txtContact.setMask(MyMasks.standardTextLower);
        } else {
            this.txtContact.setValidStyle(10);
            this.txtContact.setMask(MyMasks.phoneNumber);
        }
    }

    public MyCombo<Integer> getCmbTypeContact() {
        return this.cmbTypeContact;
    }
}

