/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.person.INamValidatorService;
import ca.infodata.ofys.client.modules.person.IPersonPluginController;
import ca.infodata.ofys.data.middle.dataobjects.XBaseEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XBasePerson;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XConsultationReason;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.person.BaseEmployeeCache;
import ca.infodata.ofys.ui.person.EmployeeCache;
import ca.infodata.ofys.ui.person.PersonPluginController;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PersonUiPlugin
extends AbstractUIPlugin {
    private static final Logger logger = Logger.getLogger(PersonUiPlugin.class.getName());
    public static boolean showDisclaimerProfessionnal = true;
    public static final int PROP_CURRENT_PATIENT = 1;
    public static final int PROP_FORCE_REFRESH_CURRENT_PATIENT = 2;
    private static PersonUiPlugin plugin;
    private ResourceBundle resourceBundle;
    private List<XAppointmentType> appointmentTypes;
    private Map<Integer, XAppointmentType> idMapAppointmentTypes;
    private Map<String, XConsultationReason> idMapConsultationReasons;
    private PersonPluginController personPluginController;

    public PersonUiPlugin() {
        plugin = this;
        this.appointmentTypes = new ArrayList<XAppointmentType>();
        this.idMapAppointmentTypes = new HashMap<Integer, XAppointmentType>();
        this.idMapConsultationReasons = new HashMap<String, XConsultationReason>();
        try {
            this.resourceBundle = ResourceBundle.getBundle("ca.infodata.ofys.ui.person.PersonUiPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.personPluginController = new PersonPluginController();
        Application.get().setPersonPluginController((IPersonPluginController)this.personPluginController);
    }

    public void stop(BundleContext context) throws Exception {
        this.personPluginController.dispose();
        super.stop(context);
    }

    public static PersonUiPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PersonUiPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public XPatient getCurrentPatient() {
        return this.personPluginController.getCurrentPatient();
    }

    public void setCurrentPatient2(Object patient) {
        this.personPluginController.setCurrentPatient2(patient);
    }

    public void setCurrentPatient(IPatient patient) {
        this.personPluginController.setCurrentPatient(patient);
    }

    public void setCurrentPatient(IPatient patient, boolean forceNull) {
        this.personPluginController.setCurrentPatient(patient, forceNull);
    }

    public void setTimeItemInPatientClicked(long timeItemInPatientClicked) {
        this.personPluginController.setTimeItemInPatientClicked(timeItemInPatientClicked);
    }

    public String getUserCompleteName(Integer idUser) {
        return this.personPluginController.getUserCompleteName(idUser);
    }

    public String getUserName(Integer idUser) {
        return this.personPluginController.getUserName(idUser);
    }

    public String getUserPersonName(Integer idUser) {
        return this.personPluginController.getUserPersonName(idUser);
    }

    public XBaseUser getUser(Integer id) {
        return this.personPluginController.getUser(id);
    }

    public XBaseUser getUserByIdPerson(Integer id) {
        return this.personPluginController.getUserByIdPerson(id);
    }

    public XBasePerson getBasePersonByIdPerson(Integer id) {
        return this.personPluginController.getBasePersonByIdPerson(id);
    }

    public Set<XBaseUser> getUsers() {
        return this.personPluginController.getUsers();
    }

    public XBaseProfessionnal getSessionProfessionnal() {
        return this.personPluginController.getSessionProfessionnal();
    }

    public XBaseProfessionnal getSessionSuperviseur() {
        return this.personPluginController.getSessionSuperviseur();
    }

    public void setSessionSuperviseur(Integer id) {
        this.personPluginController.setSessionSuperviseur(id);
    }

    public XBaseProfessionnal getProfessionnalByNoProf(String noprof) {
        return this.personPluginController.getProfessionnalByNoProf(noprof);
    }

    public XBaseProfessionnal getBaseProfessionnal(Integer id) {
        return this.personPluginController.getBaseProfessionnal(id);
    }

    public XBaseProfessionnal getBaseProfessionnalByIdPerson(Integer idPerson) {
        return this.personPluginController.getBaseProfessionnalByIdPerson(idPerson);
    }

    public XBaseProfessionnal getBaseProfessionnalByIdPerson(Integer idPerson, boolean logIfNotFound) {
        return this.personPluginController.getBaseProfessionnalByIdPerson(idPerson, logIfNotFound);
    }

    public XBaseProfessionnal getBaseProfessionnalByIdPerson(Integer idPerson, boolean logIfNotFound, boolean mustTryFindServer) {
        return this.personPluginController.getBaseProfessionnalByIdPerson(idPerson, logIfNotFound, mustTryFindServer);
    }

    public Stream<XBaseProfessionnal> getBaseProfessionnals() {
        return this.personPluginController.getTreatingProfessionnals();
    }

    public Stream<XBaseProfessionnal> getTreatingProfessionnals() {
        return this.personPluginController.getTreatingProfessionnals();
    }

    public XProfessionnal getProfessionnal(Integer id) {
        return this.personPluginController.getProfessionnal(id);
    }

    public XProfessionnal getProfessionnalByIdPerson(Integer idPerson) {
        return this.personPluginController.getProfessionnalByIdPerson(idPerson);
    }

    public XProfessionnal getProfessionnalByIdPerson(Integer idPerson, boolean logIfNotFound) {
        return this.personPluginController.getProfessionnalByIdPerson(idPerson, logIfNotFound);
    }

    public XProfessionnal getProfessionnalByIdPerson(Integer idPerson, boolean logIfNotFound, boolean mustTryFindServer) {
        return this.personPluginController.getProfessionnalByIdPerson(idPerson, logIfNotFound, mustTryFindServer);
    }

    public XPersonGroup getPersonGroupById(Integer id, boolean logIfNotFound) {
        return this.personPluginController.getPersonGroupById(id, logIfNotFound);
    }

    public XPersonGroup getPersonGroupById(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        return this.personPluginController.getPersonGroupById(id, logIfNotFound, mustTryToFindServer);
    }

    public Stream<XPersonGroup> getAllPersonGroups() {
        return this.personPluginController.getAllPersonGroups();
    }

    public Stream<XPersonGroup> getActivePersonGroups() {
        return this.personPluginController.getActivePersonGroups();
    }

    public XBaseEmployee getSessionEmployee() {
        return this.personPluginController.getSessionEmployee();
    }

    public BaseEmployeeCache getBaseEmployeeCache() {
        return this.personPluginController.getBaseEmployeeCache();
    }

    public EmployeeCache getEmployeeCache() {
        return this.personPluginController.getEmployeeCache();
    }

    public XBaseEmployee getBaseEmployeeByIdPerson(Integer idPerson) {
        return this.personPluginController.getBaseEmployeeByIdPerson(idPerson);
    }

    public XBaseEmployee getBaseEmployeeByIdPerson(Integer idPerson, boolean mustLogFailed) {
        return this.personPluginController.getBaseEmployeeByIdPerson(idPerson, mustLogFailed);
    }

    public XBaseEmployee getBaseEmployeeByIdPerson(Integer idPerson, boolean mustLogFailed, boolean mustTryFindServer) {
        return this.personPluginController.getBaseEmployeeByIdPerson(idPerson, mustLogFailed, mustTryFindServer);
    }

    public XEmployee getEmployeeByIdPerson(Integer idPerson) {
        return this.personPluginController.getEmployeeByIdPerson(idPerson);
    }

    public XEmployee getEmployeeByIdPerson(Integer idPerson, boolean mustLogFailed) {
        return this.personPluginController.getEmployeeByIdPerson(idPerson, mustLogFailed);
    }

    public XEmployee getEmployeeByIdPerson(Integer idPerson, boolean mustLogFailed, boolean mustTryFindServer) {
        return this.personPluginController.getEmployeeByIdPerson(idPerson, mustLogFailed, mustTryFindServer);
    }

    public INamValidatorService getNamValidatorService() {
        return this.personPluginController.getNamValidatorService();
    }

    public Stream<XBaseProfessionnal> getWhoProfReplace(Integer id, LocalDate baseDate) {
        return this.personPluginController.getWhoProfReplace(id, baseDate);
    }

    public boolean doesProfReplace(Integer id, LocalDate baseDate) {
        return this.personPluginController.doesProfReplace(id, baseDate);
    }

    public Stream<XBaseProfessionnal> getWhoProfReplace(Integer id, LocalDateRange baseRange) {
        return this.personPluginController.getWhoProfReplace(id, baseRange);
    }

    public XBaseProfessionnal getWhoReplaceProf(Integer id, LocalDate baseDate) {
        return this.personPluginController.getWhoReplaceProf(id, baseDate);
    }

    public void checkAgainstPatientSensibleMarker(IPatient patient) throws StatusException {
        this.personPluginController.checkAgainstPatientSensibleMarker(patient);
    }

    public boolean isPatientClinicalFileAccessGrantedForSessionProfessionnal(IPatient patient) {
        return this.personPluginController.isPatientClinicalFileAccessGrantedForSessionProfessionnal(patient);
    }

    public List<XAppointmentType> getAppointmentTypes() {
        return this.appointmentTypes;
    }

    public void setAppointmentTypes(List<XAppointmentType> appointmentTypes) {
        this.appointmentTypes = appointmentTypes;
    }

    public Map<Integer, XAppointmentType> getIdMapAppointmentTypes() {
        return this.idMapAppointmentTypes;
    }

    public void setIdMapAppointmentTypes(Map<Integer, XAppointmentType> idMapAppointmentTypes) {
        this.idMapAppointmentTypes = idMapAppointmentTypes;
    }

    public Map<String, XConsultationReason> getMapConsultationReasons() {
        return this.idMapConsultationReasons;
    }

    public void setMapConsultationReasons(Map<String, XConsultationReason> t) {
        this.idMapConsultationReasons = t;
    }

    public XConsultationReason getConsultationReason(String id) {
        if (id == null) {
            return null;
        }
        XConsultationReason type = this.idMapConsultationReasons.get(id);
        if (type == null) {
            logger.log(Level.SEVERE, "Failed to get XAppointmentType for id " + id + ". \n" + Log.getPrintedStackTrace());
        }
        return type;
    }
}

