/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.encounter.patient.search;

import apple.finder.search.ui.UI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.EncounterAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.SWTDelayedListener;
import ca.infodata.ofys.ui.controls.form.MyTable;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.controls.popup.PopupFeature;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class LabTypeNameSearchPopupFeature
extends PopupFeature {
    protected List<String> source;
    private MyTable<String> sourceTable;
    private final Set<String> model;
    private String alias;
    private MyTable<String> modelTable;
    private boolean showAlias;
    private boolean showModelTable;

    public LabTypeNameSearchPopupFeature(Control control, Set<String> model, String alias) {
        super(control);
        this.alias = alias;
        this.showPopupDown = true;
        this.showAlias = true;
        this.showModelTable = true;
        this.model = model;
    }

    protected Shell createPopupControlOverride(Shell parentShell) {
        Shell shell;
        Shell parent = shell = new Shell(parentShell, 4);
        Label searchTip = new Label((Composite)parent, 0x1000040);
        if (this.isShowModelTable()) {
            searchTip.setText("Utiliser 'Enter' ou Double-cliquer pour ajouter et 'Supprimer' pour supprimer");
        } else {
            searchTip.setText("Utiliser 'Enter' ou Double-cliquer pour ajouter");
        }
        this.modelTable = new MyTable((Composite)parent, 68098);
        this.createTableColumns(this.modelTable);
        this.modelTable.setItems(this.model);
        Label separator = new Label((Composite)parent, 258);
        final Text searchText = new Text((Composite)parent, 2048);
        Label lblAlias = new Label((Composite)parent, 16384);
        lblAlias.setText("Alias - Utiliser un alias pour d\u00e9crire votre s\u00e9lection \u00e0 place d'une longue liste de code");
        final Text txtAlias = new Text((Composite)parent, 2052);
        txtAlias.setText(this.alias == null ? "" : this.alias);
        this.sourceTable = new MyTable((Composite)parent, 68098);
        this.createTableColumns(this.sourceTable);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        searchText.setLayoutData((Object)data);
        data = new FormData();
        data = new FormData();
        data.top = new FormAttachment((Control)searchText);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 200;
        this.sourceTable.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sourceTable.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        searchTip.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)searchTip);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        separator.setLayoutData((Object)data);
        if (this.isShowModelTable()) {
            data = new FormData();
            data.top = new FormAttachment((Control)separator);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            data.height = 200;
            this.modelTable.setLayoutData((Object)data);
        }
        this.modelTable.setVisible(this.isShowModelTable());
        data = new FormData();
        data.top = new FormAttachment((Control)(this.isShowModelTable() ? this.modelTable.getControl() : searchTip));
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblAlias.setLayoutData((Object)data);
        lblAlias.setVisible(this.isShowAlias());
        data = new FormData();
        data.top = new FormAttachment((Control)lblAlias);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        txtAlias.setLayoutData((Object)data);
        txtAlias.setVisible(this.isShowAlias());
        txtAlias.addListener(24, (Listener)new SWTDelayedListener(500L, 24){

            public void handleEventOverride(Event e) {
                LabTypeNameSearchPopupFeature.this.alias = txtAlias.getText();
                LabTypeNameSearchPopupFeature.this.modelModified();
            }
        });
        searchText.addListener(24, (Listener)new SWTDelayedListener(500L, 24){

            public void handleEventOverride(Event e) {
                LabTypeNameSearchPopupFeature.this.filterSourceTable(searchText.getText());
            }
        });
        this.sourceTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    List selection = LabTypeNameSearchPopupFeature.this.sourceTable.getSelection();
                    boolean added = false;
                    for (String x : selection) {
                        if (!LabTypeNameSearchPopupFeature.this.model.add(x)) continue;
                        added = true;
                        LabTypeNameSearchPopupFeature.this.modelTable.add((Object)x);
                    }
                    if (added) {
                        UI.autoAdjustColumnWidthToContent((Table)LabTypeNameSearchPopupFeature.this.modelTable.getControl());
                        LabTypeNameSearchPopupFeature.this.modelModified();
                        LabTypeNameSearchPopupFeature.this.added(selection);
                    }
                }
            }
        });
        this.sourceTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                List selection = LabTypeNameSearchPopupFeature.this.sourceTable.getSelection();
                boolean added = false;
                for (String x : selection) {
                    if (!LabTypeNameSearchPopupFeature.this.model.add(x)) continue;
                    added = true;
                    LabTypeNameSearchPopupFeature.this.modelTable.add((Object)x);
                }
                if (added) {
                    UI.autoAdjustColumnWidthToContent((Table)LabTypeNameSearchPopupFeature.this.modelTable.getControl());
                    LabTypeNameSearchPopupFeature.this.modelModified();
                    LabTypeNameSearchPopupFeature.this.added(selection);
                }
            }
        });
        this.modelTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f') {
                    List selection = LabTypeNameSearchPopupFeature.this.modelTable.getSelection();
                    LabTypeNameSearchPopupFeature.this.modelTable.remove((Collection)selection);
                    LabTypeNameSearchPopupFeature.this.model.removeAll(selection);
                    if (LabTypeNameSearchPopupFeature.this.modelTable.getItemCount() > 0) {
                        LabTypeNameSearchPopupFeature.this.modelTable.select(0);
                    }
                    UI.autoAdjustColumnWidthToContent((Table)LabTypeNameSearchPopupFeature.this.modelTable.getControl());
                    LabTypeNameSearchPopupFeature.this.modelModified();
                    LabTypeNameSearchPopupFeature.this.deleted(selection);
                }
            }
        });
        shell.pack();
        shell.setSize(500, shell.getSize().y);
        this.search(parent, this.sourceTable);
        this.setPopupFirstFocusControl((Control)searchText);
        return shell;
    }

    protected void filterSourceTable(String text) {
        this.sourceTable.removeAll();
        text = StringUtils.NormalizeToLowercase((String)text);
        String[] split = text.split(" ");
        for (String e : this.source) {
            if (e == null) continue;
            String e2 = StringUtils.NormalizeToLowercase((String)e);
            boolean contains = true;
            int i = 0;
            while (i < split.length) {
                if (!e2.contains(split[i])) {
                    contains = false;
                    break;
                }
                ++i;
            }
            if (!contains) continue;
            this.sourceTable.add((Object)e);
        }
        UI.autoAdjustColumnWidthToContent((Table)this.sourceTable.getControl());
    }

    private void search(Shell parent, MyTable<String> searchTable) {
        Callback callback = new Callback(){

            public void responseReceived(ReturnObject response) {
                LabTypeNameSearchPopupFeature.this.source = (List)response.getObj();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (LabTypeNameSearchPopupFeature.this.getPopup() != null && !LabTypeNameSearchPopupFeature.this.getPopup().isDisposed()) {
                            LabTypeNameSearchPopupFeature.this.sourceTable.setItems((this).LabTypeNameSearchPopupFeature.this.source);
                            UI.autoAdjustColumnWidthToContent((Table)LabTypeNameSearchPopupFeature.this.sourceTable.getControl());
                        }
                    }
                });
            }
        };
        try {
            EncounterAccessorClient.getInstance().findLabTypeNames(Application.get().getGlobalInstances().getSession(), callback);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
        }
        catch (Exception exception) {
            callback.kill();
        }
    }

    protected void createTableColumns(MyTable<String> table) {
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        final ArrayList<7> tableColumns = new ArrayList<7>();
        SearchColumn<String> sc = new SearchColumn<String>(table.getControl(), "Nom"){

            public String getText(String e) {
                return e;
            }
        };
        sc.getColumn().setData("minWidth", (Object)150);
        tableColumns.add(sc);
        table.setLabelProvider((ProviderAR)new ProviderAR<String, String[]>(){

            public String[] get(String e) {
                int size = tableColumns.size();
                String[] s = new String[size];
                int i = 0;
                while (i < size) {
                    s[i] = ((SearchColumn)tableColumns.get(i)).getText((Object)e);
                    ++i;
                }
                return s;
            }
        });
        UI.autoAdjustColumnWidthToContent((Table)table.getControl());
    }

    public Set<String> getModel() {
        return this.model;
    }

    protected void modelModified() {
    }

    protected void deleted(List<String> selection) {
    }

    protected void added(List<String> selection) {
    }

    public String getAlias() {
        return this.alias;
    }

    protected void refreshPopup() {
    }

    public boolean isShowAlias() {
        return this.showAlias;
    }

    public void setShowAlias(boolean showAlias) {
        this.showAlias = showAlias;
    }

    public boolean isShowModelTable() {
        return this.showModelTable;
    }

    public void setShowModelTable(boolean showModelTable) {
        this.showModelTable = showModelTable;
    }
}

