/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.print.page;

import java.util.Locale;
import org.nightlabs.i18n.I18nText;
import org.nightlabs.i18n.I18nTextBuffer;
import org.nightlabs.i18n.unit.IUnit;
import org.nightlabs.i18n.unit.MMUnit;
import org.nightlabs.print.page.IPredefinedPage;
import org.nightlabs.util.Utils;

public class PredefinedPage
implements IPredefinedPage {
    protected String pageID = "A4";
    protected I18nTextBuffer i18nText = new I18nTextBuffer();
    protected IUnit unit = new MMUnit();
    protected double pageWidth = 210.0;
    protected double pageHeight = 297.0;

    protected PredefinedPage() {
    }

    public PredefinedPage(String pageID, String name, double width, double height, IUnit unit) {
        this.pageID = pageID;
        this.i18nText.setText(Locale.getDefault().getLanguage(), name);
        this.pageWidth = width;
        this.pageHeight = height;
        this.unit = unit;
    }

    @Override
    public String getPageID() {
        return this.pageID;
    }

    @Override
    public I18nText getName() {
        return this.i18nText;
    }

    @Override
    public IUnit getUnit() {
        return this.unit;
    }

    @Override
    public double getPageWidth() {
        return this.pageWidth;
    }

    @Override
    public double getPageHeight() {
        return this.pageHeight;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IPredefinedPage)) {
            return false;
        }
        IPredefinedPage page = (IPredefinedPage)obj;
        return page.getPageID().equals(this.getPageID());
    }

    @Override
    public int hashCode() {
        return Utils.hashCode(this.pageID);
    }
}

