/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.print;

import java.awt.print.PageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;

public class PrinterConfiguration {
    private boolean alwaysAsk;
    private String printServiceName;
    private PageFormat pageFormat;
    private PrintRequestAttributeSet printRequestAttributeSet;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public String getPrintServiceName() {
        return this.printServiceName;
    }

    public void setPrintServiceName(String printServiceName) {
        this.printServiceName = printServiceName;
    }

    public boolean isAlwaysAsk() {
        return this.alwaysAsk;
    }

    public void setAlwaysAsk(boolean alwaysAsk) {
        this.alwaysAsk = alwaysAsk;
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.printRequestAttributeSet;
    }

    public void setPrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        this.printRequestAttributeSet = printRequestAttributeSet;
    }

    public Object clone() {
        PrinterConfiguration clone = new PrinterConfiguration();
        clone.setAlwaysAsk(this.isAlwaysAsk());
        clone.setPrintServiceName(this.getPrintServiceName());
        if (this.getPageFormat() != null) {
            clone.setPageFormat((PageFormat)this.getPageFormat().clone());
        }
        if (this.printRequestAttributeSet != null) {
            clone.setPrintRequestAttributeSet(new HashPrintRequestAttributeSet(this.printRequestAttributeSet));
        }
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            clone.getAttributes().put(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    public String toString() {
        return "Printer configuration (Printer: " + this.printServiceName + ", alwaysAsk " + this.alwaysAsk + ")";
    }
}

