/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.print;

import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.nightlabs.print.PrinterConfiguration;
import org.nightlabs.print.PrinterInterface;

public class PrintUtil {
    public static PrinterInterface getDocumentPrinterInterface(String printerUseCaseID) {
        return null;
    }

    public boolean assignPrinterJobToService(PrinterJob printerJob, boolean useDefault) {
        if (useDefault) {
            PrintService defService = PrintServiceLookup.lookupDefaultPrintService();
            if (defService != null) {
                try {
                    printerJob.setPrintService(defService);
                }
                catch (PrinterException printerException) {
                    return false;
                }
                return true;
            }
            return printerJob.printDialog();
        }
        return printerJob.printDialog();
    }

    public static PrintService lookupPrintService(String name) {
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        int i = 0;
        while (i < services.length) {
            if (services[i].getName().equals(name)) {
                return services[i];
            }
            ++i;
        }
        return null;
    }

    public static List<PrintService> lookupPrintServices() {
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        ArrayList<PrintService> result = new ArrayList<PrintService>();
        int i = 0;
        while (i < services.length) {
            result.add(services[i]);
            ++i;
        }
        return result;
    }

    public static PrintService getConfiguredPrintService(PrinterConfiguration printerConfiguration, boolean throwExceptionIfNotFound) throws PrinterException {
        PrintService printService = null;
        if (printerConfiguration != null && printerConfiguration.getPrintServiceName() != null) {
            printService = PrintUtil.lookupPrintService(printerConfiguration.getPrintServiceName());
        }
        if (printService == null) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
        }
        if (printService == null && throwExceptionIfNotFound) {
            throw new PrinterException("Could not find a configured or default print service");
        }
        return printService;
    }

    public static PageFormat getDefaultPageFormat(PrintService printService) throws PrinterException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(printService);
        return printerJob.defaultPage();
    }
}

