/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.print;

import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import org.apache.log4j.Logger;
import org.nightlabs.print.DelegatingDocumentPrinterCfMod;
import org.nightlabs.print.DocumentPrinter;
import org.nightlabs.print.DocumentPrinterDelegateConfig;
import org.nightlabs.print.PrintUtil;
import org.nightlabs.print.PrinterConfiguration;
import org.nightlabs.print.PrinterInterface;
import org.nightlabs.print.PrinterInterfaceFactory;
import org.nightlabs.util.ObservedProcess;
import org.nightlabs.util.Utils;

public class DelegatingDocumentPrinter
implements DocumentPrinter {
    private static Logger logger = Logger.getLogger(DelegatingDocumentPrinter.class);
    private static String VAR_NAME_PRINT_SERVICE = "PRINTSERVICE";
    private static String VAR_NAME_FILE = "FILE";
    private boolean waitForProcess = false;
    private boolean failOnInterruption = false;
    private boolean failOnError = true;
    private String printServiceName;
    private PrinterConfiguration configuration;

    @Override
    public void configure(PrinterConfiguration printerConfiguration) {
        logger.debug((Object)("Configuring DelegatingDocumentPrinter with " + printerConfiguration));
        if (printerConfiguration != null) {
            this.printServiceName = printerConfiguration.getPrintServiceName();
            this.configuration = (PrinterConfiguration)printerConfiguration.clone();
        }
        if (this.printServiceName == null) {
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            if (printService == null) {
                throw new IllegalStateException("No PrintService configured and no system default PrintService could be found.");
            }
            this.printServiceName = printService.getName();
        }
    }

    protected void printDocumentDelegated(File document, DocumentPrinterDelegateConfig printConfig) throws PrinterException {
        if (printConfig instanceof DelegatingDocumentPrinterCfMod.SystemCallDelegateConfig) {
            this.printDocumentSystemCall(document, (DelegatingDocumentPrinterCfMod.SystemCallDelegateConfig)printConfig);
        } else if (printConfig instanceof DelegatingDocumentPrinterCfMod.ExternalEngineDelegateConfig) {
            this.printDocumentExternalEngine(document, (DelegatingDocumentPrinterCfMod.ExternalEngineDelegateConfig)printConfig);
        } else {
            throw new IllegalArgumentException("The DocumentPrinterDelegateConfig of type " + printConfig.getClass().getName() + " is not supported.");
        }
    }

    protected void printDocumentExternalEngine(File document, DelegatingDocumentPrinterCfMod.ExternalEngineDelegateConfig printConfig) throws PrinterException {
        DocumentPrinter externalEngine;
        Class<?> clazz;
        logger.debug((Object)("Printing file " + document + " by external engine " + printConfig.getClassName()));
        if (printConfig == null) {
            return;
        }
        try {
            clazz = Class.forName(printConfig.getClassName());
        }
        catch (ClassNotFoundException e) {
            PrinterException ex = new PrinterException("Could not find class for the configured external print engine: " + printConfig.getClassName());
            ex.initCause(e);
            throw ex;
        }
        if (!DocumentPrinter.class.isAssignableFrom(clazz)) {
            throw new PrinterException("Can not use external print engine, it does not implement DocumentPrinter. ClassName is " + printConfig.getClassName());
        }
        try {
            externalEngine = (DocumentPrinter)clazz.newInstance();
        }
        catch (Exception e) {
            PrinterException ex = new PrinterException("Could not instantiate external print engine: " + printConfig.getClassName());
            ex.initCause(e);
            throw ex;
        }
        logger.debug((Object)"Instantiated external engine, now configre it.");
        externalEngine.configure(this.configuration);
        logger.debug((Object)"Configure successfull, now printing via external engine.");
        externalEngine.printDocument(document);
    }

    protected void printDocumentSystemCall(File document, DelegatingDocumentPrinterCfMod.SystemCallDelegateConfig printConfig) throws PrinterException {
        ObservedProcess observedProcess;
        logger.debug((Object)"Printing by system call");
        String[] params = printConfig.getParameterPattern().split("\\s");
        int i = 0;
        while (i < params.length) {
            if (printConfig != null) {
                params[i] = params[i].replace("${" + VAR_NAME_PRINT_SERVICE + "}", this.printServiceName);
            }
            params[i] = params[i].replace("${" + VAR_NAME_FILE + "}", document.getAbsolutePath());
            ++i;
        }
        String[] allCmds = new String[params.length + 1];
        allCmds[0] = printConfig.getCommandPattern();
        int i2 = 1;
        while (i2 < allCmds.length) {
            allCmds[i2] = params[i2 - 1];
            ++i2;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"All system call params are:");
            i2 = 0;
            while (i2 < allCmds.length) {
                logger.debug((Object)("  " + allCmds[i2]));
                ++i2;
            }
        }
        try {
            observedProcess = new ObservedProcess(Runtime.getRuntime().exec(allCmds));
        }
        catch (IOException e) {
            PrinterException ex = new PrinterException("Could not invoke external print command.");
            ex.initCause(e);
            throw ex;
        }
        logger.debug((Object)"Created system call process, waiting for it to terminate");
        StringWriter err = null;
        if (this.failOnError) {
            err = new StringWriter();
        }
        StringWriter out = new StringWriter();
        int exitVal = 0;
        try {
            exitVal = observedProcess.waitForProcess(out, err);
        }
        catch (InterruptedException e) {
            if (this.failOnInterruption) {
                throw new RuntimeException(e);
            }
            logger.warn((Object)"Interrupted waiting for print process", (Throwable)e);
        }
        if (exitVal != printConfig.getExpectedReturnValue() && this.failOnError) {
            throw new RuntimeException("Print command failed (exit " + exitVal + ") with \n" + "Error Message: \n" + (err != null ? err.getBuffer().toString() : "null") + "\nOutput: \n" + (out != null ? out.getBuffer().toString() : "null"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Wait ended, output buffers are:");
            logger.debug((Object)("  Err: " + err.getBuffer().toString()));
            logger.debug((Object)("  Out: " + out.getBuffer().toString()));
        }
    }

    protected void printDocumentJavaAPI(File file) throws PrinterException {
        FileInputStream fis;
        logger.debug((Object)"Printing by Java AUTOSENSE API.");
        PrintService printService = null;
        if (this.configuration != null && this.configuration.getPrintServiceName() != null) {
            printService = PrintUtil.lookupPrintService(this.configuration.getPrintServiceName());
        }
        if (printService == null) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
        }
        if (printService == null) {
            throw new PrinterException("Printing with Java API, but no print-service could be found or assigned.");
        }
        DocPrintJob printJob = printService.createPrintJob();
        logger.debug((Object)"Created DocPrintJob");
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            PrinterException ex = new PrinterException("Could not create FileInputStream");
            ex.initCause(e);
            throw ex;
        }
        SimpleDoc doc = new SimpleDoc(fis, DocFlavor.INPUT_STREAM.AUTOSENSE, new HashDocAttributeSet());
        logger.debug((Object)"Created SimpleDoc");
        try {
            printJob.print(doc, null);
        }
        catch (PrintException e) {
            PrinterException ex = new PrinterException("Java API DocPrintJob failed");
            ex.initCause(e);
            throw ex;
        }
        logger.debug((Object)"Printed");
    }

    public String getPrintServiceName() {
        return this.printServiceName;
    }

    public void setPrintServiceName(String printServiceName) {
        this.printServiceName = printServiceName;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isFailOnInterruption() {
        return this.failOnInterruption;
    }

    public void setFailOnInterruption(boolean failOnInterruption) {
        this.failOnInterruption = failOnInterruption;
    }

    public boolean isWaitForProcess() {
        return this.waitForProcess;
    }

    public void setWaitForProcess(boolean waitForProcess) {
        this.waitForProcess = waitForProcess;
    }

    @Override
    public PrinterConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void printDocument(File file) throws PrinterException {
        String fileExt = Utils.getFileExtension(file.getName());
        DelegatingDocumentPrinterCfMod cfMod = DelegatingDocumentPrinterCfMod.sharedInstance();
        DocumentPrinterDelegateConfig printConfig = null;
        if (cfMod != null) {
            printConfig = cfMod.getPrintConfig(fileExt);
        }
        if (printConfig != null) {
            logger.debug((Object)"Found printConfig printing delegated");
            this.printDocumentDelegated(file, printConfig);
        } else {
            logger.debug((Object)"No printConfig found try to print with Java Document-Print API.");
            this.printDocumentJavaAPI(file);
        }
    }

    public static void main(String[] args) {
        DelegatingDocumentPrinter printer = new DelegatingDocumentPrinter();
        try {
            printer.printDocument(new File("C:\\Temp\\landscape.pdf"));
        }
        catch (PrinterException e) {
            e.printStackTrace();
        }
    }

    public static class Factory
    implements PrinterInterfaceFactory {
        @Override
        public PrinterInterface createPrinterInterface() {
            return new DelegatingDocumentPrinter();
        }
    }
}

