/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.i18n.unit.resolution;

import org.nightlabs.i18n.unit.resolution.DPIResolutionUnit;
import org.nightlabs.i18n.unit.resolution.IResolutionUnit;
import org.nightlabs.i18n.unit.resolution.Resolution;

public class ResolutionImpl
implements Resolution {
    private IResolutionUnit resolutionUnit = new DPIResolutionUnit();
    private double resolutionX = 762.0;
    private double resolutionY = 762.0;

    public ResolutionImpl(IResolutionUnit unit, double resolutionX, double resolutionY) {
        this.resolutionUnit = unit;
        this.resolutionX = resolutionX;
        this.resolutionY = resolutionY;
    }

    public ResolutionImpl(IResolutionUnit unit, double resolution) {
        this.resolutionUnit = unit;
        this.resolutionX = resolution;
        this.resolutionY = resolution;
    }

    public ResolutionImpl() {
        this.resolutionUnit = new DPIResolutionUnit();
        this.resolutionX = 762.0;
        this.resolutionY = 762.0;
    }

    @Override
    public IResolutionUnit getResolutionUnit() {
        return this.resolutionUnit;
    }

    @Override
    public double getResolutionX() {
        return this.resolutionX;
    }

    @Override
    public void setResolutionX(double value) {
        this.resolutionX = value;
    }

    @Override
    public double getResolutionY() {
        return this.resolutionY;
    }

    @Override
    public void setResolutionY(double value) {
        this.resolutionY = value;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("How the hell can clone fail?!", e);
        }
    }

    @Override
    public double getResolutionX(IResolutionUnit unit) {
        if (unit.equals(this.resolutionUnit)) {
            return this.getResolutionX();
        }
        double oldfactor = this.resolutionUnit.getUnit().getFactor();
        return this.resolutionX * unit.getUnit().getFactor() / oldfactor;
    }

    @Override
    public double getResolutionY(IResolutionUnit unit) {
        if (unit.equals(this.resolutionUnit)) {
            return this.getResolutionY();
        }
        double oldfactor = this.resolutionUnit.getUnit().getFactor();
        return this.resolutionY * unit.getUnit().getFactor() / oldfactor;
    }

    @Override
    public void setResolutionUnit(IResolutionUnit unit) {
        if (unit.getUnit().getFactor() != this.resolutionUnit.getUnit().getFactor()) {
            double oldfactor = this.resolutionUnit.getUnit().getFactor();
            this.resolutionX = this.resolutionX * unit.getUnit().getFactor() / oldfactor;
            this.resolutionY = this.resolutionY * unit.getUnit().getFactor() / oldfactor;
        }
        this.resolutionUnit = unit;
    }
}

