/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.eclipse.ui.pdfviewer.internal;

import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BufferedImagePool {
    private List<BufferedImageCarrier> pool = new LinkedList<BufferedImageCarrier>();

    public synchronized BufferedImage acquire(int width, int height) {
        BufferedImage result = null;
        Iterator<BufferedImageCarrier> it = this.pool.iterator();
        while (it.hasNext()) {
            BufferedImageCarrier carrier = it.next();
            if (carrier.acquired) continue;
            if (carrier.bufferedImage.getWidth() == width && carrier.bufferedImage.getHeight() == height) {
                if (result != null) continue;
                result = carrier.bufferedImage;
                carrier.acquired = true;
                continue;
            }
            carrier.bufferedImage.flush();
            it.remove();
        }
        if (result == null) {
            result = new BufferedImage(width, height, 2);
            BufferedImageCarrier carrier = new BufferedImageCarrier();
            carrier.bufferedImage = result;
            carrier.acquired = true;
            this.pool.add(carrier);
        }
        return result;
    }

    public synchronized void release(BufferedImage bufferedImage) {
        for (BufferedImageCarrier carrier : this.pool) {
            if (carrier.bufferedImage != bufferedImage) continue;
            if (!carrier.acquired) {
                throw new IllegalArgumentException("This BufferedImage is known to this pool, but not acquired! " + bufferedImage);
            }
            carrier.acquired = false;
            return;
        }
        throw new IllegalArgumentException("This BufferedImage is not know to this pool! " + bufferedImage);
    }

    private static class BufferedImageCarrier {
        public boolean acquired;
        public BufferedImage bufferedImage;

        private BufferedImageCarrier() {
        }
    }
}

