/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.eclipse.ui.pdfviewer.internal;

import java.awt.Image;
import java.awt.image.ImageObserver;
import org.nightlabs.eclipse.ui.pdfviewer.internal.WaitForRenderingException;

class BlockingImageObserver
implements ImageObserver {
    private boolean renderingFinished = false;
    private boolean renderingAborted = false;
    private int lastInfoflags = 0;
    private static final long timeoutMSec = 60000L;

    @Override
    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        this.lastInfoflags = infoflags;
        if ((infoflags & 0x20) != 0) {
            this.renderingFinished = true;
        }
        if ((infoflags & 0x80) != 0) {
            this.renderingAborted = true;
        }
        this.notifyAll();
        return !this.renderingFinished;
    }

    public synchronized void waitForRendering() {
        long start = System.currentTimeMillis();
        while (!this.renderingFinished && !this.renderingAborted) {
            if (System.currentTimeMillis() - start > 60000L) {
                throw new WaitForRenderingException("Timeout waiting for rendering to finish or abort!");
            }
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.renderingAborted) {
            throw new WaitForRenderingException("Rendering was aborted! lastInfoflags=" + this.lastInfoflags);
        }
    }
}

