/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.pdf;

import ca.infodata.ofys.ui.pdf.PdfPlugin;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.file.FileUtil;
import com.sun.pdfview.PDFFile;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.nightlabs.eclipse.ui.pdfviewer.PdfFileLoader;
import org.osgi.framework.Bundle;

public class SumatraPrintPdf {
    private static final Logger logger = Logger.getLogger(SumatraPrintPdf.class.getName());
    private String printerName;
    private File documentPdf;
    private int nbCopies;

    public void print() throws PrinterException {
        if (SystemUtils.IS_OS_WINDOWS) {
            File sumatraExeFile = null;
            try {
                sumatraExeFile = this.copySumatraPDFToUserDir();
                String[] buildCommand2 = this.buildCommand2(sumatraExeFile);
                Runtime.getRuntime().exec(buildCommand2, null, null);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "sumatraExeFile " + sumatraExeFile, e);
                throw new PrinterException(String.valueOf(e.getClass().getName()) + " - " + e.getMessage());
            }
        } else {
            throw new PrinterException("print with sumatra pdf is only supported on windows system");
        }
    }

    private File copySumatraPDFToUserDir() throws Exception {
        File installPath = new File(Platform.getLocation().toString()).getParentFile();
        File out = new File(installPath, "SumatraPDF.exe");
        if (!out.exists()) {
            Bundle bundle = PdfPlugin.getDefault().getBundle();
            Path path = new Path("SumatraPDF.exe");
            URL url = FileLocator.find((Bundle)bundle, (IPath)path, (Map)Collections.EMPTY_MAP);
            URL fileURL = FileLocator.toFileURL((URL)url);
            String fixedUrl = fileURL.toString().replaceAll(" ", "%20");
            File in = new File(URI.create(fixedUrl));
            FileUtil.copyFile((File)in, (File)out);
        }
        return out;
    }

    protected String buildCommand(File sumatraExeFile) throws IOException {
        String command = "";
        command = String.valueOf(command) + "\"" + sumatraExeFile.toString() + "\" ";
        command = String.valueOf(command) + " -print-to \"" + this.printerName + "\" ";
        if (this.nbCopies > 1) {
            PDFFile pdfFile = PdfFileLoader.loadPdf(this.documentPdf, (IProgressMonitor)new NullProgressMonitor());
            int numPages = pdfFile.getNumPages();
            command = String.valueOf(command) + " -print-settings \"";
            JoinList list = new JoinList(";");
            int i = 0;
            while (i < this.nbCopies) {
                list.add((CharSequence)("1-" + numPages));
                ++i;
            }
            command = String.valueOf(command) + list.toString() + "\" ";
        }
        command = String.valueOf(command) + " \"" + this.documentPdf.getAbsolutePath() + "\"";
        return command;
    }

    protected String[] buildCommand2(File sumatraExeFile) throws IOException {
        String command = "";
        command = String.valueOf(command) + sumatraExeFile.toString() + "|";
        command = String.valueOf(command) + "-print-to|" + this.printerName + "|";
        if (this.nbCopies > 1) {
            PDFFile pdfFile = PdfFileLoader.loadPdf(this.documentPdf, (IProgressMonitor)new NullProgressMonitor());
            int numPages = pdfFile.getNumPages();
            command = String.valueOf(command) + "-print-settings|";
            JoinList list = new JoinList(";");
            int i = 0;
            while (i < this.nbCopies) {
                list.add((CharSequence)("1-" + numPages));
                ++i;
            }
            command = String.valueOf(command) + list.toString() + "|";
        }
        command = String.valueOf(command) + this.documentPdf.getAbsolutePath();
        return command.split("\\|");
    }

    public String getPrinterName() {
        return this.printerName;
    }

    public void setPrinterName(String printerName) {
        this.printerName = printerName;
    }

    public File getDocumentPdf() {
        return this.documentPdf;
    }

    public void setDocumentPdf(File documentPdf) {
        this.documentPdf = documentPdf;
    }

    public int getNbCopies() {
        return this.nbCopies;
    }

    public void setNbCopies(int nbCopies) {
        this.nbCopies = nbCopies;
    }
}

