/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.printer;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.library.printer.IPrinterList;
import java.awt.print.PrinterException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class PrinterList
implements IPrinterList {
    private static final Logger logger = Logger.getLogger(PrinterList.class.getName());
    private final Object lock = new Object();
    private volatile boolean loadingPrinterList;
    private String[] printersCache = null;

    @Override
    public synchronized void loadPrinterListAsync() {
        if (!this.loadingPrinterList) {
            this.loadPrinterList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPrinterList() {
        Object object = this.lock;
        synchronized (object) {
            logger.info("loading printer list");
            this.loadingPrinterList = true;
            try {
                PrinterData[] printerList = Printer.getPrinterList();
                Object[] list = new String[printerList.length];
                int i = 0;
                while (i < printerList.length) {
                    list[i] = printerList[i].name;
                    ++i;
                }
                Arrays.sort(list);
                this.printersCache = list;
            }
            finally {
                this.loadingPrinterList = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPrinters() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.printersCache != null) break block4;
                return null;
            }
            return Arrays.copyOf(this.printersCache, this.printersCache.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultPrinter() {
        Object object = this.lock;
        synchronized (object) {
            String def = null;
            PrinterData data = Printer.getDefaultPrinterData();
            if (data == null) {
                String[] printers = this.getPrinters();
                if (printers != null && printers.length > 0) {
                    def = printers[0];
                }
            } else {
                def = data.name.replace("_", " ");
            }
            return def;
        }
    }

    @Override
    public PrintService getPrintService(String name) throws PrinterException {
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
        int i = 0;
        while (i < printServices.length) {
            if (printServices[i].getName().equalsIgnoreCase(name)) {
                return printServices[i];
            }
            ++i;
        }
        throw new PrinterException(String.valueOf(Messages.getString((String)"PrintPdf.INVALID_PRINT_SERVICE_NAME", (String[])new String[0])) + ": " + name);
    }
}

