/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.file;

import ca.infodata.ofys.ui.library.LibPlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.program.Program;
import org.osgi.framework.Bundle;

public final class FileUtil {
    private static final Logger logger = Logger.getLogger(FileUtil.class.getName());
    public static final String TEMP_FOLDER = String.valueOf(LibPlugin.OFYS_HOME) + "temp/";

    private FileUtil() {
        throw new UnsupportedOperationException();
    }

    public static void copyFileRecursive(File in, File out) throws IOException {
        if (in.isDirectory() && out.exists() && !out.isDirectory()) {
            throw new IllegalArgumentException("in " + in + " is a directory and out " + out + " is not");
        }
        if (!in.isDirectory() && out.isDirectory()) {
            throw new IllegalArgumentException("out " + out + " is a directory and in " + in + " is not");
        }
        if (in.isDirectory()) {
            if (!out.exists()) {
                out.mkdir();
            }
            File[] fileArray = in.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File fin = fileArray[n2];
                File fout = new File(out, fin.getName());
                FileUtil.copyFileRecursive(fin, fout);
                ++n2;
            }
        } else {
            if (!out.exists()) {
                out.createNewFile();
            }
            FileUtil.copyFile(in, out);
        }
    }

    public static void copyFile(File in, File out) throws IOException {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        FileChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            inStream = new FileInputStream(in);
            inChannel = inStream.getChannel();
            outStream = new FileOutputStream(out);
            outChannel = outStream.getChannel();
            inChannel.transferTo(0L, inChannel.size(), (WritableByteChannel)((Object)outChannel));
        }
        catch (Throwable throwable) {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (inChannel != null) {
                    inChannel.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (inStream != null) {
                inStream.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (inChannel != null) {
                inChannel.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (outStream != null) {
                outStream.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (outChannel != null) {
                outChannel.close();
            }
        }
        catch (Exception exception) {}
    }

    public static String getFileExtension(File file) {
        String extension = "";
        String fileName = file == null ? "" : (file.getName() != null ? file.getName() : "");
        int dotI = fileName.lastIndexOf(".");
        if (dotI > -1 && dotI < fileName.length() - 1) {
            extension = fileName.substring(dotI + 1);
        }
        return extension;
    }

    public static boolean isFileExtensionIs(File file, String extension) {
        return FileUtil.getFileExtension(file).equals(extension);
    }

    public static String fileToStr(String s) {
        StringBuilder buf = new StringBuilder();
        Reader in = null;
        try {
            in = new FileReader(s);
            int i = in.read();
            while (i > -1) {
                char c = (char)i;
                buf.append(c);
                i = in.read();
            }
            in.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.SEVERE, "File not found " + s);
            try {
                in.close();
            }
            catch (Exception exception) {}
            return null;
        }
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception exception) {}
            return null;
        }
        try {
            in.close();
        }
        catch (Exception exception) {}
        return buf.toString();
    }

    public static String getFileNameWithExtension(File file, String newExtension) {
        String newName = "";
        if (file != null) {
            String ext = FileUtil.getFileExtension(file);
            String fname = file.getName();
            newName = String.valueOf(fname.substring(0, fname.length() - ext.length() - (ext.length() > 0 ? 1 : 0))) + "." + newExtension;
        }
        return newName;
    }

    public static boolean strToFile(String f, String s) {
        FileWriter out = null;
        try {
            try {
                out = new FileWriter(f);
                ((Writer)out).write(s, 0, s.length());
                ((Writer)out).flush();
            }
            catch (IOException iOException) {
                if (out != null) {
                    try {
                        ((Writer)out).close();
                    }
                    catch (IOException iOException2) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    ((Writer)out).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                ((Writer)out).close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static File saveToTemp(String fileName, InputStream is) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (is == null) {
            throw new NullPointerException("is");
        }
        return FileUtil.saveToFileRelativeFromHome("temp/" + fileName, is);
    }

    public static File saveToTemp(String fileName, byte[] fileContents) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        return FileUtil.saveToFileRelativeFromHome("temp/" + fileName, fileContents);
    }

    public static File saveToTemp(String fileName, String fileContents) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        return FileUtil.saveToFileRelativeFromHome("temp/" + fileName, fileContents);
    }

    public static String loadFromTemp(String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        return FileUtil.loadFromFileRelativeFromHome("temp/" + fileName);
    }

    public static File saveToFileRelativeFromHome(String relativeFilePath, InputStream is) {
        File file;
        if (is == null) {
            throw new NullPointerException("is");
        }
        if (relativeFilePath == null) {
            throw new NullPointerException("relativeFilePath");
        }
        FileOutputStream out = null;
        try {
            try {
                int len;
                file = new File(LibPlugin.OFYS_HOME, relativeFilePath);
                FileUtils.forceMkdir((File)new File(file.getParent()));
                file.createNewFile();
                out = new FileOutputStream(file);
                byte[] buf = new byte[1000];
                while ((len = is.read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
                out.flush();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "relativeFilePath=" + relativeFilePath, e);
                try {
                    is.close();
                }
                catch (IOException e2) {
                    logger.log(Level.WARNING, "Failed to close inputStream " + relativeFilePath, e2);
                }
                try {
                    out.close();
                }
                catch (IOException e3) {
                    logger.log(Level.WARNING, "Failed to close outputStream " + relativeFilePath, e3);
                }
                return null;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to close inputStream " + relativeFilePath, e);
            }
            try {
                out.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to close outputStream " + relativeFilePath, e);
            }
        }
        return file;
    }

    public static File saveToFileRelativeFromHome(String relativeFilePath, byte[] fileContents) {
        if (relativeFilePath == null) {
            throw new NullPointerException("relativeFilePath");
        }
        if (fileContents == null) {
            fileContents = new byte[]{};
        }
        File file = null;
        try {
            file = new File(String.valueOf(LibPlugin.OFYS_HOME) + relativeFilePath);
            FileUtils.writeByteArrayToFile((File)file, (byte[])fileContents);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "relativeFilePath=" + relativeFilePath, e);
        }
        return file;
    }

    public static File saveToFileRelativeFromHome(String relativeFilePath, String fileContents) {
        File file;
        block16: {
            if (relativeFilePath == null) {
                throw new NullPointerException("relativeFilePath");
            }
            if (fileContents == null) {
                fileContents = "";
            }
            file = null;
            FileWriterWithEncoding out = null;
            try {
                try {
                    file = new File(LibPlugin.OFYS_HOME, relativeFilePath);
                    FileUtils.forceMkdir((File)new File(file.getParent()));
                    file.delete();
                    file.createNewFile();
                    out = new FileWriterWithEncoding(file, Charset.forName("UTF-8"));
                    out.write(fileContents);
                    out.flush();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "relativeFilePath=" + relativeFilePath, e);
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    public static String loadFromFileRelativeFromHome(String relativeFilePath) {
        if (relativeFilePath == null) {
            throw new NullPointerException("relativeFilePath");
        }
        File file = new File(LibPlugin.OFYS_HOME, relativeFilePath);
        return FileUtil.fileToStr(file.getAbsolutePath());
    }

    public static String[] unzipToFileRelativeFromHome(byte[] theZipBytes, String relativeParentFolderPath) {
        if (relativeParentFolderPath == null) {
            throw new NullPointerException("relativeParentFolderPath");
        }
        File file = new File(LibPlugin.OFYS_HOME, relativeParentFolderPath);
        return FileUtil.unzip(theZipBytes, file.getAbsolutePath());
    }

    public static void showPDFWithExternalViewer(byte[] document) {
        File file = FileUtil.writePDFOnDisk(document);
        if (file != null) {
            Program.launch((String)file.getAbsolutePath());
            try {
                TimeUnit.MILLISECONDS.sleep(300L);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "", e);
            }
        }
    }

    public static File writePDFOnDisk(byte[] document) {
        String fileName = "report" + System.currentTimeMillis() + ".pdf";
        fileName = "/temp/pdf/" + fileName;
        logger.info("Writing " + fileName);
        File file = FileUtil.saveToFileRelativeFromHome(fileName, document);
        if (file == null) {
            logger.log(Level.SEVERE, "FileUtil.saveToFileRelativeFromHome returned file null", new Exception("File name = " + fileName));
        }
        return file;
    }

    public static String[] unzip(byte[] theZipBytes, String destination) {
        return FileUtil.unzip(new ByteArrayInputStream(theZipBytes), destination);
    }

    public static String[] unzip(InputStream inputStream, String destination) {
        ArrayList<String> lstNames;
        block28: {
            ZipInputStream zip = null;
            lstNames = new ArrayList<String>();
            try {
                try {
                    ZipEntry item;
                    zip = new ZipInputStream(inputStream);
                    FileOutputStream outputStream = null;
                    while ((item = zip.getNextEntry()) != null) {
                        try {
                            try {
                                if (item.isDirectory()) {
                                    File newdir = new File(destination, item.getName());
                                    newdir.mkdirs();
                                } else {
                                    int theByte;
                                    File file;
                                    String toAdd = "";
                                    if (item.getName().indexOf("/") > -1) {
                                        toAdd = item.getName().substring(0, item.getName().lastIndexOf("/"));
                                    }
                                    if (!(file = new File(destination, toAdd)).exists()) {
                                        file.mkdirs();
                                    }
                                    outputStream = new FileOutputStream(new File(destination, item.getName()));
                                    while ((theByte = zip.read()) > -1) {
                                        outputStream.write(theByte);
                                    }
                                    lstNames.add(item.getName());
                                    outputStream.flush();
                                }
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Exception on unzip(" + inputStream + ", " + destination + ")", e);
                                try {
                                    outputStream.close();
                                }
                                catch (IOException iOException) {}
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "erreur", e);
                    try {
                        inputStream.close();
                        zip.close();
                    }
                    catch (IOException iOException) {}
                    break block28;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    zip.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
                zip.close();
            }
            catch (IOException iOException) {}
        }
        String[] names = new String[lstNames.size()];
        lstNames.toArray(names);
        return names;
    }

    public static String[] unzip(String zipFile, String destination) {
        String[] names = new String[]{};
        try {
            names = FileUtil.unzip(new FileInputStream(zipFile), destination);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "erreur", e);
        }
        return names;
    }

    public static void deleteTempFolder() {
        File folderTemp = new File(TEMP_FOLDER);
        if (folderTemp.exists()) {
            logger.info("Deleting " + folderTemp.getPath());
            FileUtil.deleteFile(folderTemp);
        }
    }

    public static void deleteSingleFile(File file) {
        try {
            boolean deleteQuietly = FileDeleteStrategy.FORCE.deleteQuietly(file);
            if (!deleteQuietly) {
                logger.log(Level.WARNING, "File not deleted " + file);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error on deleting file " + file, e);
        }
    }

    public static void deleteFile(File file) {
        File[] lstFile = file.listFiles();
        if (lstFile != null) {
            int i = 0;
            while (i < lstFile.length) {
                if (lstFile[i].isDirectory()) {
                    FileUtil.deleteFile(lstFile[i]);
                } else {
                    lstFile[i].delete();
                }
                ++i;
            }
        }
        file.delete();
    }

    public static String getLocation(Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin");
        }
        Bundle bundle = plugin.getBundle();
        String location = "";
        try {
            URL locationUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("/"), null);
            URL fileUrl = FileLocator.toFileURL((URL)locationUrl);
            location = fileUrl.getFile();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error on getting location", e);
        }
        return location;
    }

    public static boolean renameFile(String from, String to) {
        boolean b = false;
        File f = new File(from);
        if (!f.exists()) {
            return b;
        }
        File ft = new File(to);
        if (ft.exists()) {
            b = ft.delete();
        }
        if (b) {
            b = f.renameTo(ft);
        }
        return b;
    }

    public static boolean renameFile(File f, File ft) {
        boolean b = false;
        if (!f.exists()) {
            return b;
        }
        b = ft.exists() ? ft.delete() : true;
        if (b) {
            b = f.renameTo(ft);
        }
        return b;
    }

    public static boolean launchFromTemp(String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        File file = new File(TEMP_FOLDER, fileName);
        return Program.launch((String)file.getAbsolutePath());
    }

    public static byte[] readFileAsByteArray(File file) throws IOException {
        byte[] result;
        try (FileInputStream fileInputStream = null;){
            int b;
            fileInputStream = new FileInputStream(file);
            ArrayList<byte[]> buffers = new ArrayList<byte[]>();
            byte[] buf = new byte[1000];
            while ((b = fileInputStream.read(buf)) != -1) {
                buffers.add(Arrays.copyOf(buf, b));
            }
            int len = 0;
            for (byte[] c : buffers) {
                len += c.length;
            }
            result = new byte[len];
            int offset = 0;
            for (byte[] c : buffers) {
                System.arraycopy(c, 0, result, offset, c.length);
                offset += c.length;
            }
        }
        return result;
    }

    public static File saveToFile(File file, InputStream is) {
        if (is == null) {
            throw new NullPointerException("is");
        }
        FileOutputStream out = null;
        try {
            try {
                int len;
                FileUtils.forceMkdir((File)new File(file.getParent()));
                file.createNewFile();
                out = new FileOutputStream(file);
                byte[] buf = new byte[1000];
                while ((len = is.read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
                out.flush();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "file=" + file, e);
                try {
                    is.close();
                }
                catch (IOException e2) {
                    logger.log(Level.WARNING, "Failed to close inputStream " + file, e2);
                }
                try {
                    out.close();
                }
                catch (IOException e3) {
                    logger.log(Level.WARNING, "Failed to close outputStream " + file, e3);
                }
                return null;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to close inputStream " + file, e);
            }
            try {
                out.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to close outputStream " + file, e);
            }
        }
        return file;
    }
}

