/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library;

import ca.infodata.ofys.ui.library.DaemonThread;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.UI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public final class Util {
    private static final Logger logger = Logger.getLogger(Util.class.getName());
    private static Pattern macPattern = Pattern.compile(".*((:?[0-9a-f]{2}[-:]){5}[0-9a-f]{2}).*", 2);
    private static Pattern ipPattern = Pattern.compile(".*(([0-9]{1,3}[.]){3}[0-9]{1,3}).*", 2);
    private static String[] ipConfigWindowsCommand = new String[]{"ipconfig", "/all"};
    private static String[] ipCongifLinuxCommand = new String[]{"/sbin/ifconfig"};
    private static String macAddress = null;
    private static String ipAddress = null;

    private Util() {
        throw new UnsupportedOperationException();
    }

    public static int getJavaVersion() {
        return Integer.parseInt((String.valueOf(System.getProperty("java.version")) + "000000").replaceAll("[^0-9]", "").substring(0, 5));
    }

    public static String getIp() {
        if (ipAddress == null) {
            ArrayList<String> ipAddressList = new ArrayList<String>();
            try {
                BufferedReader reader = Util.getIPorIFConfigStream();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = ipPattern.matcher(line);
                    if (!matcher.matches()) continue;
                    String tempLine = line;
                    tempLine = tempLine.replaceFirst("(([0-9]{1,3}[.]){3}[0-9]{1,3})", "~");
                    if ((tempLine = line.substring(tempLine.lastIndexOf("~"), tempLine.lastIndexOf("~") + (line.length() - (tempLine.length() - 1)))).equals("127.0.0.1")) continue;
                    ipAddressList.add(tempLine);
                }
                reader.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception on getting ip address", e);
            }
            ipAddress = ipAddressList.size() == 0 ? "no ip address" : (String)ipAddressList.get(0);
        }
        return ipAddress;
    }

    public static String getSystemUser() {
        return System.getProperty("user.name");
    }

    public static String getMacAddress() {
        if (macAddress == null) {
            ArrayList<String> macAddressList = new ArrayList<String>();
            try {
                BufferedReader reader = Util.getIPorIFConfigStream();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = macPattern.matcher(line);
                    if (!matcher.matches()) continue;
                    macAddressList.add(matcher.group(1).replaceAll("[-:]", " "));
                }
                reader.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Exception on getting mac address", e);
            }
            macAddress = macAddressList.size() == 0 ? "no mac address" : (String)macAddressList.get(0);
        }
        return macAddress;
    }

    private static BufferedReader getIPorIFConfigStream() throws IOException {
        String[] command;
        if (UI.OS_WINDOWS) {
            command = ipConfigWindowsCommand;
        } else if (UI.OS_CARBON || UI.OS_GTK) {
            command = ipCongifLinuxCommand;
        } else {
            throw new IOException("Unknown operating system: " + LibPlugin.OS + ", " + SWT.getPlatform());
        }
        final Process process = Runtime.getRuntime().exec(command);
        new DaemonThread(){

            @Override
            public void run() {
                try {
                    InputStream errorStream = process.getErrorStream();
                    while (errorStream.read() != -1) {
                    }
                    errorStream.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Exception on clearing stderr stream of process", e);
                }
            }
        }.start();
        return new BufferedReader(new InputStreamReader(process.getInputStream()));
    }

    public static void shakeIt(Shell shell) {
        if (shell == null) {
            throw new IllegalArgumentException("shell cant be null");
        }
        Point loc = shell.getLocation();
        Point siz = shell.getSize();
        Rectangle r0 = new Rectangle(loc.x, loc.y, siz.x, siz.y);
        Rectangle[] r = new Rectangle[]{new Rectangle(loc.x - 5, loc.y, siz.x, siz.y), new Rectangle(loc.x + 5, loc.y, siz.x, siz.y)};
        int i = 0;
        while (i < 8) {
            shell.setBounds(r[i % 2]);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Error shakeIt", e);
            }
            ++i;
        }
        shell.setBounds(r0);
    }

    public static int center(int baseWidth, int targetWidth) {
        if (baseWidth <= targetWidth) {
            return 0;
        }
        return baseWidth / 2 - targetWidth / 2;
    }

    public static boolean doProcess(String[] processToExecute) {
        boolean ok = false;
        String commandes = "";
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            String[] stringArray = processToExecute;
            int n = processToExecute.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                commandes = String.valueOf(commandes) + " " + element;
                cmds.add(element);
                ++n2;
            }
            ProcessBuilder builder = new ProcessBuilder(cmds);
            Process proc = builder.start();
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = proc.waitFor();
            logger.fine("ExitValue: " + exitVal);
            ok = exitVal == 0;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "doProcess : " + commandes, e);
        }
        return ok;
    }

    public static void openUrl(String href) throws ExecutionException {
        try {
            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            if (browser == null) {
                browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser("loginView");
            }
            URL url = new URL(href);
            browser.openURL(url);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Failed to open external browser with url " + href);
            throw new ExecutionException("L'ouverture du lien web \u00e0 \u00e9chou\u00e9e.");
        }
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(String.valueOf(this.type) + ">" + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

