/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.laboresults.editor;

import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.intro.cache.CacheChecker;
import ca.infodata.ofys.ui.intro.cache.ICacheProvider;
import ca.infodata.ofys.ui.intro.cache.NotAvailableWayOfGettingCacheException;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;

public final class XAppointmentFormatter {
    private XAppointmentFormatter() {
        throw new UnsupportedOperationException();
    }

    public static String formatDatetime(XAppointment appointment) {
        LocalDate date = appointment.getDate();
        short startTime = appointment.getStartTime();
        short endTime = appointment.getEndTime();
        int hour = startTime / 60;
        int minutes = startTime % 60;
        int length = endTime - startTime;
        String formattedDate = LocalDateFormat.format((LocalDate)date, (String)FormatDateProvider.getFormatDate().toString());
        String formattedHour = StringUtils.padLeft((String)String.valueOf(hour), (int)2, (char)'0');
        String formattedMinutes = StringUtils.padLeft((String)String.valueOf(minutes), (int)2, (char)'0');
        String formattedDuration = StringUtils.padLeft((String)String.valueOf(length), (int)2, (char)'0');
        String fDate = "%1$s";
        String fTime = "%2$sh%3$s (%4$sM)";
        return String.format(String.valueOf(fDate) + " " + fTime, formattedDate, formattedHour, formattedMinutes, formattedDuration);
    }

    public static String format(XAppointment appointment, boolean includeDate, boolean includeProfessional, boolean includePatient, boolean includeNote, boolean includeSite) {
        return XAppointmentFormatter.format(appointment, includeDate, includeProfessional, includePatient, includeNote, includeSite, false);
    }

    public static String format(XAppointment appointment, boolean includeDate, boolean includeProfessional, boolean includePatient, boolean includeNote, boolean includeSite, boolean includeType) {
        XSite site;
        ICacheProvider cacheProvider;
        String formattedProfessional;
        if (appointment.getId() == null && appointment.getDate() == null) {
            return appointment.getNote();
        }
        LocalDate dateGiven = LocalDate.fromTimeInMillisLOCAL((Long)appointment.getDateCreated());
        LocalDate date = appointment.getDate();
        boolean apptGivenSameDay = false;
        if (dateGiven != null && appointment.getId() != null) {
            apptGivenSameDay = dateGiven.equals((Object)date);
        }
        short startTime = appointment.getStartTime();
        short endTime = appointment.getEndTime();
        int hour = startTime / 60;
        int minutes = startTime % 60;
        int length = endTime - startTime;
        XBaseProfessionnal professional = PersonUiPlugin.getDefault().getBaseProfessionnal(appointment.getIdProfessional());
        XPatient patient = appointment.getPatient();
        XPatientStatus patientStatus = appointment.getPatientStatus();
        XAppointmentStatus status = appointment.getStatus();
        String formattedDate = LocalDateFormat.format((LocalDate)date, (String)FormatDateProvider.getFormatDate().toString());
        String formattedHour = StringUtils.padLeft((String)String.valueOf(hour), (int)2, (char)'0');
        String formattedMinutes = StringUtils.padLeft((String)String.valueOf(minutes), (int)2, (char)'0');
        String formattedDuration = length == 0 ? "" : StringUtils.padLeft((String)String.valueOf(length), (int)2, (char)'0');
        String string = formattedProfessional = professional == null ? "" : String.valueOf(professional.firstName) + " " + professional.lastName;
        String formattedPatient = patient == null ? (appointment.getPatients() == null || appointment.getPatients().isEmpty() ? "" : "Groupe") : patient.getName();
        includePatient = includePatient && StringUtils.isNotEmpty((String)formattedPatient);
        String formattedNote = appointment.getNote();
        String formattedType = null;
        if (appointment.getTypeAppointment() != null && (cacheProvider = CacheChecker.getInstance().getCacheProvider(XAppointmentType.class)) != null) {
            try {
                XAppointmentType type = (XAppointmentType)cacheProvider.getById(appointment.getTypeAppointment());
                if (type != null) {
                    formattedType = type.getCode();
                }
            }
            catch (NotAvailableWayOfGettingCacheException notAvailableWayOfGettingCacheException) {}
        }
        String formattedPatientStatus = patientStatus == XPatientStatus.ARRIVED && appointment.getArrivedTime() != null ? String.valueOf(DateUtil.convertTimeToString((Short)appointment.getArrivedTime(), (Character)Character.valueOf(':'))) + " " + patientStatus.toString() : (patientStatus == XPatientStatus.SEEN && appointment.getSeenTime() != null ? String.valueOf(DateUtil.convertTimeToString((Short)appointment.getSeenTime(), (Character)Character.valueOf(':'))) + " " + patientStatus.toString() : (patientStatus != null && patientStatus != XPatientStatus.NONE ? patientStatus.toString() : ""));
        String formattedAppointmentStatus = status != null && status != XAppointmentStatus.NORMAL ? status.toString() : "";
        String formattedSite = includeSite ? ((site = SitePlugin.getDefault().getSite(appointment.getSite())) == null ? null : site.getNameCommon()) : "";
        String fTime = apptGivenSameDay ? "* %2$sh%3$s" : "%2$sh%3$s";
        fTime = length == 0 ? String.valueOf(fTime) + "%4$s" : String.valueOf(fTime) + " (%4$sM)";
        String fDate = "%1$s";
        String fProf = "%5$s";
        String fNote = "| %9$s";
        String fpatient = "; %6$s";
        String fPatientStatus = "(%7$s)";
        String fAppointmentStatus = "(%8$s)";
        String fSite = " | %10$s";
        String fType = " | %11$s";
        JoinList parts = new JoinList(" ", 5);
        if (includeDate) {
            parts.add((CharSequence)fDate);
        }
        parts.add((CharSequence)fTime);
        if (includeProfessional) {
            parts.add((CharSequence)fProf);
        }
        if (includePatient) {
            parts.add((CharSequence)fpatient);
        }
        if (!StringUtils.isBlank((CharSequence)formattedPatientStatus)) {
            parts.add((CharSequence)fPatientStatus);
        }
        if (!StringUtils.isBlank((CharSequence)formattedAppointmentStatus)) {
            parts.add((CharSequence)fAppointmentStatus);
        }
        if (includeNote && !StringUtils.isBlank((CharSequence)formattedNote)) {
            parts.add((CharSequence)fNote);
        }
        if (includeSite && StringUtils.isNotBlank((String)formattedSite)) {
            parts.add((CharSequence)fSite);
        }
        if (includeType && StringUtils.isNotBlank((String)formattedType)) {
            parts.add((CharSequence)fType);
        }
        String format = parts.toString();
        return String.format(format, formattedDate, formattedHour, formattedMinutes, formattedDuration, formattedProfessional, formattedPatient, formattedPatientStatus, formattedAppointmentStatus, formattedNote, formattedSite, formattedType);
    }
}

