/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.eform;

import ca.infodata.ofys.browsersetting.BrowserSetter;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.eform.EFormPrepare;
import ca.infodata.ofys.client.modules.eform.EformController;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ProfessionnalRequestAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.dataaccess.util.notification.DataObjectNotificationHandler;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocumentType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocuments;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.data.middle.dataobjects.request.XProfessionnalRequest;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.controls.ICancelablePart;
import ca.infodata.ofys.ui.controls.IPrintable;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import ca.infodata.ofys.ui.controls.middle.interfaces.IDocumentsEditor;
import ca.infodata.ofys.ui.controls.report2.PrintController;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2;
import ca.infodata.ofys.ui.controls.windows.AskTextQuestionDialog;
import ca.infodata.ofys.ui.eform.EFormBrowserComposite;
import ca.infodata.ofys.ui.eform.EFormIncompleteMetadatCancelException;
import ca.infodata.ofys.ui.eform.SimpleEFormInput;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.EditorPart;

public class SimpleEFormEditor
extends EditorPart
implements ISaveablePart,
ICancelablePart,
IPrintable,
IReusableEditor,
IDocumentsEditor,
IPatientRelated {
    private static final String MESSAGE_NULL_DOC = Messages.getString((String)"MESSAGE_NULL_DOC", (String[])new String[0]);
    private static final String ASSOCIER_DOCUMENT = Messages.getString((String)"ASSOCIER_DOCUMENT", (String[])new String[0]);
    private static final String VEUILLER_ENTRER_DESCR = Messages.getString((String)"VEUILLER_ENTRER_DESCR", (String[])new String[0]);
    private static final String DESCR_NE_PEUT_ETRE_NULL = Messages.getString((String)"DESCR_NE_PEUT_ETRE_NULL", (String[])new String[0]);
    private static final Logger logger = Logger.getLogger(SimpleEFormEditor.class.getName());
    private EFormBrowserComposite browser;
    private boolean uiLoaded;
    private boolean formLoaded;
    private boolean fromEncounter = false;
    private DataObjectNotificationHandler handler;
    private final EformController controller = new EformController();

    public SimpleEFormEditor() {
        this.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (!SimpleEFormEditor.this.uiLoaded) {
                    return;
                }
                if (propId == 258) {
                    SimpleEFormEditor.this.refresh();
                }
            }
        });
        this.handler = new DataObjectNotificationHandler(){

            public void handle(DataObjectUpdatedNotification notification) {
                if (notification != null && notification.getObject() instanceof DataObject) {
                    DataObject dto = (DataObject)notification.getObject();
                    Integer basePerson = Application.get().getGlobalInstances().getSession().getUser().getBasePerson();
                    boolean isReadonly = SimpleEFormEditor.this.getEditorInput().isReadonly();
                    Integer inputIdAnchor = SimpleEFormEditor.this.getEditorInput().getData().getIdAnchor();
                    Integer objectIdAnchor = dto.getIdAnchor();
                    Integer objectIdAuthor = dto.getIdAuthor();
                    if (XEformData.class.getName().equals(dto.getClazz()) && inputIdAnchor != null && inputIdAnchor.equals(objectIdAnchor) && (objectIdAuthor == null || !objectIdAuthor.equals(basePerson))) {
                        String ecraseData = isReadonly ? "" : "\n" + Messages.getString((String)"VOS_DATA_SERONT_ECRASEES", (String[])new String[0]);
                        boolean rep = MessageUtil.askQuestion((Shell)UI.getWorkbenchShell(), (String)(String.valueOf(Messages.getString((String)"AUTRE_UTILISATEUR_JUST_SAVED", (String[])new String[0])) + ecraseData));
                        if (rep) {
                            try {
                                XEformData fullData = new EformController().getFormData(dto.getId(), true);
                                final SimpleEFormInput input = new SimpleEFormInput(fullData, SimpleEFormEditor.this.getEditorInput().getPatient(), isReadonly);
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        SimpleEFormEditor.this.formLoaded = false;
                                        SimpleEFormEditor.this.setInput(input);
                                        SimpleEFormEditor.this.browser.setBrowserDirty(true);
                                        SimpleEFormEditor.this.firePropertyChange(257);
                                    }
                                });
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Failed to load eform data after receiving a notification", e);
                            }
                        }
                    }
                }
            }
        };
        Application.get().getGlobalInstances().getNotificationSystem().addDataObjectNotificationHandler(this.handler);
    }

    protected void refresh() {
        this.formLoaded = false;
        if (this.getEditorInput().getData() != null) {
            this.viewEFormData();
        } else if (this.getEditorInput().getForm() != null) {
            this.viewEForm(this.getEditorInput().getForm());
        }
    }

    protected void viewEFormData() {
        XEformData data = this.getEditorInput().getData();
        this.browser.viewEFormData(data);
    }

    protected void viewEForm(XEform f) {
        this.browser.viewEForm(f);
    }

    public void doCancel(IProgressMonitor monitor) {
        this.getEditorInput().doCancel();
        this.viewEFormData();
        this.firePropertyChange(257);
    }

    public void doSave(IProgressMonitor monitor) {
        XEformData data = this.getEditorInput().getData();
        if (data != null) {
            try {
                Object metaObj = this.saveBrowserToEFormData(true);
                XEformData savedData = this.controller.save(data);
                savedData.setEform((XBaseEform)((XEform)data.getForm()));
                if (metaObj != null && metaObj instanceof XProfessionnalRequest) {
                    XProfessionnalRequest xpr = (XProfessionnalRequest)metaObj;
                    xpr.setIdData(data.getId());
                    try {
                        ProfessionnalRequestAccessorClient.getInstance().saveSync(xpr.hashCode(), Application.get().getGlobalInstances().getSession(), (Serializable)xpr, false);
                    }
                    catch (CannotConnectToServerException e) {
                        logger.log(Level.SEVERE, "Unable to save ProfessionnalRequest form eform : " + xpr, e);
                    }
                }
                this.browser.setBrowserDirty(false);
                this.firePropertyChange(257);
                SimpleEFormInput input2 = new SimpleEFormInput(savedData, this.getEditorInput().getPatient(), true);
                input2.setFromEncounter(this.fromEncounter);
                this.setInput(input2);
                if (this.fromEncounter && this.getEditorInput().getPatient() != null) {
                    IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
                    try {
                        Event event = new Event();
                        event.data = this;
                        handlerService.executeCommand("ca.infodata.ofys.ui.encounter.documents.PushDocumentsAction", event);
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, String.valueOf(ex.getClass().getName()) + " has been throwed.", ex);
                    }
                }
            }
            catch (EFormIncompleteMetadatCancelException e) {
                logger.log(Level.INFO, String.valueOf(e.getClass().getName()) + " has been throwed.", e);
            }
            catch (StatusException e) {
                MessageUtil.show((Shell)this.getShell(), (IStatus)e.getStatus());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.valueOf(data), e);
                MessageUtil.show((Shell)this.getShell(), (Exception)e);
            }
        }
    }

    private Object saveBrowserToEFormData() throws EFormIncompleteMetadatCancelException {
        return this.saveBrowserToEFormData(false);
    }

    private Object saveBrowserToEFormData(boolean mustCheckMetaData) throws EFormIncompleteMetadatCancelException {
        XEformData edata = this.getEditorInput().getData();
        Object metaObj = null;
        if (this.formLoaded && edata != null && this.isBrowserDirty()) {
            boolean isFormValid = true;
            isFormValid = this.browser.validate();
            if (isFormValid) {
                this.browser.preSaveForm();
                Map<String, Object> inputs = this.browser.listFormInputs();
                Object[] metas = this.browser.listMetadata();
                String value = this.browser.getResumeValue();
                this.controller.saveInputsToEFormData(edata, inputs, metas, mustCheckMetaData, value);
            } else {
                throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, "Le formulaire n'est pas valide."));
            }
        }
        return metaObj;
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        SimpleEFormInput input = this.getEditorInput();
        return this.uiLoaded && this.formLoaded && input != null && input.getData() != null && !input.isReadonly() && (this.isBrowserDirty() || input.getData().getId() == null);
    }

    public boolean isBrowserDirty() {
        return !this.getEditorInput().isReadonly();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = UI.createToolKit((Widget)parent);
        toolkit.adapt(parent);
        this.browser = new EFormBrowserComposite(parent, toolkit);
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent e) {
                SimpleEFormInput input = SimpleEFormEditor.this.getEditorInput();
                EFormPrepare init = new EFormPrepare(input.getPatient());
                init.edata = input.getData();
                init.readonly = input.isReadonly();
                init.inputs = SimpleEFormEditor.this.browser.listFormInputs();
                init.doPropertyAndSavedStatusSetup();
                if (init.properties != null) {
                    SimpleEFormEditor.this.browser.setVariablesInBrowser(init.properties);
                }
                SimpleEFormEditor.this.browser.setBrowsertReadonly(input.isReadonly());
                SimpleEFormEditor.this.browser.setLoadedInfo(init);
                SimpleEFormEditor.this.browser.postLoadForm();
                SimpleEFormEditor.this.formLoaded = true;
            }
        });
        this.browser.getInnerBrowser().addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent e) {
                try {
                    SimpleEFormEditor.this.saveBrowserToEFormData();
                }
                catch (EFormIncompleteMetadatCancelException ex) {
                    logger.log(Level.INFO, String.valueOf(ex.getClass().getName()) + " has been throwed.", ex);
                }
            }
        });
        final Timer timer = new Timer("checkSimpleEformEditorTimer", false);
        timer.schedule(new TimerTask(){
            private boolean previousDirtyState = false;

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SimpleEFormEditor.this.browser.isDisposed()) {
                            this.cancel();
                            return;
                        }
                        boolean dirty = SimpleEFormEditor.this.isDirty();
                        if (previousDirtyState != dirty) {
                            previousDirtyState = dirty;
                            SimpleEFormEditor.this.firePropertyChange(257);
                        }
                    }
                });
            }
        }, 1000L, 1000L);
        this.browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                timer.cancel();
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.browser.setLayoutData(data);
        this.uiLoaded = true;
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("ca.infodata.ofys.ui.controls.EditorPart.keybinding.context");
        this.firePropertyChange(258);
    }

    public void setInput(IEditorInput input) {
        if (!(input instanceof SimpleEFormInput)) {
            throw new IllegalArgumentException("input must be of type SimpleEFormInput");
        }
        this.fromEncounter = ((SimpleEFormInput)input).isFromEncounter();
        if (this.uiLoaded) {
            this.setInputWithNotify(input);
        } else {
            super.setInput(input);
        }
        this.setPartName(input.getName());
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    public void setTitleImage(Image image) {
        super.setTitleImage(image);
    }

    public void print() {
        SimpleEFormInput editorInput = this.getEditorInput();
        if (editorInput != null) {
            String keyContext = "form";
            PrintController printController = new PrintController((Serializable)editorInput.getData(), keyContext);
            PrintDialog2 dialog = new PrintDialog2(this.getSite().getShell(), printController);
            UI.centerComposite((Composite)dialog.getShell(), (Composite)this.getEditorSite().getShell());
            dialog.open();
        }
    }

    public static BrowserSetter printSetup(String type) {
        BrowserSetter setting = null;
        try {
            setting = BrowserSetter.getBrowserSetting();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Couldn't access windows registery. " + e.getMessage());
        }
        if (setting != null && type.equals("activate")) {
            setting.setBrowserToBestPrint();
        }
        if (setting != null && type.equals("finish")) {
            setting.resetBrowserSetting();
        }
        return setting;
    }

    public SimpleEFormInput getEditorInput() {
        return (SimpleEFormInput)super.getEditorInput();
    }

    public XEform getEform() {
        SimpleEFormInput input = this.getEditorInput();
        if (input != null) {
            return input.getForm();
        }
        return null;
    }

    public void dispose() {
        Application.get().getGlobalInstances().getNotificationSystem().removeDataObjectNotificationHandler(this.handler);
        super.dispose();
    }

    public void setFocus() {
    }

    public XDocuments getDocuments(Integer idPatientAnchor) {
        XEformData edata;
        final SimpleEFormInput input = this.getEditorInput();
        if (input != null && (edata = input.getData()) != null && edata.getId() != null && edata.getIdPatient().equals(idPatientAnchor)) {
            final XDocuments doc = new XDocuments();
            final String resultante = StringUtils.isBlank((CharSequence)edata.getResumeValue()) ? "" : " [" + StringUtils.abbreviateToWordExtra((String)edata.getResumeValue(), (int)30) + "]";
            final Boolean[] firstTryAndCanceled = new Boolean[]{true, false};
            while (StringUtils.isBlank((CharSequence)doc.getDescription()) && !firstTryAndCanceled[1].booleanValue()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AskTextQuestionDialog diag = null;
                        if (firstTryAndCanceled[0].booleanValue()) {
                            diag = new AskTextQuestionDialog(SimpleEFormEditor.this.getShell(), String.valueOf(input.getForm().getName()) + resultante, ASSOCIER_DOCUMENT, new String[]{VEUILLER_ENTRER_DESCR});
                            firstTryAndCanceled[0] = false;
                        } else {
                            diag = new AskTextQuestionDialog(SimpleEFormEditor.this.getShell(), String.valueOf(input.getForm().getName()) + resultante, ASSOCIER_DOCUMENT, new String[]{VEUILLER_ENTRER_DESCR, DESCR_NE_PEUT_ETRE_NULL});
                        }
                        diag.open();
                        if (diag.getButtonClicked() == 0) {
                            doc.setDescription(diag.getAnswer());
                        } else {
                            firstTryAndCanceled[1] = true;
                        }
                    }
                });
            }
            if (!firstTryAndCanceled[1].booleanValue()) {
                doc.setIdDocument(edata.getId());
                doc.setType(XDocumentType.EFORM);
                doc.setIsDeleted(Boolean.FALSE);
                return doc;
            }
        }
        return null;
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }

    public String getMsgOnNullDocuments() {
        return MESSAGE_NULL_DOC;
    }

    public IPatient getPatient() {
        SimpleEFormInput input = this.getEditorInput();
        if (input != null) {
            return input.getPatient();
        }
        return null;
    }

    public boolean isPrintAllowed() {
        SimpleEFormInput input = this.getEditorInput();
        return input != null && input.getData() != null && input.getData().getId() != null && !this.isDirty();
    }

    public MessageLink getMessageLink() {
        return null;
    }

    public boolean isSaveAllowed() {
        return this.isDirty();
    }
}

