/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq;

import ca.infodata.dsq.domain.Gender;
import ca.infodata.dsq.signature.Pkcs7SignatureI;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.TimestampSignatureIFactory;
import ca.infodata.dsq.signature.XmlSignatureCore;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.dsq.signature.XmlSignatureS;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.data.client.dataaccess.DSQAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.IControlWrapper;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.windows.AbstractSingleInputWindows;
import ca.infodata.ofys.ui.dsq.DSQPlugin;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.Pair;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SignatureException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BaseDSQAction {
    private static final Logger logger = Logger.getLogger(BaseDSQAction.class.getName());
    private IWorkbenchWindow window;
    private Shell shell;
    private static Map<String, SignatureData> signatureCache = new HashMap<String, SignatureData>();
    private static Map<Pair<String, String>, SignatureData> xmlSignatureNiuCache = new HashMap<Pair<String, String>, SignatureData>();
    private static Map<Pair<String, String>, SignatureData> pkcs7SignatureNiuCache = new HashMap<Pair<String, String>, SignatureData>();
    private static Set<String> usedAliases = new HashSet<String>();
    private static boolean forceResetCache = true;
    private static final XmlSignatureCore xmlSignatureCore = new XmlSignatureCore();
    private static String tempSessionAlias;
    private static final Object aliasSynchronizationLock;

    static {
        aliasSynchronizationLock = new Object();
    }

    public boolean hasSignatures(Integer idPatient) {
        boolean hasSignatures = false;
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session == null) {
            return false;
        }
        try {
            ReturnObject r = DSQAccessorClient.getInstance().hasSignatures(session, idPatient);
            if (r != null && r.getObj() != null && r.getObj() instanceof Boolean) {
                hasSignatures = (Boolean)r.getObj();
            }
        }
        catch (CannotConnectToServerException e) {
            logger.log(Level.WARNING, "hasSignatures", e);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "hasSignatures", e);
        }
        return hasSignatures;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void init(Shell shell) {
        this.shell = shell;
    }

    public final void checkIfDsqFunctionnalitiesAreActive() throws AbortException {
        if (!DSQPlugin.getDefault().isDsqEnabledForSession()) {
            throw new AbortException("Les fonctionnalit\u00e9s DSQ ont \u00e9t\u00e9 d\u00e9sactiv\u00e9es pour cette session");
        }
        if (!DSQPlugin.getDefault().isDsqEnabledForClient()) {
            throw new AbortException("Les fonctionnalit\u00e9s DSQ ont \u00e9t\u00e9 d\u00e9sactiv\u00e9es pour ce client");
        }
        if (!DSQPlugin.getDefault().isDsqEnabled()) {
            throw new AbortException("Les fonctionnalit\u00e9s DSQ ont \u00e9t\u00e9 d\u00e9sactiv\u00e9es");
        }
    }

    public final boolean checkIfDsqFunctionnalitiesAreActive2() {
        boolean b = DSQPlugin.getDefault().isDsqEnabledForSession();
        if (!b) {
            MessageUtil.warningMsg((Shell)this.getShell(), (String)"Les fonctionnalit\u00e9s DSQ ont \u00e9t\u00e9 d\u00e9sactiv\u00e9es pour cette session");
        }
        return b;
    }

    public final synchronized Alias getAlias(IProgressMonitor monitor) throws AbortException, CancelException {
        return this.getAlias(monitor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized Alias getAlias(IProgressMonitor monitor, boolean forceNewAliasDialog) throws AbortException, CancelException {
        XSession session;
        this.checkIfDsqFunctionnalitiesAreActive();
        if (monitor != null) {
            monitor.subTask("Obtention de l'alias");
        }
        if ((session = Application.get().getGlobalInstances().getSession()) == null) {
            throw new AbortException("Aucune session active");
        }
        final Alias alias = new Alias();
        Object object = aliasSynchronizationLock;
        synchronized (object) {
            alias.alias = session.getUser().getUserPreferences().getDsqPreferences().getDsqTokenAlias();
            if (StringUtils.isBlank((CharSequence)alias.alias)) {
                alias.alias = tempSessionAlias;
            }
            boolean askNewAliasDialog = forceNewAliasDialog;
            boolean canceled = false;
            while (askNewAliasDialog || StringUtils.isBlank((CharSequence)alias.alias) && !canceled) {
                askNewAliasDialog = false;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractSingleInputWindows fillInAliasWindow = new AbstractSingleInputWindows(BaseDSQAction.this.getShell(), "...", "Veuillez saisir l'alias de votre cl\u00e9"){
                            private MyText text;

                            protected boolean btnPressed(int btnId) {
                                if (btnId == 0) {
                                    alias.alias = this.text.getText().trim();
                                }
                                return true;
                            }

                            protected IControl createControlOverride(Composite parent, FormToolkit toolkit) {
                                Composite composite = new Composite(parent, 0);
                                FillLayout fillLayout = new FillLayout(512);
                                fillLayout.spacing = 5;
                                composite.setLayout((Layout)fillLayout);
                                composite.setLayoutData((Object)UI.newFillFormData());
                                this.text = new MyText(composite, 2048);
                                return new IControlWrapper((Control)composite);
                            }
                        };
                        fillInAliasWindow.open();
                    }
                });
                if (!StringUtils.isBlank((CharSequence)alias.alias)) continue;
                MyMessageDialogBuilder b = new MyMessageDialogBuilder();
                b.useWarningBundle();
                b.setMessage("L'alias n'est pas configur\u00e9");
                b.setButtonLabels(new String[]{"R\u00e9essayer", "D\u00e9sactiver pour cette session", "Annuler"});
                b.setDefaultButton(0);
                int r = b.buildAndOpen();
                if (r == 1) {
                    DSQPlugin.getDefault().setDsqEnabledForSession(false);
                    canceled = true;
                    continue;
                }
                if (r != 2) continue;
                canceled = true;
            }
            if (canceled) {
                throw new CancelException();
            }
            tempSessionAlias = alias.alias;
            usedAliases.add(alias.alias);
        }
        return alias;
    }

    public final synchronized HashMap<Integer, XmlSignatureI> getXmlSignatureIForCache(IProgressMonitor monitor, Alias a, String password) throws CancelException, AbortException {
        HashMap<Integer, XmlSignatureI> map = new HashMap<Integer, XmlSignatureI>(16);
        Calendar c = DateUtil.newCalendar();
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        int i = 0;
        while (i <= 15) {
            if (i != 0) {
                c.add(11, 1);
            }
            String token = TimestampSignatureIFactory.computeTimestamp((long)c.getTimeInMillis());
            XmlSignatureI signature = this.getXmlSignatureI(monitor, a, password, token, null, false);
            int hour = c.get(11);
            map.put(hour, signature);
            if (i == 0) {
                signatureCache.put(a.alias, new SignatureData((Signature)signature));
            }
            ++i;
        }
        return map;
    }

    public final synchronized XmlSignatureI getSignatureI(IProgressMonitor monitor, Alias a, String password) throws CancelException, AbortException {
        return this.getXmlSignatureI(monitor, a, password, null, null, true);
    }

    public final synchronized XmlSignatureI getSignatureI(IProgressMonitor monitor, Alias a, String password, String niu) throws CancelException, AbortException {
        return this.getXmlSignatureI(monitor, a, password, null, niu, true);
    }

    public final synchronized XmlSignatureI getXmlSignatureI(IProgressMonitor monitor, Alias a, String password, String niu) throws CancelException, AbortException {
        return this.getXmlSignatureI(monitor, a, password, null, niu, true);
    }

    private final synchronized XmlSignatureI getXmlSignatureI(IProgressMonitor monitor, Alias a, String password, String token, String niu, boolean useCache) throws CancelException, AbortException {
        if (monitor != null) {
            monitor.subTask("Obtention de la signature");
        }
        if (a != null && StringUtils.isNotBlank((String)a.alias) && useCache) {
            SignatureData signatureData;
            if (niu != null) {
                BaseDSQAction.cleanSignatureNiuCache();
                signatureData = xmlSignatureNiuCache.get(Pair.newPair((Object)a.alias, (Object)niu));
                if (signatureData != null && !signatureData.hasExpired()) {
                    return (XmlSignatureI)signatureData.signature;
                }
            } else {
                BaseDSQAction.cleanSignatureCache();
                signatureData = signatureCache.get(a.alias);
                if (signatureData != null && !signatureData.hasExpired()) {
                    return (XmlSignatureI)signatureData.signature;
                }
            }
        }
        boolean canceled = false;
        XmlSignatureI signature = null;
        do {
            try {
                xmlSignatureCore.initOnChange(a.alias, password);
                signature = token != null && niu != null ? new XmlSignatureI(token, niu) : (token != null ? new XmlSignatureI(token, "") : (niu != null ? new XmlSignatureI(niu) : new XmlSignatureI()));
                signature.sign(xmlSignatureCore);
            }
            catch (Exception e) {
                signature = null;
                String message = this.getExceptionMessage(e, a.alias);
                if (StringUtils.isBlank((CharSequence)message)) {
                    canceled = true;
                    continue;
                }
                MyMessageDialogBuilder b = new MyMessageDialogBuilder();
                b.useWarningBundle();
                b.setMessage(message);
                b.setButtonLabels(new String[]{"R\u00e9essayer", "Changer l'alias", "D\u00e9sactiver pour cette session", "Annuler"});
                b.setDefaultButton(0);
                int r = b.buildAndOpen();
                if (r == 1) {
                    a = this.getAlias(monitor, true);
                    continue;
                }
                if (r == 2) {
                    DSQPlugin.getDefault().setDsqEnabledForSession(false);
                    canceled = true;
                    continue;
                }
                if (r != 3) continue;
                canceled = true;
            }
        } while (signature == null && !canceled);
        if (canceled) {
            throw new CancelException();
        }
        if (signature != null) {
            if (useCache) {
                if (niu != null) {
                    xmlSignatureNiuCache.put((Pair<String, String>)Pair.newPair((Object)a.alias, (Object)niu), new SignatureData((Signature)signature));
                } else {
                    signatureCache.put(a.alias, new SignatureData((Signature)signature));
                }
            }
            tempSessionAlias = a.alias;
        }
        return signature;
    }

    public final synchronized Signature getPkcs7SignatureI(IProgressMonitor monitor, Alias a, String password, String niu) throws CancelException, AbortException {
        if (monitor != null) {
            monitor.subTask("Obtention de la signature");
        }
        if (a != null && StringUtils.isNotBlank((String)a.alias) && niu != null) {
            BaseDSQAction.cleanSignatureNiuCache();
            SignatureData signatureData = pkcs7SignatureNiuCache.get(Pair.newPair((Object)a.alias, (Object)niu));
            if (signatureData != null && !signatureData.hasExpired()) {
                return signatureData.signature;
            }
        }
        boolean canceled = false;
        Pkcs7SignatureI signature = null;
        do {
            try {
                signature = new Pkcs7SignatureI(niu);
                signature.sign(a.alias, password, forceResetCache);
                forceResetCache = false;
            }
            catch (Exception e) {
                signature = null;
                String message = this.getExceptionMessage(e, a.alias);
                if (StringUtils.isBlank((CharSequence)message)) {
                    canceled = true;
                    continue;
                }
                MyMessageDialogBuilder b = new MyMessageDialogBuilder();
                b.useWarningBundle();
                b.setMessage(message);
                b.setButtonLabels(new String[]{"R\u00e9essayer", "Changer l'alias", "D\u00e9sactiver pour cette session", "Annuler"});
                b.setDefaultButton(0);
                int r = b.buildAndOpen();
                if (r == 1) {
                    a = this.getAlias(monitor, true);
                    continue;
                }
                if (r == 2) {
                    DSQPlugin.getDefault().setDsqEnabledForSession(false);
                    canceled = true;
                    continue;
                }
                if (r != 3) continue;
                canceled = true;
            }
        } while (signature == null && !canceled);
        if (canceled) {
            throw new CancelException();
        }
        if (signature != null) {
            pkcs7SignatureNiuCache.put((Pair<String, String>)Pair.newPair((Object)a.alias, (Object)niu), new SignatureData((Signature)signature));
            tempSessionAlias = a.alias;
        }
        return signature;
    }

    public final synchronized Signature getSignatureS(IProgressMonitor monitor, Alias a, String password, String hash) throws CancelException, AbortException {
        if (monitor != null) {
            monitor.subTask("Obtention de la signature");
        }
        int cnt = 5;
        String type = "XML S avec hash";
        if (Application.get().getGlobalInstances().inDebugMode()) {
            this.printStacktraceMethod(cnt, type);
        }
        boolean canceled = false;
        XmlSignatureS signature = null;
        do {
            try {
                xmlSignatureCore.initOnChange(a.alias, password);
                signature = new XmlSignatureS(hash);
                signature.sign(xmlSignatureCore);
                forceResetCache = false;
            }
            catch (Exception e) {
                signature = null;
                String message = this.getExceptionMessage(e, a.alias);
                if (StringUtils.isBlank((CharSequence)message)) {
                    canceled = true;
                    continue;
                }
                MyMessageDialogBuilder b = new MyMessageDialogBuilder();
                b.useWarningBundle();
                b.setMessage(message);
                b.setButtonLabels(new String[]{"R\u00e9essayer", "Changer l'alias", "D\u00e9sactiver pour cette session", "Annuler"});
                b.setDefaultButton(0);
                int r = b.buildAndOpen();
                if (r == 1) {
                    a = this.getAlias(monitor, true);
                    continue;
                }
                if (r == 2) {
                    DSQPlugin.getDefault().setDsqEnabledForSession(false);
                    canceled = true;
                    continue;
                }
                if (r != 3) continue;
                canceled = true;
            }
        } while (signature == null && !canceled);
        if (canceled) {
            throw new CancelException();
        }
        if (signature != null) {
            tempSessionAlias = a.alias;
        }
        return signature;
    }

    private void printStacktraceMethod(int cnt, String type) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        cnt = cnt + 2 >= stackTrace.length ? stackTrace.length - 2 : cnt;
        int i = 0;
        while (i < cnt) {
            StackTraceElement stackTraceElement = stackTrace[i + 2];
            System.out.println(String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName() + ", ");
            ++i;
        }
        System.out.println(" ... :" + type);
    }

    public String getExceptionMessage(Throwable e, String alias) {
        SignatureException signatureException;
        if (e == null) {
            return "";
        }
        if (e instanceof KeyStoreException || e instanceof UnsupportedOperationException) {
            String message = e.getMessage();
            String trusted = "trusted certificate entries are not password-protected";
            String cannot = "cannot be found in keyStore";
            if (message.contains(trusted) || message.contains(cannot)) {
                return "L'alias " + alias + " n'a pu \u00eatre trouv\u00e9e dans le registre. " + "\n" + "\n1. Assurez-vous d'avoir inser\u00e9e votre cl\u00e9 s\u00e9curis\u00e9e dans un port USB. " + "\n\n2. Essayez d'enlever et de r\u00e9ins\u00e9rer votre cl\u00e9 s\u00e9curis\u00e9e. " + "\n\n3. Assurez-vous \u00e9galement que l'alias saisi dans votre fiche professionnelle correspond bien \u00e0 l'alias de votre cl\u00e9." + "\n\n" + "\nIMPORTANT" + "\n\nChaque utilisateur d'une cl\u00e9 s\u00e9curis\u00e9e doit utiliser une session Windows distincte." + "\n\nIl n'est pas recommand\u00e9 d'avoir plus d'une cl\u00e9 s\u00e9curis\u00e9e \u00e0 la fois connect\u00e9e \u00e0 l'ordinateur.";
            }
        }
        if ((signatureException = BaseDSQAction.getSignatureException(e)) != null) {
            return signatureException.getLocalizedMessage();
        }
        return e.getMessage();
    }

    public void manageDsqStatus(MultiStatus multiStatus) throws StatusException, Exception {
        if (multiStatus.isOK()) {
            return;
        }
        IStatus status = multiStatus.getChildByCode("DSQ_CONSENT_RESUFED");
        if (status != null) {
            throw new StatusException(status);
        }
        status = multiStatus.getChildByCode("DSQ_CANDIDATE_ID_ERROR");
        if (status != null) {
            throw new StatusException(status);
        }
        status = multiStatus.getChildByCode("DSQ_SERVICE_UNAVAILABLE");
        if (status != null) {
            throw new StatusException(status);
        }
        status = multiStatus.getChildByCode("DSQ_ACCESS_DENIED");
        if (status != null) {
            throw new StatusException(status);
        }
        status = multiStatus.getChildByCode("DSQ_INVALID_SIGNATURE");
        if (status != null) {
            throw new StatusException(status);
        }
        String message = multiStatus.getMessage();
        if (message != null && message.contains("Caused by: java.net.SocketTimeoutException: Read timed out")) {
            message = "L'appel au DSQ a \u00e9chou\u00e9 car le serveur DSQ a mis trop de temps \u00e0 r\u00e9pondre.\nVeuillez refaire l'appel. Si le probl\u00e8me persiste, contactez INFO-DATA.";
            throw new StatusException((IStatus)new Status("DSQ_TIMEOUT", IStatus.Severity.ERROR, message));
        }
        status = multiStatus.getChildByCode("DSQ_EXCEPTION");
        if (status != null) {
            throw new StatusException(status);
        }
        if (multiStatus.getMessage().contains("E - NOTFND")) {
            throw new StatusException((IStatus)multiStatus);
        }
        if (multiStatus.getMessage().contains("E - VALIDAT")) {
            throw new StatusException((IStatus)multiStatus);
        }
        throw new Exception(multiStatus.getMessage(), multiStatus.getException());
    }

    protected static String getReadTimeoutMessage(String message) {
        if (message != null && message.contains("Caused by: java.net.SocketTimeoutException: Read timed out")) {
            return "L'appel au DSQ a \u00e9chou\u00e9 car le serveur DSQ a mis trop de temps \u00e0 r\u00e9pondre.\nVeuillez refaire l'appel. Si le probl\u00e8me persiste, contactez INFO-DATA.";
        }
        return message;
    }

    private static SignatureException getSignatureException(Throwable e) {
        while (e != null) {
            if (e instanceof SignatureException) {
                return (SignatureException)e;
            }
            e = e.getCause();
        }
        return null;
    }

    public Shell getShell() {
        if (this.shell == null) {
            return this.getWindow().getShell();
        }
        return this.shell;
    }

    protected IWorkbenchWindow getWindow() {
        IWorkbenchWindow[] workbenchWindows;
        IWorkbenchWindow window2 = this.window;
        if (window2 == null) {
            window2 = DSQPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        }
        if (window2 == null && (workbenchWindows = DSQPlugin.getDefault().getWorkbench().getWorkbenchWindows()).length > 0) {
            window2 = workbenchWindows[0];
        }
        return window2;
    }

    public static Gender getDsqGender(String gender) {
        XPerson.Gender g = XPerson.Gender.from((String)gender);
        if (g == XPerson.Gender.FEMININ) {
            return Gender.FEMALE;
        }
        if (g == XPerson.Gender.MASCULIN) {
            return Gender.MALE;
        }
        return null;
    }

    public static XPerson.Gender getInfodataGender(Gender g) {
        if (g == Gender.FEMALE) {
            return XPerson.Gender.FEMININ;
        }
        if (g == Gender.MALE) {
            return XPerson.Gender.MASCULIN;
        }
        return XPerson.Gender.INCONNU;
    }

    private static void cleanSignatureNiuCache() {
        Iterator<Map.Entry<Pair<String, String>, SignatureData>> iterator2 = xmlSignatureNiuCache.entrySet().iterator();
        while (iterator2.hasNext()) {
            if (!iterator2.next().getValue().hasExpired()) continue;
            iterator2.remove();
        }
        iterator2 = pkcs7SignatureNiuCache.entrySet().iterator();
        while (iterator2.hasNext()) {
            if (!iterator2.next().getValue().hasExpired()) continue;
            iterator2.remove();
        }
    }

    private static void cleanSignatureCache() {
        Iterator<Map.Entry<String, SignatureData>> iterator = signatureCache.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getValue().hasExpired()) continue;
            iterator.remove();
        }
    }

    public void checkIfActionWasCanceled(IProgressMonitor monitor) throws CancelException {
        if (monitor != null && monitor.isCanceled()) {
            throw new CancelException();
        }
    }

    public static void resetState() {
        forceResetCache = true;
        tempSessionAlias = null;
        signatureCache.clear();
        xmlSignatureNiuCache.clear();
        pkcs7SignatureNiuCache.clear();
        if (LibPlugin.ON_WIN && !usedAliases.isEmpty()) {
            try {
                KeyStore keyStore = KeyStore.getInstance("Windows-MY", "SunMSCAPI");
                keyStore.load(null, null);
                Iterator<String> iterator = usedAliases.iterator();
                while (iterator.hasNext()) {
                    String alias = iterator.next();
                    try {
                        System.out.println("deleting " + alias);
                        keyStore.deleteEntry(alias);
                    }
                    catch (Exception e) {
                        logger.log(Level.INFO, "Failed to remove alias " + alias + " from keyStore", e);
                    }
                    iterator.remove();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to load the keyStore", e);
            }
        }
    }

    private static class SignatureData {
        public final Signature signature;
        private final long timestamp;

        public SignatureData(Signature signature2) {
            this.signature = signature2;
            this.timestamp = System.currentTimeMillis();
        }

        private long ageInMinutes() {
            return TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - this.timestamp);
        }

        private long ageInSecond() {
            return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.timestamp);
        }

        public boolean hasExpired() {
            return this.ageInMinutes() > 5L;
        }
    }
}

