/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEROutputStream;

public class DERSet
extends ASN1Set {
    public DERSet() {
    }

    public DERSet(DEREncodable obj) {
        this.addObject(obj);
    }

    public DERSet(ASN1EncodableVector v) {
        this(v, true);
    }

    public DERSet(ASN1Encodable[] a) {
        int i = 0;
        while (i != a.length) {
            this.addObject(a[i]);
            ++i;
        }
        this.sort();
    }

    DERSet(ASN1EncodableVector v, boolean needsSorting) {
        int i = 0;
        while (i != v.size()) {
            this.addObject(v.get(i));
            ++i;
        }
        if (needsSorting) {
            this.sort();
        }
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        Enumeration e = this.getObjects();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            dOut.writeObject(obj);
        }
        dOut.close();
        byte[] bytes = bOut.toByteArray();
        out.writeEncoded(49, bytes);
    }
}

