/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public abstract class Sorter {
    static final int THRESHOLD = 20;

    protected Sorter() {
    }

    protected abstract int compare(int var1, int var2);

    protected abstract void swap(int var1, int var2);

    public abstract void sort(int var1, int var2);

    void checkRange(int from, int to) {
        if (to < from) {
            throw new IllegalArgumentException("'to' must be >= 'from', got from=" + from + " and to=" + to);
        }
    }

    /*
     * Unable to fully structure code
     */
    void mergeInPlace(int from, int mid, int to) {
        if (from == mid || mid == to || this.compare(mid - 1, mid) <= 0) {
            return;
        }
        if (to - from != 2) ** GOTO lbl7
        this.swap(mid - 1, mid);
        return;
lbl-1000:
        // 1 sources

        {
            ++from;
lbl7:
            // 2 sources

            ** while (this.compare((int)from, (int)mid) <= 0)
        }
lbl8:
        // 2 sources

        while (this.compare(mid - 1, to - 1) <= 0) {
            --to;
        }
        if (mid - from > to - mid) {
            len11 = mid - from >>> 1;
            first_cut = from + len11;
            second_cut = this.lower(mid, to, first_cut);
            len22 = second_cut - mid;
        } else {
            len22 = to - mid >>> 1;
            second_cut = mid + len22;
            first_cut = this.upper(from, mid, second_cut);
            len11 = first_cut - from;
        }
        this.rotate(first_cut, mid, second_cut);
        new_mid = first_cut + len22;
        this.mergeInPlace(from, first_cut, new_mid);
        this.mergeInPlace(new_mid, second_cut, to);
    }

    int lower(int from, int to, int val) {
        int len = to - from;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from + half;
            if (this.compare(mid, val) < 0) {
                from = mid + 1;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    int upper(int from, int to, int val) {
        int len = to - from;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from + half;
            if (this.compare(val, mid) < 0) {
                len = half;
                continue;
            }
            from = mid + 1;
            len = len - half - 1;
        }
        return from;
    }

    int lower2(int from, int to, int val) {
        int f = to - 1;
        int t = to;
        while (f > from) {
            if (this.compare(f, val) < 0) {
                return this.lower(f, t, val);
            }
            int delta = t - f;
            t = f;
            f -= delta << 1;
        }
        return this.lower(from, t, val);
    }

    int upper2(int from, int to, int val) {
        int f = from;
        int t = f + 1;
        while (t < to) {
            if (this.compare(t, val) > 0) {
                return this.upper(f, t, val);
            }
            int delta = t - f;
            f = t;
            t += delta << 1;
        }
        return this.upper(f, to, val);
    }

    final void reverse(int from, int to) {
        --to;
        while (from < to) {
            this.swap(from, to);
            ++from;
            --to;
        }
    }

    final void rotate(int lo, int mid, int hi) {
        assert (lo <= mid && mid <= hi);
        if (lo == mid || mid == hi) {
            return;
        }
        this.doRotate(lo, mid, hi);
    }

    void doRotate(int lo, int mid, int hi) {
        if (mid - lo == hi - mid) {
            while (mid < hi) {
                this.swap(lo++, mid++);
            }
        } else {
            this.reverse(lo, mid);
            this.reverse(mid, hi);
            this.reverse(lo, hi);
        }
    }

    void insertionSort(int from, int to) {
        int i = from + 1;
        while (i < to) {
            int j = i;
            while (j > from) {
                if (this.compare(j - 1, j) <= 0) break;
                this.swap(j - 1, j);
                --j;
            }
            ++i;
        }
    }

    void binarySort(int from, int to) {
        this.binarySort(from, to, from + 1);
    }

    void binarySort(int from, int to, int i) {
        while (i < to) {
            int l = from;
            int h = i - 1;
            while (l <= h) {
                int mid = l + h >>> 1;
                int cmp = this.compare(i, mid);
                if (cmp < 0) {
                    h = mid - 1;
                    continue;
                }
                l = mid + 1;
            }
            switch (i - l) {
                case 2: {
                    this.swap(l + 1, l + 2);
                    this.swap(l, l + 1);
                    break;
                }
                case 1: {
                    this.swap(l, l + 1);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    int j = i;
                    while (j > l) {
                        this.swap(j - 1, j);
                        --j;
                    }
                    break block0;
                }
            }
            ++i;
        }
    }

    void heapSort(int from, int to) {
        if (to - from <= 1) {
            return;
        }
        this.heapify(from, to);
        int end = to - 1;
        while (end > from) {
            this.swap(from, end);
            this.siftDown(from, from, end);
            --end;
        }
    }

    void heapify(int from, int to) {
        int i = Sorter.heapParent(from, to - 1);
        while (i >= from) {
            this.siftDown(i, from, to);
            --i;
        }
    }

    void siftDown(int i, int from, int to) {
        int leftChild = Sorter.heapChild(from, i);
        while (leftChild < to) {
            int rightChild = leftChild + 1;
            if (this.compare(i, leftChild) < 0) {
                if (rightChild < to && this.compare(leftChild, rightChild) < 0) {
                    this.swap(i, rightChild);
                    i = rightChild;
                } else {
                    this.swap(i, leftChild);
                    i = leftChild;
                }
            } else {
                if (rightChild >= to || this.compare(i, rightChild) >= 0) break;
                this.swap(i, rightChild);
                i = rightChild;
            }
            leftChild = Sorter.heapChild(from, i);
        }
    }

    static int heapParent(int from, int i) {
        return (i - 1 - from >>> 1) + from;
    }

    static int heapChild(int from, int i) {
        return (i - from << 1) + 1 + from;
    }
}

