/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PriorityQueue;

public final class OfflineSorter {
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long MIN_BUFFER_SIZE_MB = 32L;
    public static final long ABSOLUTE_MIN_SORT_BUFFER_SIZE = 524288L;
    private static final String MIN_BUFFER_SIZE_MSG = "At least 0.5MB RAM buffer is needed";
    public static final int MAX_TEMPFILES = 128;
    private final BufferSize ramBufferSize;
    private final File tempDirectory;
    private final Counter bufferBytesUsed = Counter.newCounter();
    private final BytesRefArray buffer = new BytesRefArray(this.bufferBytesUsed);
    private SortInfo sortInfo;
    private int maxTempFiles;
    private final Comparator<BytesRef> comparator;
    public static final Comparator<BytesRef> DEFAULT_COMPARATOR = BytesRef.getUTF8SortedAsUnicodeComparator();

    public OfflineSorter() throws IOException {
        this(DEFAULT_COMPARATOR, BufferSize.automatic(), OfflineSorter.defaultTempDir(), 128);
    }

    public OfflineSorter(Comparator<BytesRef> comparator) throws IOException {
        this(comparator, BufferSize.automatic(), OfflineSorter.defaultTempDir(), 128);
    }

    public OfflineSorter(Comparator<BytesRef> comparator, BufferSize ramBufferSize, File tempDirectory, int maxTempfiles) {
        if ((long)ramBufferSize.bytes < 524288L) {
            throw new IllegalArgumentException("At least 0.5MB RAM buffer is needed: " + ramBufferSize.bytes);
        }
        if (maxTempfiles < 2) {
            throw new IllegalArgumentException("maxTempFiles must be >= 2");
        }
        this.ramBufferSize = ramBufferSize;
        this.tempDirectory = tempDirectory;
        this.maxTempFiles = maxTempfiles;
        this.comparator = comparator;
    }

    /*
     * Unable to fully structure code
     */
    public SortInfo sort(File input, File output) throws IOException {
        block44: {
            block43: {
                this.sortInfo = new SortInfo();
                this.sortInfo.totalTime = System.currentTimeMillis();
                if (output.exists()) {
                    FileUtils.deleteQuietly((File)output);
                }
                merges = new ArrayList<File>();
                success3 = false;
                try {
                    block42: {
                        is = new ByteSequencesReader(input);
                        success = false;
                        try {
                            try {
                                lines = 0;
                                while ((lines = this.readPartition(is)) > 0) {
                                    block40: {
                                        block39: {
                                            merges.add(this.sortPartition(lines));
                                            ++this.sortInfo.tempMergeFiles;
                                            this.sortInfo.lines += lines;
                                            if (merges.size() != this.maxTempFiles) continue;
                                            intermediate = new File(this.tempDirectory + "/sort.intermediate");
                                            success2 = false;
                                            try {
                                                this.mergePartitions(merges, intermediate);
                                                success2 = true;
                                            }
                                            finally {
                                                if (!success2) break block39;
                                                ** for (f0 : merges)
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                if (!f0.exists()) continue;
                                                FileUtils.deleteQuietly((File)f0);
                                                continue;
lbl33:
                                                // 1 sources

                                                break block40;
                                            }
                                        }
                                        for (File f0 : merges) {
                                            try {
                                                FileUtils.deleteQuietly((File)f0);
                                            }
                                            catch (Exception v0) {}
                                        }
                                    }
                                    merges.clear();
                                    merges.add(intermediate);
                                    ++this.sortInfo.tempMergeFiles;
                                }
                                success = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (success) {
                                    IOUtils.close(new Closeable[]{is});
                                } else {
                                    IOUtils.closeWhileHandlingException(new Closeable[]{is});
                                }
                                break block42;
                            }
                        }
                        catch (Throwable var13_15) {
                            if (success) {
                                IOUtils.close(new Closeable[]{is});
                            } else {
                                IOUtils.closeWhileHandlingException(new Closeable[]{is});
                            }
                            throw var13_15;
                        }
                        if (success) {
                            IOUtils.close(new Closeable[]{is});
                        } else {
                            IOUtils.closeWhileHandlingException(new Closeable[]{is});
                        }
                    }
                    if (merges.size() == 1) {
                        single = (File)merges.get(0);
                        try {
                            FileUtils.moveFile((File)single, (File)output);
                        }
                        catch (IOException v1) {
                            FileUtils.copyFile((File)single, (File)output);
                        }
                        catch (UnsupportedOperationException v2) {
                            FileUtils.copyFile((File)single, (File)output);
                        }
                    } else {
                        this.mergePartitions(merges, output);
                    }
                    success3 = true;
                }
                finally {
                    if (!success3) break block43;
                    ** for (f0 : merges)
                }
lbl-1000:
                // 1 sources

                {
                    FileUtils.deleteQuietly((File)f0);
                    continue;
lbl89:
                    // 1 sources

                    break block44;
                }
            }
            for (File f0 : merges) {
                try {
                    FileUtils.deleteQuietly((File)f0);
                }
                catch (Exception v3) {}
            }
            try {
                FileUtils.deleteQuietly((File)output);
            }
            catch (Exception v4) {}
        }
        this.sortInfo.totalTime = System.currentTimeMillis() - this.sortInfo.totalTime;
        return this.sortInfo;
    }

    public static File defaultTempDir() throws IOException {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        if (tempDirPath == null) {
            throw new IOException("Java has no temporary folder property (java.io.tmpdir)?");
        }
        File tempDirectory = new File(tempDirPath);
        if (!tempDirectory.canWrite()) {
            throw new IOException("Java's temporary folder not present or writeable?: " + tempDirectory.getAbsolutePath());
        }
        return tempDirectory;
    }

    protected File sortPartition(int len) throws IOException {
        File file;
        BytesRefArray data = this.buffer;
        File tempFile = new File(this.tempDirectory + "/sort.partition");
        long start = System.currentTimeMillis();
        this.sortInfo.sortTime += System.currentTimeMillis() - start;
        ByteSequencesWriter out = new ByteSequencesWriter(tempFile);
        try {
            BytesRef spare;
            BytesRefIterator iter = this.buffer.iterator(this.comparator);
            while ((spare = iter.next()) != null) {
                assert (spare.length <= Short.MAX_VALUE);
                out.write(spare);
            }
            out.close();
            data.clear();
            file = tempFile;
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
        return file;
    }

    void mergePartitions(List<File> merges, File outputFile) throws IOException {
        long start = System.currentTimeMillis();
        ByteSequencesWriter out = new ByteSequencesWriter(outputFile);
        PriorityQueue<FileAndTop> queue = new PriorityQueue<FileAndTop>(merges.size()){

            @Override
            protected boolean lessThan(FileAndTop a, FileAndTop b) {
                return OfflineSorter.this.comparator.compare(a.current.get(), b.current.get()) < 0;
            }
        };
        Closeable[] streams = new ByteSequencesReader[merges.size()];
        try {
            FileAndTop top;
            int i = 0;
            while (i < merges.size()) {
                streams[i] = new ByteSequencesReader(merges.get(i));
                byte[] line = ((ByteSequencesReader)streams[i]).read();
                if (line != null) {
                    queue.insertWithOverflow(new FileAndTop(i, line));
                }
                ++i;
            }
            while ((top = (FileAndTop)queue.top()) != null) {
                out.write(top.current.bytes(), 0, top.current.length());
                if (!((ByteSequencesReader)streams[top.fd]).read(top.current)) {
                    queue.pop();
                    continue;
                }
                queue.updateTop();
            }
            this.sortInfo.mergeTime += System.currentTimeMillis() - start;
            ++this.sortInfo.mergeRounds;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.close(streams);
            }
            catch (Throwable throwable2) {
                IOUtils.close(out);
                throw throwable2;
            }
            IOUtils.close(out);
            throw throwable;
        }
        try {
            IOUtils.close(streams);
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    int readPartition(ByteSequencesReader reader) throws IOException {
        long start = System.currentTimeMillis();
        BytesRef scratch = new BytesRef();
        while ((scratch.bytes = reader.read()) != null) {
            scratch.length = scratch.bytes.length;
            this.buffer.append(scratch);
            if ((long)this.ramBufferSize.bytes < this.bufferBytesUsed.get()) break;
        }
        this.sortInfo.readTime += System.currentTimeMillis() - start;
        return this.buffer.size();
    }

    public Comparator<BytesRef> getComparator() {
        return this.comparator;
    }

    public static final class BufferSize {
        final int bytes;

        private BufferSize(long bytes) {
            if (bytes > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Buffer too large for Java (2047mb max): " + bytes);
            }
            if (bytes < 524288L) {
                throw new IllegalArgumentException("At least 0.5MB RAM buffer is needed: " + bytes);
            }
            this.bytes = (int)bytes;
        }

        public static BufferSize megabytes(long mb) {
            return new BufferSize(mb * 0x100000L);
        }

        public static BufferSize automatic() {
            Runtime rt = Runtime.getRuntime();
            long max = rt.maxMemory();
            long total = rt.totalMemory();
            long free = rt.freeMemory();
            long totalAvailableBytes = max - total + free;
            long sortBufferByteSize = free / 2L;
            if (sortBufferByteSize < 0x2000000L || totalAvailableBytes > 0x14000000L) {
                sortBufferByteSize = totalAvailableBytes / 2L > 0x2000000L ? totalAvailableBytes / 2L : Math.max(524288L, sortBufferByteSize);
            }
            return new BufferSize(Math.min(Integer.MAX_VALUE, sortBufferByteSize));
        }
    }

    public static class ByteSequencesReader
    implements Closeable {
        private final DataInput is;

        public ByteSequencesReader(File path) throws IOException {
            this(new DataInputStream(new BufferedInputStream(new FileInputStream(path))));
        }

        public ByteSequencesReader(DataInput is) {
            this.is = is;
        }

        public boolean read(BytesRefBuilder ref) throws IOException {
            short length;
            try {
                length = this.is.readShort();
            }
            catch (EOFException eOFException) {
                return false;
            }
            ref.grow(length);
            ref.setLength(length);
            this.is.readFully(ref.bytes(), 0, length);
            return true;
        }

        public byte[] read() throws IOException {
            short length;
            try {
                length = this.is.readShort();
            }
            catch (EOFException eOFException) {
                return null;
            }
            assert (length >= 0) : "Sanity: sequence length < 0: " + length;
            byte[] result = new byte[length];
            this.is.readFully(result);
            return result;
        }

        @Override
        public void close() throws IOException {
            if (this.is instanceof Closeable) {
                ((Closeable)((Object)this.is)).close();
            }
        }
    }

    public static class ByteSequencesWriter
    implements Closeable {
        private final DataOutput os;

        public ByteSequencesWriter(File path) throws IOException {
            this(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path))));
        }

        public ByteSequencesWriter(DataOutput os) {
            this.os = os;
        }

        public void write(BytesRef ref) throws IOException {
            assert (ref != null);
            this.write(ref.bytes, ref.offset, ref.length);
        }

        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            assert (bytes != null);
            assert (off >= 0 && off + len <= bytes.length);
            assert (len >= 0);
            if (len > Short.MAX_VALUE) {
                throw new IllegalArgumentException("len must be <= 32767; got " + len);
            }
            this.os.writeShort(len);
            this.os.write(bytes, off, len);
        }

        @Override
        public void close() throws IOException {
            if (this.os instanceof Closeable) {
                ((Closeable)((Object)this.os)).close();
            }
        }
    }

    static class FileAndTop {
        final int fd;
        final BytesRefBuilder current;

        FileAndTop(int fd, byte[] firstLine) {
            this.fd = fd;
            this.current = new BytesRefBuilder();
            this.current.copyBytes(firstLine, 0, firstLine.length);
        }
    }

    public class SortInfo {
        public int tempMergeFiles;
        public int mergeRounds;
        public int lines;
        public long mergeTime;
        public long sortTime;
        public long totalTime;
        public long readTime;
        public final long bufferSize;

        public SortInfo() {
            this.bufferSize = ((OfflineSorter)OfflineSorter.this).ramBufferSize.bytes;
        }

        public String toString() {
            return String.format(Locale.ROOT, "time=%.2f sec. total (%.2f reading, %.2f sorting, %.2f merging), lines=%d, temp files=%d, merges=%d, soft ram limit=%.2f MB", (double)this.totalTime / 1000.0, (double)this.readTime / 1000.0, (double)this.sortTime / 1000.0, (double)this.mergeTime / 1000.0, this.lines, this.tempMergeFiles, this.mergeRounds, (double)this.bufferSize / 1048576.0);
        }
    }
}

