/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template.completion;

import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.DList;
import ca.infodata.ofys.client.modules.template.DRaw;
import ca.infodata.ofys.client.modules.template.TemplateDefinitionParser;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.controls.template.TemplateAssistTextDialog;
import ca.infodata.ofys.ui.controls.textAssistant.CompletionProposition;
import ca.infodata.ofys.ui.controls.webbrowser.AdvancedBrowser;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.JoinList;
import java.util.ArrayList;
import java.util.List;

public class TemplateProposition
extends CompletionProposition<XTemplate> {
    private TemplateAccessorClient accessor;
    private TemplateDefinitionParser parser;

    public TemplateProposition(XTemplate data, TemplateAccessorClient accessor) {
        super(data);
        this.accessor = accessor;
        this.parser = new TemplateDefinitionParser();
    }

    public String getAdditionalProposalInfo() {
        if (((XTemplate)this.data).getText() == null) {
            ((XTemplate)this.data).setText(this.accessor.getText(((XTemplate)this.data).getId()));
        }
        String text = ((XTemplate)this.data).getText();
        List fields = this.parser.parse(text);
        String s = "";
        ArrayList<DField> choices = new ArrayList<DField>();
        for (DField f : fields) {
            if (f instanceof DRaw) {
                s = String.valueOf(s) + ((DRaw)f).raw;
                continue;
            }
            s = String.valueOf(s) + "[" + f.name + "]";
            choices.add(f);
        }
        if (choices.size() > 0) {
            s = String.valueOf(s) + "\nChoix possibles \n\n";
            for (DField c : choices) {
                s = String.valueOf(s) + c.getClass().getSimpleName().substring(1);
                s = String.valueOf(s) + " - " + c.name;
                if (c instanceof DList) {
                    s = String.valueOf(s) + "\n\t" + new JoinList("; ", (Object[])((DList)c).items);
                }
                s = String.valueOf(s) + "\n";
            }
        }
        return s;
    }

    public String getDisplayString() {
        return ((XTemplate)this.data).getName();
    }

    private boolean containsNonRaw(List<DField> fields) {
        for (DField f : fields) {
            if (f instanceof DRaw) continue;
            return true;
        }
        return false;
    }

    public String getWriteString() {
        String text = ((XTemplate)this.data).getText();
        if (Boolean.TRUE.equals(((XTemplate)this.data).getIsHtml())) {
            AdvancedBrowser browser = new AdvancedBrowser(UI.getWorkbenchShell(), text);
            browser.open();
            if (browser.isOkPressed()) {
                text = browser.getHtml();
            }
        } else {
            TemplateDefinitionParser parser = new TemplateDefinitionParser();
            List fields = parser.parse(text);
            if (this.containsNonRaw(fields)) {
                String s;
                TemplateAssistTextDialog dialog = new TemplateAssistTextDialog(UI.getWorkbenchShell(), ((XTemplate)this.data).getName(), fields);
                int r = dialog.buildAndOpen();
                text = r == 0 ? (s = dialog.getWriteText()) : "";
            }
        }
        if (text != null) {
            this.accessor.use(((XTemplate)this.data).getId());
        }
        return text;
    }
}

