/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.report2.properties;

import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.properties.BooleanProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.ChoiceProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.IReportProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.IntegerProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.LocalDateProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.StringProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.TimeProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.NumberOfCopiesProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.Orientation;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PageFormat2;
import ca.infodata.ofys.ui.controls.FontAwareButton;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareLabel;
import ca.infodata.ofys.ui.controls.FontAwareSpinner;
import ca.infodata.ofys.ui.controls.FontAwareText;
import ca.infodata.ofys.ui.controls.TimeText;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.report2.properties.LabeledPropertyControl;
import ca.infodata.ofys.ui.controls.report2.properties.SingleReportPropertiesController;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.pdf.PrintPdfX;
import ca.infodata.util1.ClosureA;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SingleReportPropertiesComposite
extends Composite {
    private static final String PAR_DEFAUT = Messages.getString((String)"SingleReportPropertiesComposite.PAR_DEFAUT", (String[])new String[0]);
    private static final String ERREUR_IMPRIMANTE = Messages.getString((String)"SingleReportPropertiesComposite.ERREUR_IMPRIMANTE", (String[])new String[0]);
    private static final String MISE_EN_PAGE = Messages.getString((String)"SingleReportPropertiesComposite.MISE_EN_PAGE", (String[])new String[0]);
    private static final String PARAMETRES_D_IMPRIMANTE = Messages.getString((String)"SingleReportPropertiesComposite.PARAMETRES_D_IMPRIMANTE", (String[])new String[0]);
    private FormToolkit toolkit;
    private FontAwareLabel part1Label;
    private ScrolledComposite part1;
    private Composite part1Content;
    private FontAwareComposite part2;
    private MyCombo<String> printerChoiceCombo;
    private SingleReportPropertiesController controller;
    private LabeledPropertyControl<NumberOfCopiesProperty> numberOfCopiesControl;
    private FontAwareLabel labelPageFormat;
    private FontAwareButton buttonPageFormat;
    private boolean printerParameterEnabled;

    public SingleReportPropertiesComposite(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        this.toolkit = toolkit;
        this.toolkit.adapt((Composite)this);
        this.part1Label = new FontAwareLabel((Composite)this, 0x1000040, "", toolkit);
        this.part1Label.setFont(0, 1);
        this.part1Label.setVisible(false);
        this.part1 = new ScrolledComposite((Composite)this, 512);
        this.part1.setBackground(toolkit.getColors().getBackground());
        this.part1.setExpandHorizontal(true);
        this.part1.getVerticalBar().setIncrement(5);
        this.part1.getVerticalBar().setMinimum(0);
        this.part1.getVerticalBar().setMaximum(0);
        this.part2 = new FontAwareComposite(this, 0);
        this.part2.setBackground(toolkit.getColors().getBackground());
        this.part2.setVisible(false);
        FormLayout part2Layout = new FormLayout();
        part2Layout.marginTop = 5;
        part2Layout.marginBottom = 10;
        part2Layout.marginWidth = 5;
        part2Layout.spacing = 5;
        this.part2.setLayout((Layout)part2Layout);
        FontAwareLabel labelPrinterSection = new FontAwareLabel((Composite)this.part2, 0x1000040, PARAMETRES_D_IMPRIMANTE, toolkit);
        labelPrinterSection.setFont(0, 1);
        this.newRow((Control)labelPrinterSection, null, true);
        this.numberOfCopiesControl = this.createIntegerRow(this.part2, new NumberOfCopiesProperty(Integer.valueOf(1)));
        this.newRow((Control)this.numberOfCopiesControl, (Control)labelPrinterSection, false);
        FormData data = (FormData)this.numberOfCopiesControl.getLayoutData();
        data.top = new FormAttachment((Control)labelPrinterSection, 10);
        Control printerChoiceControl = this.createPrinterChoiceRow(this.part2);
        this.newRow(printerChoiceControl, (Control)this.numberOfCopiesControl, true);
        Control pageFormatRow = this.createPageFormatRow(this.part2);
        this.newRow(pageFormatRow, printerChoiceControl, false);
        FormLayout layout = new FormLayout();
        layout.marginTop = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 5;
        this.setLayout((Layout)layout);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.part1Label.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.part1Label);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment((Control)this.part2);
        this.part1.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, 0);
        this.part2.setLayoutData(data);
    }

    private Control createPageFormatRow(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setBackground(this.toolkit.getColors().getBackground());
        this.buttonPageFormat = new FontAwareButton(main, 8);
        this.buttonPageFormat.setBackground(this.toolkit.getColors().getBackground());
        this.buttonPageFormat.setText(MISE_EN_PAGE);
        this.labelPageFormat = new FontAwareLabel(main, 16448);
        this.labelPageFormat.setFont(0, 0);
        this.labelPageFormat.setBackground(this.toolkit.getColors().getBackground());
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 0;
        main.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0, UI.getAjustedPosition() - 1);
        this.buttonPageFormat.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.buttonPageFormat, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.buttonPageFormat, 5);
        data.width = 225;
        this.labelPageFormat.setLayoutData(data);
        this.buttonPageFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleReportPropertiesComposite.this.openPageFormatDialog();
            }
        });
        return main;
    }

    private boolean tryQueryPrinter(String printer) {
        boolean tryQueryPrinter = true;
        try {
            this.labelPageFormat.setForeground(this.toolkit.getColors().getForeground());
            this.labelPageFormat.setText("Connexion \u00e0 l'imprimante ...");
            Throwable throwable = this.controller.tryQueryPrinter(printer).get(5L, TimeUnit.SECONDS);
            if (throwable != null) {
                throw new ExecutionException(throwable);
            }
            this.buttonPageFormat.setEnabled(true);
        }
        catch (Exception exception) {
            this.buttonPageFormat.setEnabled(false);
            this.labelPageFormat.setForeground(ResourceGetter.getRedWarningColor());
            this.labelPageFormat.setText("\u00c9chec de connexion \u00e0 l'imprimante ...");
            tryQueryPrinter = false;
        }
        return tryQueryPrinter;
    }

    private void updateLabelPageFormatControl(String printer) {
        this.updateLabelPageFormatControl(printer, true);
    }

    private void updateLabelPageFormatControl(String printer, Boolean tryQueryPrinterResult) {
        if (this.controller != null) {
            if (printer == null) {
                printer = this.controller.getReportOrDefaultPrinter();
            }
            if (tryQueryPrinterResult == null) {
                tryQueryPrinterResult = this.tryQueryPrinter(printer);
            }
            if (tryQueryPrinterResult.booleanValue()) {
                String text;
                this.buttonPageFormat.setEnabled(true);
                PageFormat2 pf = this.controller.getReportPageFormat2(false);
                if (pf == null) {
                    pf = this.controller.getDefaultPageFormat2();
                    text = String.valueOf(this.getPageFormatText(pf)) + " " + PAR_DEFAUT;
                } else {
                    text = this.getPageFormatText(pf);
                }
                this.labelPageFormat.setText(text);
                this.labelPageFormat.setForeground(this.toolkit.getColors().getForeground());
            }
        } else {
            this.buttonPageFormat.setEnabled(false);
            this.labelPageFormat.setText("");
        }
    }

    protected String getPageFormatText(PageFormat2 pf) {
        if (pf == null) {
            return "";
        }
        JoinList list = new JoinList(", ");
        list.add((CharSequence)pf.name);
        double cfr_ignored_0 = pf.height;
        double cfr_ignored_1 = pf.imageableHeight;
        double cfr_ignored_2 = pf.imageableY;
        double cfr_ignored_3 = pf.imageableY;
        double cfr_ignored_4 = pf.imageableX;
        double cfr_ignored_5 = pf.width;
        double cfr_ignored_6 = pf.imageableWidth;
        double cfr_ignored_7 = pf.imageableX;
        if (pf.orientation == Orientation.PORTRAIT) {
            list.add((CharSequence)"Portrait");
        }
        if (pf.orientation == Orientation.LANDSCAPE) {
            list.add((CharSequence)"Paysage");
        }
        return list.toString();
    }

    protected void openPageFormatDialog() {
        final String printer = this.controller.getReportOrDefaultPrinter();
        if (printer != null) {
            try {
                PageFormat pageFormat = this.controller.getReportPageFormat();
                PrintPdfX.openPageFormatDialog((String)printer, (PageFormat)pageFormat, (ClosureA)new ClosureA<PageFormat>(){

                    public void execute(final PageFormat pageFormat) {
                        SingleReportPropertiesComposite.this.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    SingleReportPropertiesComposite.this.controller.setReportPageFormat(pageFormat);
                                    SingleReportPropertiesComposite.this.controller.savePreferences();
                                    SingleReportPropertiesComposite.this.updateLabelPageFormatControl(printer);
                                }
                                catch (PrinterException e) {
                                    MessageUtil.show((Shell)SingleReportPropertiesComposite.this.getShell(), (Exception)e);
                                }
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                MessageUtil.show((Shell)this.getShell(), (Exception)e);
            }
        }
    }

    private void updateNumberOfCopiesControl() {
        if (this.controller == null || this.controller.getReport() == null) {
            this.numberOfCopiesControl.setProperty(new NumberOfCopiesProperty(Integer.valueOf(1)));
            this.numberOfCopiesControl.getOtherControl().setEnabled(false);
        } else {
            this.numberOfCopiesControl.getOtherControl().setEnabled(true);
            Number n = (Number)this.controller.getValue("numberofcopies", 1);
            this.numberOfCopiesControl.setProperty(new NumberOfCopiesProperty(Integer.valueOf(n.intValue())));
        }
    }

    public void setController(SingleReportPropertiesController controller) {
        if (this.controller == null || controller == null || !this.controller.getReport().equals(controller.getReport())) {
            this.controller = controller;
            this.createControls();
        }
    }

    private void createControls() {
        if (this.part1Content != null) {
            this.part1Content.dispose();
        }
        this.part1Content = new Composite((Composite)this.part1, 0);
        this.part1Content.setBackground(this.toolkit.getColors().getBackground());
        this.part1Content.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                SingleReportPropertiesComposite.this.part1Content.setFocus();
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.spacing = 5;
        this.part1Content.setLayout((Layout)layout);
        Control previous = null;
        if (this.controller != null && this.controller.getReport() != null) {
            this.part1Label.setText(this.controller.getReport().getName());
            this.part1Label.setVisible(true);
            for (IReportProperty property : this.controller.getReport().getProperties()) {
                Object control = null;
                if (!property.isDisplayable() || "output".equals(property.name()) || "printer".equals(property.name()) || "numberofcopies".equals(property.name()) || "setpdfmarginsto0".equals(property.name())) continue;
                if (property instanceof BooleanProperty) {
                    control = this.createBooleanRow(this.part1Content, (BooleanProperty)property);
                    this.newRow((Control)control, previous, true);
                    previous = control;
                    continue;
                }
                if (property instanceof StringProperty) {
                    control = this.createStringRow(this.part1Content, (StringProperty)property);
                    this.newRow((Control)control, previous, true);
                    previous = control;
                    continue;
                }
                if (property instanceof TimeProperty) {
                    control = this.createTimeRow(this.part1Content, (TimeProperty)property);
                    this.newRow((Control)control, previous, false);
                    previous = control;
                    continue;
                }
                if (property instanceof IntegerProperty) {
                    control = this.createIntegerRow(this.part1Content, (IntegerProperty)property);
                    this.newRow((Control)control, previous, false);
                    previous = control;
                    continue;
                }
                if (property instanceof LocalDateProperty) {
                    control = this.createLocalDateRow(this.part1Content, (LocalDateProperty)property);
                    this.newRow((Control)control, previous, true);
                    previous = control;
                    continue;
                }
                if (!(property instanceof ChoiceProperty)) continue;
                control = this.createChoiceRow(this.part1Content, (ChoiceProperty)property);
                this.newRow((Control)control, previous, false);
                previous = control;
            }
        } else {
            this.part1Label.setVisible(false);
        }
        this.part1Content.pack();
        this.part1Content.setSize(this.part1Content.getBounds().width, this.part1Content.getBounds().height + 20);
        this.part1.setContent((Control)this.part1Content);
        this.updateNumberOfCopiesControl();
        this.updatePrinterChoiceCombo();
        this.updateLabelPageFormatControl(null);
        this.setPart2Visible(this.isPart2ShouldBeVisible());
    }

    private void newRow(Control control, Control previous, boolean fillRight) {
        FormData data = new FormData();
        data.top = previous != null ? new FormAttachment(previous) : new FormAttachment(0);
        data.left = new FormAttachment(0);
        if (fillRight) {
            data.right = new FormAttachment(100);
        }
        control.setLayoutData((Object)data);
    }

    private Control createLocalDateRow(Composite main, LocalDateProperty property) {
        LabeledPropertyControl<LocalDateProperty> control = new LabeledPropertyControl<LocalDateProperty>(main, this.toolkit, property){

            @Override
            protected Control createOtherControls() {
                MyCalendarText text = new MyCalendarText((Composite)this, this.toolkit);
                text.setDate((IPartialDate)((LocalDateProperty)this.property).value());
                text.setData("property", this.property);
                text.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        String value = ((Text)e.widget).getText().trim();
                        IReportProperty property = (IReportProperty)e.widget.getData("property");
                        SingleReportPropertiesComposite.this.setPropertyValue(property, value);
                    }
                });
                return text;
            }
        };
        return control;
    }

    private Control createTimeRow(Composite main, TimeProperty property) {
        LabeledPropertyControl<TimeProperty> control = new LabeledPropertyControl<TimeProperty>(main, this.toolkit, property){

            @Override
            protected Control createOtherControls() {
                final TimeText text = new TimeText(this, 2048, this.toolkit);
                text.setTime((Integer)((TimeProperty)this.property).value());
                text.setData("property", this.property);
                text.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        Integer value = text.getTime();
                        IReportProperty property = (IReportProperty)e.widget.getData("property");
                        SingleReportPropertiesComposite.this.setPropertyValue(property, value);
                    }
                });
                return text.getControl();
            }
        };
        return control;
    }

    protected <T> void setPropertyValue(IReportProperty<T> property, T value) {
        this.controller.set(property, value);
        this.controller.savePreferences();
    }

    private <T extends IntegerProperty> LabeledPropertyControl<T> createIntegerRow(Composite main, T property) {
        LabeledPropertyControl<IntegerProperty> control = new LabeledPropertyControl<IntegerProperty>(main, this.toolkit, property){
            private Spinner spinner;

            @Override
            protected Control createOtherControls() {
                this.spinner = new FontAwareSpinner(this, 2048);
                this.spinner.setBackground(this.toolkit.getColors().getBackground());
                this.spinner.setIncrement(1);
                this.spinner.setMinimum(1);
                this.spinner.setSelection(((Integer)((IntegerProperty)this.property).value()).intValue());
                this.spinner.setData("property", (Object)this.property);
                this.spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int value = ((Spinner)e.widget).getSelection();
                        IReportProperty property = (IReportProperty)e.widget.getData("property");
                        SingleReportPropertiesComposite.this.setPropertyValue(property, value);
                    }
                });
                return this.spinner;
            }

            @Override
            protected void refresh() {
                this.spinner.setSelection(((Integer)((IntegerProperty)this.property).value()).intValue());
            }
        };
        return control;
    }

    private Control createPrinterChoiceRow(Composite main) {
        this.printerChoiceCombo = new MyCombo(main, 8, this.toolkit);
        this.printerChoiceCombo.setLabelProvider(new ProviderAR<String, String>(){

            public String get(String printer) {
                String text = printer;
                if (printer != null) {
                    if (printer.equals(SingleReportPropertiesComposite.this.controller.getDefaultPrinter())) {
                        text = String.valueOf(text) + " " + PAR_DEFAUT;
                    }
                    if (printer.equals(SingleReportPropertiesComposite.this.controller.getReportPrinter())) {
                        text = String.valueOf(text) + " *";
                    }
                } else {
                    text = "";
                }
                return text;
            }
        });
        this.updatePrinterChoiceCombo();
        this.printerChoiceCombo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (SingleReportPropertiesComposite.this.controller != null) {
                    String printer = (String)SingleReportPropertiesComposite.this.printerChoiceCombo.getSelection();
                    Boolean tryQueryPrinterResult = null;
                    try {
                        tryQueryPrinterResult = SingleReportPropertiesComposite.this.tryQueryPrinter(printer);
                        if (tryQueryPrinterResult.booleanValue()) {
                            SingleReportPropertiesComposite.this.controller.setPrinter(printer);
                            SingleReportPropertiesComposite.this.controller.savePreferences();
                            SingleReportPropertiesComposite.this.updateLabelPageFormatControl(printer, tryQueryPrinterResult);
                        }
                    }
                    catch (Exception exception) {
                        SingleReportPropertiesComposite.this.updateLabelPageFormatControl(printer, tryQueryPrinterResult);
                    }
                } else {
                    SingleReportPropertiesComposite.this.updateLabelPageFormatControl(null, null);
                }
            }
        });
        return this.printerChoiceCombo.getControl();
    }

    private void updatePrinterChoiceCombo() {
        if (this.controller != null) {
            this.printerChoiceCombo.setItems((String[])this.controller.getPrinterList());
            String printer = this.controller.getReportOrDefaultPrinter();
            if (this.printerChoiceCombo.contains(printer)) {
                this.printerChoiceCombo.selectNoNotify(printer);
                this.printerChoiceCombo.getControl().setBackground(this.toolkit.getColors().getBackground());
            } else {
                this.printerChoiceCombo.add(printer);
                this.printerChoiceCombo.selectNoNotify(printer);
            }
        } else {
            this.printerChoiceCombo.setItems((String[])new String[0]);
            this.printerChoiceCombo.selectNone();
        }
    }

    private Control createChoiceRow(Composite main, ChoiceProperty<?> property) {
        LabeledPropertyControl control = new LabeledPropertyControl<ChoiceProperty<?>>(main, this.toolkit, property){

            @Override
            protected Control createOtherControls() {
                MyCombo<Object> combo = new MyCombo<Object>(this, 8, this.toolkit);
                combo.setItems(((ChoiceProperty)this.property).choices());
                combo.select(((ChoiceProperty)this.property).value());
                combo.getControl().setData("wrapper", combo);
                combo.getControl().setData("property", (Object)this.property);
                combo.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        Object value = ((MyCombo)e.widget.getData("wrapper")).getSelection();
                        IReportProperty property = (IReportProperty)e.widget.getData("property");
                        SingleReportPropertiesComposite.this.setPropertyValue(property, value);
                    }
                });
                return combo.getControl();
            }
        };
        return control;
    }

    private Control createStringRow(Composite main, StringProperty property) {
        LabeledPropertyControl<StringProperty> control = new LabeledPropertyControl<StringProperty>(main, this.toolkit, property){

            @Override
            protected Control createOtherControls() {
                FontAwareText text = new FontAwareText(this, 18436);
                text.setBackground(this.toolkit.getColors().getBackground());
                text.setText(StringUtils.defaultString((String)((String)((StringProperty)this.property).value())));
                text.setData("property", this.property);
                text.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        String value = ((Text)e.widget).getText().trim();
                        IReportProperty property = (IReportProperty)e.widget.getData("property");
                        SingleReportPropertiesComposite.this.setPropertyValue(property, value);
                    }
                });
                return text;
            }
        };
        return control;
    }

    private Control createBooleanRow(Composite main, BooleanProperty property) {
        FontAwareButton button = new FontAwareButton(main, 32);
        button.setBackground(this.toolkit.getColors().getBackground());
        button.setText(property.displayName());
        button.setToolTipText(property.name());
        button.setSelection(property.value() == null ? false : (Boolean)property.value());
        button.setData("property", property);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Boolean value = ((Button)e.widget).getSelection();
                IReportProperty property = (IReportProperty)e.widget.getData("property");
                SingleReportPropertiesComposite.this.setPropertyValue(property, value);
            }
        });
        return button;
    }

    private boolean isPart2ShouldBeVisible() {
        return this.printerParameterEnabled && this.controller != null && this.controller.getReport() != null;
    }

    private void setPart2Visible(boolean b) {
        if (b) {
            FormData data = (FormData)this.part1.getLayoutData();
            data.bottom = new FormAttachment((Control)this.part2);
            this.part1.getParent().layout(true);
            this.part2.setVisible(true);
        } else {
            this.part2.setVisible(false);
            FormData data = (FormData)this.part1.getLayoutData();
            data.bottom = new FormAttachment(100);
            this.part1.getParent().layout(true);
        }
    }

    public void setPrinterParameterEnable(boolean b) {
        this.printerParameterEnabled = b;
        this.setPart2Visible(this.isPart2ShouldBeVisible());
    }
}

