/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.report2;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.FontAwareButton;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareLabel;
import ca.infodata.ofys.ui.controls.FontAwareLink;
import ca.infodata.ofys.ui.controls.FontAwareShell;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.ProgressMonitor2Composite;
import ca.infodata.ofys.ui.controls.report2.PrintController;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2Tool;
import ca.infodata.ofys.ui.controls.report2.PrintTree;
import ca.infodata.ofys.ui.controls.report2.PrintTreeContentProvider;
import ca.infodata.ofys.ui.controls.report2.properties.SingleReportPropertiesComposite;
import ca.infodata.ofys.ui.controls.report2.properties.SingleReportPropertiesController;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import java.io.Serializable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PrintDialog2 {
    protected static final String SELECTED_REPORT_ID_PREF = "selected_report_id";
    protected static final String IMPRESSION = Messages.getString((String)"IMPRESSION", (String[])new String[0]);
    private static final String SORTIR_EN_PDF = Messages.getString((String)"SORTIR_EN_PDF", (String[])new String[0]);
    private static final String IMPRIMER = Messages.getString((String)"IMPRIMER", (String[])new String[0]);
    private static final String ANNULER = Messages.getString((String)"ANNULER", (String[])new String[0]);
    private static final String RPD_EXPLICATION = Messages.getString((String)"PrintDialog2.RPD_EXPLICATION", (String[])new String[0]);
    protected final PrintController controller;
    protected final FontAwareShell shell;
    private Listener keyDownListener;
    private ProgressMonitor2Composite progressMonitor2Composite;
    private SingleReportPropertiesComposite propertiesComposite;
    private FormToolkit toolkit;

    public PrintDialog2(Shell parent, Serializable dataObject) {
        this(parent, new PrintController(dataObject, null));
    }

    public PrintDialog2(Shell parent, Serializable dataObject, String keyContext) {
        this(parent, new PrintController(dataObject, keyContext));
    }

    public PrintDialog2(Shell parent, Serializable dataObject, String keyContext, String localFileName) {
        this(parent, new PrintController(dataObject, keyContext, localFileName));
    }

    public PrintDialog2(Shell parent, PrintController controller) {
        this.controller = controller;
        this.shell = new FontAwareShell(parent, 67696);
        this.shell.setText(IMPRESSION);
        this.toolkit = UI.createToolKit((Widget)this.shell);
        this.progressMonitor2Composite = new ProgressMonitor2Composite((Composite)this.shell, 0, this.toolkit){

            @Override
            protected FontAwareComposite createLoadedComposite(Composite parent, FormToolkit toolkit) {
                FontAwareComposite parent2 = new FontAwareComposite(parent, 0);
                final PrintTree tree = new PrintTree(parent2, 0, toolkit);
                tree.setController(PrintDialog2.this.controller);
                PrintDialog2.this.propertiesComposite = new SingleReportPropertiesComposite(parent2, 2048, toolkit);
                PrintDialog2.this.propertiesComposite.setPrinterParameterEnable(!PrintDialog2.this.controller.getShowInPdf());
                tree.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        Object e;
                        ISelection selection = event.getSelection();
                        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (e = ((IStructuredSelection)selection).iterator().next()) instanceof PrintTreeContentProvider.ReportItem) {
                            SingleReportPropertiesController propertiesController = new SingleReportPropertiesController(((PrintTreeContentProvider.ReportItem)e).report, (this).PrintDialog2.this.controller);
                            PrintDialog2.this.propertiesComposite.setController(propertiesController);
                            this.saveReportSelectionPreferences((PrintTreeContentProvider.ReportItem)e);
                            return;
                        }
                        PrintDialog2.this.propertiesComposite.setController(null);
                    }

                    private void saveReportSelectionPreferences(PrintTreeContentProvider.ReportItem item) {
                        (this).PrintDialog2.this.controller.setGlobalPreference(PrintDialog2.SELECTED_REPORT_ID_PREF, item.id);
                        (this).PrintDialog2.this.controller.savePreferences();
                    }
                });
                tree.setSelectionByReportId(PrintDialog2.this.controller.getGlobalPreference(PrintDialog2.SELECTED_REPORT_ID_PREF));
                tree.getTreeViewer().getControl().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent e) {
                        tree.getTreeViewer().getTree().setFocus();
                    }
                });
                FormLayout layout = new FormLayout();
                layout.spacing = 5;
                parent2.setLayout((Layout)layout);
                FormData data = new FormData();
                data.top = new FormAttachment(0);
                data.left = new FormAttachment(0);
                data.right = new FormAttachment(50);
                data.bottom = new FormAttachment(100);
                tree.getTreeViewer().getControl().setLayoutData((Object)data);
                data = new FormData();
                data.top = new FormAttachment(0);
                data.left = new FormAttachment(tree.getTreeViewer().getControl());
                data.right = new FormAttachment(100);
                data.bottom = new FormAttachment(100);
                PrintDialog2.this.propertiesComposite.setLayoutData(data);
                return parent2;
            }
        };
        final FontAwareButton chkPrintToPdf = new FontAwareButton((Composite)this.shell, 32);
        chkPrintToPdf.setFont(1, 0);
        chkPrintToPdf.setSelection(controller.getShowInPdf());
        chkPrintToPdf.setText(SORTIR_EN_PDF);
        chkPrintToPdf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = chkPrintToPdf.getSelection();
                PrintDialog2.this.controller.setShowInPdf(selection);
                if (PrintDialog2.this.propertiesComposite != null) {
                    PrintDialog2.this.propertiesComposite.setPrinterParameterEnable(!selection);
                }
            }
        });
        FontAwareButton btnPrint = new FontAwareButton((Composite)this.shell, 8);
        btnPrint.setFont(1, 0);
        btnPrint.setBackground(this.toolkit.getColors().getBackground());
        btnPrint.setText(IMPRIMER);
        btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Application.get().getGlobalInstances().inDebugMode()) {
                    MyMessageDialogBuilder dialog = new MyMessageDialogBuilder();
                    dialog.useWarningBundle();
                    dialog.setButtonLabels("Je veux le XML", "Je veux le PDF");
                    dialog.setMessage("Quel format de sortie voulez-vous ?");
                    dialog.setDefaultButton(1);
                    dialog.setParent(PrintDialog2.this.getShell());
                    int r = dialog.buildAndOpen();
                    if (r == 0) {
                        PrintDialog2.this.onPrintXml();
                    } else {
                        PrintDialog2.this.onPrint();
                    }
                } else {
                    PrintDialog2.this.onPrint();
                }
            }
        });
        FontAwareButton btnCancel = new FontAwareButton((Composite)this.shell, 8);
        btnCancel.setFont(1, 0);
        btnCancel.setBackground(this.toolkit.getColors().getBackground());
        btnCancel.setText(ANNULER);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrintDialog2.this.onCancel();
            }
        });
        FontAwareButton btnTool = new FontAwareButton((Composite)this.shell, 8);
        btnTool.setFont(1, 0);
        btnTool.setBackground(this.toolkit.getColors().getBackground());
        btnTool.setImage(ResourceGetter.getImage((String)"images/prop_general.gif"));
        btnTool.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrintDialog2.this.onTool();
            }
        });
        FontAwareLink lblPatientConsent = new FontAwareLink((Composite)this.shell, 64);
        lblPatientConsent.setText("<a href=\"_blank\">" + Messages.getString((String)"PrintDialog2.CONSENTEMENT_LINE", (String[])new String[0]) + "</a>");
        lblPatientConsent.setFont(1, 3);
        lblPatientConsent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        FontAwareLabel lblRDP = new FontAwareLabel((Composite)this.shell, 16384);
        lblRDP.setText("RDP " + controller.getRdpClientName());
        lblRDP.setFont(0, 2);
        lblRDP.setToolTipText(RPD_EXPLICATION);
        lblRDP.setVisible(controller.isRdpSession());
        FormLayout layout = new FormLayout();
        layout.marginWidth = 5;
        layout.marginTop = 5;
        layout.marginBottom = 7;
        layout.spacing = 5;
        this.shell.setLayout((Layout)layout);
        FormData data = new FormData();
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        data.width = Math.max(130, btnCancel.computeSize((int)-1, (int)-1).x);
        btnCancel.setLayoutData(data);
        data = new FormData();
        data.right = new FormAttachment((Control)btnCancel);
        data.bottom = new FormAttachment(100);
        data.width = Math.max(130, btnPrint.computeSize((int)-1, (int)-1).x);
        btnPrint.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)btnPrint, 0, 0x1000000);
        data.right = new FormAttachment((Control)btnPrint, -10);
        chkPrintToPdf.setLayoutData(data);
        data = new FormData();
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        btnTool.setLayoutData(data);
        data = new FormData();
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment((Control)btnTool);
        lblRDP.setLayoutData(data);
        data = new FormData();
        data.bottom = new FormAttachment((Control)btnCancel, -10);
        data.left = new FormAttachment(0, 5);
        lblPatientConsent.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment((Control)lblPatientConsent, -5);
        this.progressMonitor2Composite.setLayoutData(data);
        this.shell.pack();
        ((FormData)lblPatientConsent.getLayoutData()).width = this.shell.getSize().x - 125;
        this.keyDownListener = new Listener(){

            public void handleEvent(Event e) {
                if (!PrintDialog2.this.shell.isDisposed() && PrintDialog2.this.shell.getDisplay().getActiveShell() == PrintDialog2.this.shell) {
                    if (UI.CR((Event)e)) {
                        PrintDialog2.this.onPrint();
                    }
                    if (UI.ESC((Event)e)) {
                        PrintDialog2.this.onCancel();
                    }
                }
            }
        };
        this.shell.getDisplay().addFilter(1, this.keyDownListener);
    }

    protected void onTool() {
        PrintDialog2Tool dialog = new PrintDialog2Tool(this.shell, this.toolkit, this.controller);
        boolean dirty = dialog.open();
        if (dirty) {
            this.shell.close();
        }
    }

    protected void onCancel() {
        this.shell.close();
    }

    protected void onPrint() {
        try {
            this.controller.print();
            this.shell.close();
        }
        catch (Exception e) {
            MessageUtil.show((Shell)this.getShell(), (Exception)e);
        }
    }

    protected void onPrintXml() {
        try {
            this.controller.printXml();
            this.shell.close();
        }
        catch (Exception e) {
            MessageUtil.show((Shell)this.getShell(), (Exception)e);
        }
    }

    public void open() {
        this.shell.pack();
        this.shell.setSize(700, 500);
        UI.centerComposite((Composite)this.shell, (Composite)this.shell.getParent());
        this.shell.open();
        this.progressMonitor2Composite.showLoadingComposite();
        this.controller.loadReports(this.progressMonitor2Composite.getProgressMonitor());
    }

    public PrintController getController() {
        return this.controller;
    }

    public FontAwareShell getShell() {
        return this.shell;
    }
}

