/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.handlers;

import ca.infodata.ofys.ui.controls.ICancelablePart;
import ca.infodata.ofys.ui.controls.IDeleteablePart;
import ca.infodata.ofys.ui.controls.IPrintable;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;

class EditorStateEditionTracker
implements IPartListener,
IWindowListener,
IPropertyListener {
    private final IWorkbench workbench = PlatformUI.getWorkbench();

    public EditorStateEditionTracker() {
        this.workbench.addWindowListener((IWindowListener)this);
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        this.register(window);
    }

    public void update() {
        IEvaluationService service = (IEvaluationService)this.workbench.getService(IEvaluationService.class);
        service.requestEvaluation("activePart");
    }

    private void register(IWorkbenchWindow window) {
        if (window == null) {
            return;
        }
        window.getPartService().addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.shouldTrack(part)) {
            part.addPropertyListener((IPropertyListener)this);
        }
    }

    protected boolean shouldTrack(Object source) {
        return source instanceof ISaveablePart || source instanceof IDeleteablePart || source instanceof ICancelablePart || source instanceof IPrintable;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (this.shouldTrack(part)) {
            part.removePropertyListener((IPropertyListener)this);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (this.shouldTrack(part)) {
            part.addPropertyListener((IPropertyListener)this);
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.register(window);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.register(window);
    }

    public void propertyChanged(Object source, int propID) {
        if ((propID == 257 || propID == 257) && this.shouldTrack(source)) {
            this.update();
        }
    }
}

