/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.handlers;

import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.ICancelablePart;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialog;
import ca.infodata.ofys.ui.controls.handlers.AbstractEditionHandler;
import ca.infodata.ofys.ui.controls.handlers.InternalHandlerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class CancelHandler
extends AbstractEditionHandler {
    private static final Logger logger = Logger.getLogger(CancelHandler.class.getName());

    public CancelHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent event) {
        final ICancelablePart part = this.getCancelablePart(event);
        if (part == null) {
            return null;
        }
        try {
            IEditorPart editorPart = (IEditorPart)part;
            MyMessageDialogBuilder builder = new MyMessageDialogBuilder();
            builder.useQuestionBundle();
            builder.setParent(editorPart.getSite().getShell());
            builder.setMessage(Messages.getString((String)"ETES_VOUS_CERTAINS_VOULOIR_ANNULER_LES_MODIFICAITONS", (String[])new String[0]));
            builder.setButtonLabels(MessageUtil.YES, MessageUtil.NO);
            builder.setDefaultButton(1);
            if (builder.buildAndOpen() == 0) {
                MyProgressMonitorDialog progressMonitorDialog2 = new MyProgressMonitorDialog(editorPart.getSite().getShell());
                progressMonitorDialog2.setOpenOnRun(true);
                progressMonitorDialog2.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Annulation en cours...", -1);
                        part.doCancel(monitor);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error on doCancel " + part.getClass().getName(), e);
        }
        return null;
    }

    @Override
    protected EvaluationResult evaluate(IEvaluationContext context) {
        IWorkbenchWindow window = InternalHandlerUtil.getActiveWorkbenchWindow(context);
        if (window == null) {
            return EvaluationResult.FALSE;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return EvaluationResult.FALSE;
        }
        ICancelablePart part = this.getCancelablePart(context);
        if (part == null) {
            return EvaluationResult.FALSE;
        }
        if (part != null && part.isDirty()) {
            return EvaluationResult.TRUE;
        }
        return EvaluationResult.FALSE;
    }
}

