/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.calendarcombo;

import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.calendarcombo.LocalDateFactory;
import ca.infodata.ofys.ui.controls.calendarcombo.MyColorManager;
import ca.infodata.ofys.ui.controls.calendarcombo.MySettings;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.IRelativeDate;
import ca.infodata.util1.date.LocalDate;
import java.util.Calendar;
import org.eclipse.nebula.widgets.calendarcombo.CalendarComposite2;
import org.eclipse.nebula.widgets.calendarcombo.IColorManager;
import org.eclipse.nebula.widgets.calendarcombo.IDateFactory;
import org.eclipse.nebula.widgets.calendarcombo.ISettings;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MyCalendarText
extends FontAwareComposite
implements IControl {
    public static final int SKIP_BUTTONS_ON_TAB = 131072;
    private static final LocalDateFactory dateFactory = new LocalDateFactory();
    private DateText text;
    private CalendarComposite2 datetime;
    private Button btnShowCalendar;
    private DateTime nativeDatetime;
    private Shell calendarShell;
    private ISettings settings = new MySettings();
    private IColorManager colorManager = new MyColorManager();
    private boolean skipButtonsOnTab;

    public MyCalendarText(Composite parent, FormToolkit toolkit) {
        this(parent, 0, toolkit);
    }

    public MyCalendarText(Composite parent, int style) {
        this(parent, style, null, true);
    }

    public MyCalendarText(Composite parent, int style, FormToolkit toolkit) {
        this(parent, style, toolkit, true);
    }

    public MyCalendarText(Composite parent, int style, FormToolkit toolkit, boolean withButton) {
        super(parent, style & 0xFFFFF7FF);
        this.skipButtonsOnTab = UI.containsStyle((int)131072, (int)style);
        this.text = new DateText(this, 18436, toolkit);
        if (withButton) {
            if (toolkit == null) {
                this.btnShowCalendar = new Button((Composite)this, 0x800000);
                this.btnShowCalendar.setText("...");
            } else {
                this.btnShowCalendar = toolkit.createButton((Composite)this, "...", 0x800000);
            }
        }
        if (toolkit != null) {
            toolkit.adapt((Composite)this);
        }
        this.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.width = UI.stringExtent((Control)this.text.getControl(), (String)"2222-22-22 ").x;
        this.text.setLayoutData(data);
        if (withButton) {
            data.left = new FormAttachment(0);
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.width = UI.stringExtent((Control)this.text.getControl(), (String)"2222-22-22 ").x;
            this.text.setLayoutData(data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(this.text.getControl(), 0, 1024);
            data.left = new FormAttachment(this.text.getControl());
            data.width = 20;
            this.btnShowCalendar.setLayoutData((Object)data);
        }
        Listener closeCalendarListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 3) {
                    MyCalendarText.this.closeCalendar();
                } else if (e.type == 8) {
                    MyCalendarText.this.showCalendar();
                }
            }
        };
        this.text.addListener(3, closeCalendarListener);
        this.text.addListener(8, closeCalendarListener);
        this.addListener(23, new Listener(){

            public void handleEvent(Event e) {
                MyCalendarText.this.closeCalendar();
            }
        });
        ControlListener controlListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                MyCalendarText.this.setCalendarLocation();
            }

            public void controlResized(ControlEvent e) {
                MyCalendarText.this.setCalendarLocation();
            }
        };
        this.getShell().addControlListener(controlListener);
        this.addControlListener(controlListener);
        Listener disposeListener = new Listener(){

            public void handleEvent(Event e) {
                MyCalendarText.this.disposeCalendar();
            }
        };
        this.addListener(12, disposeListener);
        Listener showCalendarListener = new Listener(){

            public void handleEvent(Event e) {
                if (!UI.CTRL((Event)e) && (UI.CR((Event)e) || e.keyCode == 0x1000002) && MyCalendarText.this.getTextControl().getEditable()) {
                    MyCalendarText.this.showCalendar();
                }
            }
        };
        this.text.addListener(1, showCalendarListener);
        if (withButton) {
            this.btnShowCalendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (MyCalendarText.this.isCalendarVisible()) {
                        MyCalendarText.this.closeCalendar();
                    } else {
                        MyCalendarText.this.showCalendar();
                    }
                }
            });
        }
        if (withButton && !this.skipButtonsOnTab) {
            this.setTabList(new Control[]{this.text.getControl(), this.btnShowCalendar});
        } else {
            this.setTabList(new Control[]{this.text.getControl()});
        }
    }

    public LocalDate getDate() {
        return this.text.getDate();
    }

    public IRelativeDate getRelativeDate() {
        return this.text.getRelativeDate();
    }

    public Calendar getDateCalendar() {
        LocalDate date = this.getDate();
        return date == null ? null : date.toCalendar();
    }

    public IPartialDate getPartialDate() {
        return this.text.getPartialDate();
    }

    public void setRelativeDate(IRelativeDate date) {
        this.text.setRelativeDate(date);
    }

    public void setDate(IPartialDate date) {
        this.text.setDate(date);
    }

    public void setDate2(Calendar date) {
        this.text.setDate((IPartialDate)LocalDate.fromCalendar((Calendar)date));
    }

    public void addDateListener(DateText.IDateListener listener) {
        this.text.addDateListener(listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(wHint, hHint, changed);
    }

    @Override
    public Control getControl() {
        return this;
    }

    public void removeCalendarListener(DateText.IDateListener listener) {
        this.text.removeDateListener(listener);
    }

    public DateText getTextControl() {
        return this.text;
    }

    public Button getButtonControl() {
        return this.btnShowCalendar;
    }

    private void disposeCalendar() {
        if (this.calendarShell != null && !this.calendarShell.isDisposed()) {
            this.calendarShell.close();
            this.calendarShell.dispose();
        }
    }

    public void closeCalendar() {
        if (this.isCalendarVisible()) {
            this.calendarShell.setVisible(false);
        }
    }

    public boolean isCalendarVisible() {
        return this.calendarShell != null && !this.calendarShell.isDisposed() && this.calendarShell.isVisible();
    }

    public void showCalendar() {
        if (UI.OS_CARBON || UI.OS_COCOA) {
            this.showCustomCalendar();
        } else {
            this.showNativeCalendar();
        }
    }

    private void showCustomCalendar() {
        if (!this.isDisposed() && this.calendarShell == null || this.calendarShell.isDisposed()) {
            Display display = this.text.getDisplay();
            Shell activeShell = display.getActiveShell();
            this.calendarShell = new Shell(activeShell, 65544);
            this.calendarShell.setVisible(false);
            this.calendarShell.setLayout((Layout)new FillLayout());
            if (UI.OS_CARBON) {
                this.calendarShell.setSize(this.settings.getCalendarWidthMacintosh(), this.settings.getCalendarHeightMacintosh());
            } else {
                this.calendarShell.setSize(this.settings.getCalendarWidth(), this.settings.getCalendarHeight());
            }
            this.datetime = new CalendarComposite2((Composite)this.calendarShell, this.colorManager, this.settings, (IDateFactory)dateFactory);
            this.datetime.addDateListener(new CalendarComposite2.IDateListener(){

                public void dateChanged(Object date) {
                    if (!MyCalendarText.this.isDisposed()) {
                        MyCalendarText.this.text.setDate((IPartialDate)((LocalDate)date));
                    }
                    MyCalendarText.this.closeCalendar();
                }
            });
            this.datetime.addListener(1, new Listener(){

                public void handleEvent(Event e) {
                    if (e.keyCode == 27) {
                        MyCalendarText.this.closeCalendar();
                    }
                }
            });
        }
        LocalDate date = this.text.getDate();
        LocalDate today = LocalDate.today();
        if (date == null) {
            date = today;
        } else if (date instanceof IPartialDate) {
            date = LocalDate.from((IPartialDate)date);
        }
        date = date == null ? today : date;
        this.datetime.setReferenceDate((Object)date);
        this.datetime.selectDate((Object)date);
        this.setCalendarLocation();
        this.calendarShell.setVisible(true);
        this.calendarShell.setFocus();
    }

    private void showNativeCalendar() {
        if (!this.isDisposed() && this.calendarShell == null || this.calendarShell.isDisposed()) {
            Display display = this.text.getDisplay();
            Shell activeShell = display.getActiveShell();
            this.calendarShell = new Shell(activeShell, 65544);
            this.calendarShell.setVisible(false);
            FormLayout layout = new FormLayout();
            layout.spacing = 5;
            this.calendarShell.setLayout((Layout)layout);
            this.nativeDatetime = new DateTime((Composite)this.calendarShell, UI.OS_WINDOWS ? 1024 : 1024);
            FormData data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            data.bottom = new FormAttachment(100);
            this.nativeDatetime.setLayoutData((Object)data);
            this.nativeDatetime.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (UI.CR((KeyEvent)e) && MyCalendarText.this.isCalendarVisible()) {
                        if (!MyCalendarText.this.isDisposed()) {
                            int day = MyCalendarText.this.nativeDatetime.getDay();
                            int year = MyCalendarText.this.nativeDatetime.getYear();
                            int month = MyCalendarText.this.nativeDatetime.getMonth();
                            MyCalendarText.this.text.setDate((IPartialDate)LocalDate.from((int)day, (int)(month + 1), (int)year));
                        }
                        MyCalendarText.this.closeCalendar();
                    }
                }
            });
            this.nativeDatetime.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (!MyCalendarText.this.isDisposed()) {
                        int day = MyCalendarText.this.nativeDatetime.getDay();
                        int year = MyCalendarText.this.nativeDatetime.getYear();
                        int month = MyCalendarText.this.nativeDatetime.getMonth();
                        MyCalendarText.this.text.setDate((IPartialDate)LocalDate.from((int)day, (int)(month + 1), (int)year));
                    }
                    MyCalendarText.this.closeCalendar();
                }
            });
        }
        LocalDate date = this.text.getDate();
        LocalDate today = LocalDate.today();
        if (date == null) {
            date = today;
        } else if (date instanceof IPartialDate) {
            date = LocalDate.from((IPartialDate)date);
        }
        date = date == null ? today : date;
        this.nativeDatetime.setDate(date.getYear().intValue(), date.getMonth() - 1, date.getDay().intValue());
        this.nativeDatetime.setFont(ResourceGetter.getFont((String)ResourceGetter.P_LOCAL_FONT, (int)12, (int)0, (boolean)true));
        this.calendarShell.pack();
        this.setCalendarLocation();
        this.calendarShell.setVisible(true);
        this.calendarShell.setFocus();
    }

    private void setCalendarLocation() {
        if (!this.isDisposed() && this.calendarShell != null && !this.calendarShell.isDisposed()) {
            Control textControl = this.text.getControl();
            Point calLoc = textControl.getLocation();
            Point size = textControl.getSize();
            Point loc = new Point(calLoc.x - 2, calLoc.y + size.y);
            loc = textControl.toDisplay(loc);
            if (loc.x < 0) {
                loc.x = 0;
            }
            this.calendarShell.setLocation(loc);
        }
    }

    public boolean setFocus() {
        return this.text.setFocus();
    }

    public boolean hasFocus2() {
        return this.text != null && UI.hasFocus((Control)this.text.getControl()) || this.calendarShell != null && UI.hasFocus((Control)this.calendarShell);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(2, false));
        MyCalendarText text = new MyCalendarText((Composite)shell, 2048);
        text.addDateListener(new DateText.IDateListener(){

            @Override
            public void dateChanged(LocalDate date) {
                System.out.println("date changed + " + date);
            }

            @Override
            public void partialChanged(IPartialDate date) {
                System.out.println("date changed + " + date);
            }
        });
        new Text((Composite)shell, 18436);
        shell.pack();
        shell.setSize(500, 200);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

